/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.lib.Resources;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.OpenDogScreenData;
import doggytalents.common.talent.PackPuppyTalent;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.client.event.ScreenEvent;

public class DogInventoryButton
extends AbstractButton {
    private Screen parent;
    private int baseX;
    private boolean openSingle = false;
    private Optional<Dog> openSingleDog = Optional.empty();
    private Font font;
    private final Tooltip TOOLTIP_ACTIVE = Tooltip.create((Component)Component.translatable((String)"container.doggytalents.dog_inventories.link"));
    private final Tooltip TOOLTIP_NO_ACTIVE = Tooltip.create((Component)Component.translatable((String)"container.doggytalents.dog_inventories.link").withStyle(ChatFormatting.RED));
    private static DogInventoryButton inventoryButton;

    public DogInventoryButton(int x, int y, Screen parentIn) {
        super(x, y, 13, 10, (Component)Component.literal((String)""));
        this.baseX = x;
        this.parent = parentIn;
        this.font = Minecraft.getInstance().font;
    }

    public DogInventoryButton(int x, int y, Screen parentIn, Dog dog) {
        super(x, y, 13, 10, (Component)Component.literal((String)""));
        this.baseX = x;
        this.parent = parentIn;
        this.openSingleDog = Optional.of(dog);
        this.font = Minecraft.getInstance().font;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.parent instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen cscreen = (CreativeModeInventoryScreen)this.parent;
            this.active = this.visible = cscreen.isInventoryOpen();
        }
        if (this.parent instanceof InventoryScreen) {
            RecipeBookComponent recipeBook = ((InventoryScreen)this.parent).getRecipeBookComponent();
            if (recipeBook.isVisible()) {
                this.setX(this.baseX + 77);
            } else {
                this.setX(this.baseX);
            }
        }
        if (this.visible) {
            Minecraft mc = Minecraft.getInstance();
            List dogs = mc.level.getEntitiesOfClass(Dog.class, mc.player.getBoundingBox().inflate(12.0, 12.0, 12.0), dog -> dog.canInteract((LivingEntity)mc.player) && PackPuppyTalent.hasInventory(dog));
            boolean bl = this.active = !dogs.isEmpty();
            if (this.active) {
                this.setTooltip(this.TOOLTIP_ACTIVE);
            } else {
                this.setTooltip(this.TOOLTIP_NO_ACTIVE);
            }
        }
        this.renderWidget2(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderWidget2(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        Minecraft mc = Minecraft.getInstance();
        int i = this.getTextureY();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        graphics.blit(Resources.SMALL_WIDGETS, this.getX(), this.getY(), 0, 36 + i * 10, this.width, this.height);
        if (this.openSingle) {
            int tX = this.getX() + 11;
            int tY = this.getY() + 5;
            graphics.drawString(this.font, "x1", tX, tY, -1);
        }
    }

    private int getTextureY() {
        int i = 1;
        if (!this.active) {
            i = 0;
        } else if (this.isHoveredOrFocused()) {
            i = 2;
        }
        return i;
    }

    public void onPress() {
        Minecraft mc = Minecraft.getInstance();
        if (this.openSingle && this.openSingleDog.isPresent()) {
            Dog dog = this.openSingleDog.get();
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new OpenDogScreenData(OpenDogScreenData.ScreenType.INVENTORY_SINGLE, dog.getId()));
        } else {
            AbstractContainerScreen container;
            Screen screen = mc.screen;
            boolean do_close_container = screen instanceof AbstractContainerScreen && (container = (AbstractContainerScreen)screen).getMenu() == mc.player.inventoryMenu;
            PacketHandler.send(PacketDistributor.SERVER.noArg(), OpenDogScreenData.dogInventory(do_close_container));
        }
        this.active = false;
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    public void keyGlobalPressed(int keyCode, int scanCode, int modifier) {
        Minecraft mc = Minecraft.getInstance();
        KeyMapping shiftKey = mc.options.keyShift;
        if (shiftKey.getKey().getValue() == keyCode && this.openSingleDog.isPresent()) {
            this.openSingle = true;
        }
    }

    public void keyGlobalReleased(int keyCode, int scanCode, int modifier) {
        this.openSingle = false;
    }

    public static void onScreenInit(ScreenEvent.Init.Post event) {
        boolean is_survival;
        Screen screen = event.getScreen();
        boolean bl = is_survival = screen != null && screen.getClass() == InventoryScreen.class;
        if (!is_survival) {
            return;
        }
        if (!((Boolean)ConfigHandler.CLIENT.DOG_INV_BUTTON_IN_INV.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        int screen_w = mc.getWindow().getGuiScaledWidth();
        int screen_h = mc.getWindow().getGuiScaledHeight();
        int inv_w = 176;
        int inv_h = 166;
        int inv_x = (screen_w - inv_w) / 2;
        int inv_y = (screen_h - inv_h) / 2;
        int button_x_offset = (Integer)ConfigHandler.CLIENT.DOG_INV_IN_INV_BUTTON_X.get();
        int button_y_offset = (Integer)ConfigHandler.CLIENT.DOG_INV_IN_INV_BUTTON_Y.get();
        int button_x = inv_x + button_x_offset;
        int button_y = inv_y + button_y_offset;
        inventoryButton = new DogInventoryButton(button_x, button_y, screen);
        event.addListener((GuiEventListener)inventoryButton);
    }

    public static void onScreenRenderForeground(ScreenEvent.Render.Post event) {
    }
}

