/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.AmnesiaBoneScreen.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.screen.framework.widget.TextOnlyButton;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.ForceClearKillStatsData;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;

public class KillStatsClearConfirmScreen
extends Screen {
    Dog dog;

    protected KillStatsClearConfirmScreen(Dog dog) {
        super((Component)Component.literal((String)""));
        this.dog = dog;
    }

    public static void open(Dog dog) {
        Minecraft mc = Minecraft.getInstance();
        KillStatsClearConfirmScreen screen = new KillStatsClearConfirmScreen(dog);
        mc.setScreen((Screen)screen);
    }

    protected void init() {
        this.addConfirmButton();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        super.render(graphics, mouseX, mouseY, pTicks);
        PoseStack stack = graphics.pose();
        int mX = this.width / 2;
        int mY = this.height / 2;
        int pY = mY - 72;
        MutableComponent title = Component.translatable((String)"doggui.clear_dog_kill_stats.confirm.title").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED));
        String help = I18n.get((String)"doggui.clear_dog_kill_stats.confirm.subtitle", (Object[])new Object[]{this.dog.getName().getString()});
        String dog_title = I18n.get((String)"doggui.invalid_dog.info.dog", (Object[])new Object[]{this.dog.getName().getString()});
        String owner_title = I18n.get((String)"doggui.invalid_dog.info.owner", (Object[])new Object[]{this.dog.getOwnersName().orElse((Component)Component.literal((String)"")).getString()});
        String escToReturn = I18n.get((String)"doggui.invalid_dog.esc_to_return", (Object[])new Object[0]);
        stack.pushPose();
        stack.scale(1.2f, 1.2f, 1.2f);
        graphics.drawString(this.font, (Component)title, Mth.floor((float)((float)mX / 1.2f - (float)(this.font.width((FormattedText)title) / 2))), Mth.floor((float)((float)pY / 1.2f)), -1);
        stack.popPose();
        graphics.drawString(this.font, help, mX - this.font.width(help) / 2, pY += 40, -1);
        graphics.drawString(this.font, dog_title, mX - this.font.width(dog_title) / 2, pY += 40, -1);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, owner_title, mX - this.font.width(owner_title) / 2, pY += 9 + 3, -1);
        graphics.drawString(this.font, escToReturn, mX - this.font.width(escToReturn) / 2, pY += 80, -1);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void addConfirmButton() {
        CustomButton clearButton = new CustomButton(this.width / 2 - 25, this.height / 2 + 58, 50, 20, (Component)Component.translatable((String)"doggui.untame.confirm.confirmed"), b -> {
            this.requestClearKillStats();
            Minecraft.getInstance().setScreen(null);
        });
        LocalPlayer player = Minecraft.getInstance().player;
        this.addRenderableWidget((GuiEventListener)clearButton);
    }

    private void requestClearKillStats() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new ForceClearKillStatsData(this.dog.getId()));
    }

    public static void addClearKillStatsButton(Dog dog, Font font, int mid_x, int y, Consumer<TextOnlyButton> button_consumer) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (!player.hasPermissions(4)) {
            return;
        }
        MutableComponent str = Component.literal((String)"Clear Kill Stats");
        int str_width = font.width((FormattedText)str);
        int button_width = str_width + 4;
        int n = mid_x - button_width / 2;
        Objects.requireNonNull(font);
        button_consumer.accept(new TextOnlyButton(n, y, button_width, 9 + 2, (Component)str.withStyle(ChatFormatting.RED), b -> KillStatsClearConfirmScreen.open(dog), font));
    }
}

