/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.sound;

import doggytalents.common.entity.Dog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class DogInterruptibleSoundInstance
extends AbstractTickableSoundInstance {
    private static final int FADE_OUT_TIME = 5;
    private final Dog dog;
    private int stoppingTick = 0;
    private boolean isStopping = false;
    private float fadeSpeed = 0.0f;

    public DogInterruptibleSoundInstance(Dog dog, SoundEvent event, float vol, float pitch) {
        super(event, SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.dog = dog;
        this.volume = vol;
        this.pitch = pitch;
        this.x = (float)dog.getX();
        this.y = (float)dog.getY();
        this.z = (float)dog.getZ();
    }

    public void dogInterupt() {
        this.isStopping = true;
        this.volume /= 4.0f;
        this.fadeSpeed = this.volume / 5.0f;
    }

    public void tick() {
        if (this.isStopping) {
            this.tickStop();
            return;
        }
        this.updatePositionVolumeOrInvalidate();
    }

    private void updatePositionVolumeOrInvalidate() {
        if (!this.dog.isAlive()) {
            this.dogInterupt();
            return;
        }
        this.x = (float)this.dog.getX();
        this.y = (float)this.dog.getY();
        this.z = (float)this.dog.getZ();
    }

    private void tickStop() {
        ++this.stoppingTick;
        this.volume = Math.max(0.0f, this.volume - this.fadeSpeed);
    }

    public boolean isStopped() {
        return super.isStopped() || this.isStopping && this.stoppingTick > 5;
    }

    public boolean isLooping() {
        return false;
    }

    public boolean canPlaySound() {
        return !this.dog.isSilent();
    }

    public static DogInterruptibleSoundInstance createAndPlayClient(Dog dog, SoundEvent event, float vol, float pitch) {
        DogInterruptibleSoundInstance inst = new DogInterruptibleSoundInstance(dog, event, vol, pitch);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)inst);
        return inst;
    }
}

