/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.DoggyTalents;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.DogRescueModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.entity.Dog;
import doggytalents.common.lib.Resources;
import doggytalents.common.talent.RescueDogTalent;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class RescueDogRenderer
extends RenderLayer<Dog, DogModel> {
    private DogRescueModel model;

    public RescueDogRenderer(RenderLayerParent parentRenderer, EntityRendererProvider.Context ctx) {
        super(parentRenderer);
        this.model = new DogRescueModel(ctx.bakeLayer(ClientSetup.DOG_RESCUE_BOX));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DogModel model;
        if (dog.isInvisible()) {
            return;
        }
        DogSkin dogSkin = dog.getClientSkin();
        if (dogSkin.useCustomModel() && !(model = dogSkin.getCustomModel().getValue()).armorShouldRender(dog)) {
            return;
        }
        List<AccessoryInstance> accessories = dog.getAccessories();
        for (AccessoryInstance acc : accessories) {
            if (acc.getAccessory().getType() != DoggyAccessoryTypes.BOWTIE.get()) continue;
            return;
        }
        Optional<RescueDogTalent> inst = dog.getTalent(DoggyTalents.RESCUE_DOG).map(x -> x.cast(RescueDogTalent.class));
        if (inst.isPresent() && inst.get().renderBox()) {
            DogModel dogModel = (DogModel)this.getParentModel();
            dogModel.copyPropertiesTo(this.model);
            this.model.sync(dogModel);
            RenderLayer.renderColoredCutoutModel((EntityModel)this.model, (ResourceLocation)Resources.TALENT_RESCUE, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (int)-1);
        }
    }
}

