/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model.dog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.events.RegisterCustomDogModelsEvent;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;
import org.joml.Vector3f;

public class CustomDogModel
extends DogModel {
    private final RegisterCustomDogModelsEvent.DogModelProps props;
    private ModelPart glowingEyes;
    private ModelPart realGlowingEyes;

    public CustomDogModel(ModelPart box, RegisterCustomDogModelsEvent.DogModelProps props) {
        super(box);
        this.props = props;
        if (this.props.glowingEyes) {
            this.setupGlowingEyes();
        }
    }

    private void setupGlowingEyes() {
        this.glowingEyes = this.root.getChild("glowing_eyes");
        this.realGlowingEyes = this.glowingEyes.getChild("real_glowing_eyes");
    }

    @Override
    public boolean acessoryShouldRender(Dog dog, AccessoryInstance inst) {
        if (this.props.renderModelAccessoriesOnly) {
            return inst.getAccessory().getAccessoryRenderType() == Accessory.AccessoryRenderType.MODEL;
        }
        return this.props.shouldRenderAccessories;
    }

    @Override
    public boolean incapShouldRender(Dog dog) {
        return this.props.shouldRenderIncapacitated;
    }

    @Override
    public boolean scaleBabyDog() {
        return false;
    }

    @Override
    @Nullable
    public Vector3f getCustomRootPivotPoint() {
        return this.props.customRootPivot;
    }

    @Override
    public boolean hasDefaultScale() {
        return this.props.hasDefaultScale;
    }

    @Override
    public float getDefaultScale() {
        return this.props.defaultScale;
    }

    @Override
    public boolean armorShouldRender(Dog dog) {
        return false;
    }

    @Override
    public DogModel.AccessoryState getAccessoryState() {
        if (this.props.shouldRenderAccessories) {
            return DogModel.AccessoryState.HAVE_NOT_TESTED;
        }
        if (this.props.renderModelAccessoriesOnly) {
            return DogModel.AccessoryState.MODEL_ONLY;
        }
        return DogModel.AccessoryState.NON_COMPATIBLE;
    }

    @Override
    public void setupAnim(Dog dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.props.glowingEyes) {
            this.glowingEyes.copyFrom(this.head);
            this.realGlowingEyes.copyFrom(this.realHead);
        }
    }

    @Override
    protected AnimationDefinition getAnimationSequence(DogAnimation anim) {
        Map<DogAnimation, AnimationDefinition> animOverride = this.props.getAnimOverride();
        if (animOverride.isEmpty()) {
            return super.getAnimationSequence(anim);
        }
        AnimationDefinition animDef = animOverride.get((Object)anim);
        if (animDef == null) {
            return super.getAnimationSequence(anim);
        }
        return animDef;
    }

    @Override
    public void renderToBuffer(PoseStack stack, VertexConsumer vertex_consumer, int light, int overlay, int color_overlay) {
        if (this.props.glowingEyes) {
            this.glowingEyes.visible = false;
            this.realGlowingEyes.visible = false;
        }
        super.renderToBuffer(stack, vertex_consumer, light, overlay, color_overlay);
    }

    @Override
    protected Optional<DogModel.AddtionalHeadRenderer> getDogModelAdditionalHeadRenderer() {
        return Optional.of(this::renderGlowingEyes);
    }

    private void renderGlowingEyes(PoseStack stack, Optional<DogModel.DogRenderPartContext> part_ctx_optional) {
        if (!this.props.glowingEyes) {
            return;
        }
        if (!part_ctx_optional.isPresent()) {
            return;
        }
        DogModel.DogRenderPartContext part_ctx = part_ctx_optional.get();
        if (this.head.visible) {
            this.glowingEyes.visible = true;
            this.realGlowingEyes.visible = true;
            part_ctx.renderGlowingPart(stack, this.glowingEyes);
            this.glowingEyes.visible = false;
            this.realGlowingEyes.visible = false;
        }
    }
}

