/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.registry;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class Accessory {
    @Nullable
    private String translationKey;
    @Deprecated
    private final Supplier<ItemStack> stack;
    @Deprecated
    private final Supplier<? extends AccessoryType> type;
    private boolean isDogStillNakedWhenWear = false;
    private ResourceLocation modelTexture;
    private boolean renderTranslucent = false;
    private boolean hasHindLegDiffTex = false;
    private AccessoryRenderType accessoryRenderType = AccessoryRenderType.OVERLAY;

    public Accessory(Supplier<? extends AccessoryType> typeIn, Supplier<ItemStack> stackIn, int x) {
        this.type = typeIn;
        this.stack = stackIn;
    }

    public Accessory(Supplier<? extends AccessoryType> typeIn, Supplier<? extends ItemLike> itemIn) {
        this(typeIn, () -> new ItemStack((ItemLike)itemIn.get()), 0);
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.makeDescriptionId((String)"accessory", (ResourceLocation)DoggyTalentsAPI.ACCESSORIES.get().getKey((Object)this));
        }
        return this.translationKey;
    }

    public byte getRenderLayer() {
        return 0;
    }

    public AccessoryInstance getDefault() {
        return new AccessoryInstance(this);
    }

    public AccessoryInstance createInstance(FriendlyByteBuf buf) {
        return this.getDefault();
    }

    public AccessoryInstance read(CompoundTag compound) {
        return this.getDefault();
    }

    public void write(AccessoryInstance instance, FriendlyByteBuf buf) {
    }

    public void write(AccessoryInstance instance, CompoundTag compound) {
    }

    public AccessoryInstance createFromStack(ItemStack stackIn) {
        return this.getDefault();
    }

    public ItemStack getReturnItem(AccessoryInstance instance) {
        return this.stack.get();
    }

    public final AccessoryType getType() {
        return this.type.get();
    }

    public <T extends Accessory> boolean of(Supplier<T> accessoryIn) {
        return this.of((Accessory)accessoryIn.get());
    }

    public <T extends Accessory> boolean of(T accessoryIn) {
        return accessoryIn == this;
    }

    public boolean isDogStillNakedWhenWear() {
        return this.isDogStillNakedWhenWear;
    }

    public boolean shouldRender() {
        return true;
    }

    public <T extends Accessory> T setDogStillNakedWhenWear(boolean val) {
        this.isDogStillNakedWhenWear = val;
        return (T)this;
    }

    public <T extends Accessory> T setModelTexture(ResourceLocation modelTextureIn) {
        this.modelTexture = modelTextureIn;
        return (T)this;
    }

    @Nullable
    public ResourceLocation getModelTexture() {
        return this.modelTexture;
    }

    public boolean renderTranslucent() {
        return this.renderTranslucent;
    }

    public <T extends Accessory> T setRenderTranslucent(boolean translucent) {
        this.renderTranslucent = translucent;
        return (T)this;
    }

    public boolean hasHindLegDiffTex() {
        return this.hasHindLegDiffTex;
    }

    public <T extends Accessory> T setHasHindLegDiffTex(boolean val) {
        this.hasHindLegDiffTex = val;
        return (T)this;
    }

    public <T extends Accessory> T setAccessoryRenderType(AccessoryRenderType type) {
        this.accessoryRenderType = type;
        return (T)this;
    }

    public AccessoryRenderType getAccessoryRenderType() {
        return this.accessoryRenderType;
    }

    public static enum AccessoryRenderType {
        OVERLAY,
        MODEL,
        OVERLAY_AND_MODEL;

    }
}

