/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.word;

import org.cyclops.integratedscripting.vendors.org.graalvm.word.ComparableWord;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.LocationIdentity;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.Pointer;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.SignedWord;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.UnsignedWord;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.WordBase;

final class Word
implements SignedWord,
UnsignedWord,
Pointer {
    private final long rawValue;

    Word(long val) {
        this.rawValue = val;
    }

    static <T extends WordBase> T box(long val) {
        return (T)new Word(val);
    }

    @Override
    public native Object toObject();

    @Override
    public native <T> T toObject(Class<T> var1, boolean var2);

    @Override
    public native Object toObjectNonNull();

    @Override
    public native byte readByte(WordBase var1, LocationIdentity var2);

    @Override
    public native char readChar(WordBase var1, LocationIdentity var2);

    @Override
    public native short readShort(WordBase var1, LocationIdentity var2);

    @Override
    public native int readInt(WordBase var1, LocationIdentity var2);

    @Override
    public native long readLong(WordBase var1, LocationIdentity var2);

    @Override
    public native float readFloat(WordBase var1, LocationIdentity var2);

    @Override
    public native double readDouble(WordBase var1, LocationIdentity var2);

    @Override
    public native <T extends WordBase> T readWord(WordBase var1, LocationIdentity var2);

    @Override
    public native Object readObject(WordBase var1, LocationIdentity var2);

    @Override
    public native byte readByte(int var1, LocationIdentity var2);

    @Override
    public native char readChar(int var1, LocationIdentity var2);

    @Override
    public native short readShort(int var1, LocationIdentity var2);

    @Override
    public native int readInt(int var1, LocationIdentity var2);

    @Override
    public native long readLong(int var1, LocationIdentity var2);

    @Override
    public native float readFloat(int var1, LocationIdentity var2);

    @Override
    public native double readDouble(int var1, LocationIdentity var2);

    @Override
    public native <T extends WordBase> T readWord(int var1, LocationIdentity var2);

    @Override
    public native Object readObject(int var1, LocationIdentity var2);

    @Override
    public native <T extends WordBase> T readWordVolatile(int var1, LocationIdentity var2);

    @Override
    public native void writeByte(WordBase var1, byte var2, LocationIdentity var3);

    @Override
    public native void writeChar(WordBase var1, char var2, LocationIdentity var3);

    @Override
    public native void writeShort(WordBase var1, short var2, LocationIdentity var3);

    @Override
    public native void writeInt(WordBase var1, int var2, LocationIdentity var3);

    @Override
    public native void writeLong(WordBase var1, long var2, LocationIdentity var4);

    @Override
    public native void writeFloat(WordBase var1, float var2, LocationIdentity var3);

    @Override
    public native void writeDouble(WordBase var1, double var2, LocationIdentity var4);

    @Override
    public native void writeWord(WordBase var1, WordBase var2, LocationIdentity var3);

    @Override
    public void initializeLong(WordBase offset, long val, LocationIdentity locationIdentity) {
    }

    @Override
    public native void writeObject(WordBase var1, Object var2, LocationIdentity var3);

    @Override
    public native void writeByte(int var1, byte var2, LocationIdentity var3);

    @Override
    public native void writeChar(int var1, char var2, LocationIdentity var3);

    @Override
    public native void writeShort(int var1, short var2, LocationIdentity var3);

    @Override
    public native void writeInt(int var1, int var2, LocationIdentity var3);

    @Override
    public native void writeLong(int var1, long var2, LocationIdentity var4);

    @Override
    public native void writeFloat(int var1, float var2, LocationIdentity var3);

    @Override
    public native void writeDouble(int var1, double var2, LocationIdentity var4);

    @Override
    public native void writeWord(int var1, WordBase var2, LocationIdentity var3);

    @Override
    public void initializeLong(int offset, long val, LocationIdentity locationIdentity) {
    }

    @Override
    public native void writeObject(int var1, Object var2, LocationIdentity var3);

    @Override
    public native byte readByte(WordBase var1);

    @Override
    public native char readChar(WordBase var1);

    @Override
    public native short readShort(WordBase var1);

    @Override
    public native int readInt(WordBase var1);

    @Override
    public native long readLong(WordBase var1);

    @Override
    public native float readFloat(WordBase var1);

    @Override
    public native double readDouble(WordBase var1);

    @Override
    public native <T extends WordBase> T readWord(WordBase var1);

    @Override
    public native Object readObject(WordBase var1);

    @Override
    public native byte readByte(int var1);

    @Override
    public native char readChar(int var1);

    @Override
    public native short readShort(int var1);

    @Override
    public native int readInt(int var1);

    @Override
    public native long readLong(int var1);

    @Override
    public native float readFloat(int var1);

    @Override
    public native double readDouble(int var1);

    @Override
    public native <T extends WordBase> T readWord(int var1);

    @Override
    public native Object readObject(int var1);

    @Override
    public native void writeByte(WordBase var1, byte var2);

    @Override
    public native void writeChar(WordBase var1, char var2);

    @Override
    public native void writeShort(WordBase var1, short var2);

    @Override
    public native void writeInt(WordBase var1, int var2);

    @Override
    public native void writeLong(WordBase var1, long var2);

    @Override
    public native void writeFloat(WordBase var1, float var2);

    @Override
    public native void writeDouble(WordBase var1, double var2);

    @Override
    public native void writeWord(WordBase var1, WordBase var2);

    @Override
    public native void writeObject(WordBase var1, Object var2);

    @Override
    public native int compareAndSwapInt(WordBase var1, int var2, int var3, LocationIdentity var4);

    @Override
    public native long compareAndSwapLong(WordBase var1, long var2, long var4, LocationIdentity var6);

    @Override
    public native <T extends WordBase> T compareAndSwapWord(WordBase var1, T var2, T var3, LocationIdentity var4);

    @Override
    public native Object compareAndSwapObject(WordBase var1, Object var2, Object var3, LocationIdentity var4);

    @Override
    public boolean logicCompareAndSwapInt(WordBase offset, int expectedValue, int newValue, LocationIdentity locationIdentity) {
        return false;
    }

    @Override
    public boolean logicCompareAndSwapLong(WordBase offset, long expectedValue, long newValue, LocationIdentity locationIdentity) {
        return false;
    }

    @Override
    public boolean logicCompareAndSwapWord(WordBase offset, WordBase expectedValue, WordBase newValue, LocationIdentity locationIdentity) {
        return false;
    }

    @Override
    public boolean logicCompareAndSwapObject(WordBase offset, Object expectedValue, Object newValue, LocationIdentity locationIdentity) {
        return false;
    }

    @Override
    public native void writeByte(int var1, byte var2);

    @Override
    public native void writeChar(int var1, char var2);

    @Override
    public native void writeShort(int var1, short var2);

    @Override
    public native void writeInt(int var1, int var2);

    @Override
    public native void writeLong(int var1, long var2);

    @Override
    public native void writeFloat(int var1, float var2);

    @Override
    public native void writeDouble(int var1, double var2);

    @Override
    public native void writeWord(int var1, WordBase var2);

    @Override
    public native void writeObject(int var1, Object var2);

    @Override
    public native void writeWordVolatile(int var1, WordBase var2);

    @Override
    public native int compareAndSwapInt(int var1, int var2, int var3, LocationIdentity var4);

    @Override
    public native long compareAndSwapLong(int var1, long var2, long var4, LocationIdentity var6);

    @Override
    public native <T extends WordBase> T compareAndSwapWord(int var1, T var2, T var3, LocationIdentity var4);

    @Override
    public native Object compareAndSwapObject(int var1, Object var2, Object var3, LocationIdentity var4);

    @Override
    public native boolean logicCompareAndSwapInt(int var1, int var2, int var3, LocationIdentity var4);

    @Override
    public native boolean logicCompareAndSwapLong(int var1, long var2, long var4, LocationIdentity var6);

    @Override
    public native boolean logicCompareAndSwapWord(int var1, WordBase var2, WordBase var3, LocationIdentity var4);

    @Override
    public native boolean logicCompareAndSwapObject(int var1, Object var2, Object var3, LocationIdentity var4);

    @Override
    public Pointer add(UnsignedWord val) {
        return (Pointer)Word.box(this.rawValue + val.rawValue());
    }

    @Override
    public Pointer subtract(UnsignedWord val) {
        return (Pointer)Word.box(this.rawValue - val.rawValue());
    }

    @Override
    public UnsignedWord multiply(UnsignedWord val) {
        return (UnsignedWord)Word.box(this.rawValue * val.rawValue());
    }

    @Override
    public UnsignedWord unsignedDivide(UnsignedWord val) {
        return (UnsignedWord)Word.box(Long.divideUnsigned(this.rawValue, val.rawValue()));
    }

    @Override
    public UnsignedWord unsignedRemainder(UnsignedWord val) {
        return (UnsignedWord)Word.box(Long.remainderUnsigned(this.rawValue, val.rawValue()));
    }

    @Override
    public Pointer and(UnsignedWord val) {
        return (Pointer)Word.box(this.rawValue & val.rawValue());
    }

    @Override
    public Pointer or(UnsignedWord val) {
        return (Pointer)Word.box(this.rawValue | val.rawValue());
    }

    @Override
    public UnsignedWord xor(UnsignedWord val) {
        return (UnsignedWord)Word.box(this.rawValue ^ val.rawValue());
    }

    @Override
    public boolean isNull() {
        return this.rawValue == 0L;
    }

    @Override
    public boolean isNonNull() {
        return this.rawValue != 0L;
    }

    @Override
    public SignedWord add(SignedWord val) {
        return (SignedWord)Word.box(this.rawValue + val.rawValue());
    }

    @Override
    public SignedWord subtract(SignedWord val) {
        return (SignedWord)Word.box(this.rawValue - val.rawValue());
    }

    @Override
    public SignedWord multiply(SignedWord val) {
        return (SignedWord)Word.box(this.rawValue * val.rawValue());
    }

    @Override
    public SignedWord signedDivide(SignedWord val) {
        return (SignedWord)Word.box(this.rawValue / val.rawValue());
    }

    @Override
    public SignedWord signedRemainder(SignedWord val) {
        return (SignedWord)Word.box(this.rawValue % val.rawValue());
    }

    @Override
    public Word shiftLeft(UnsignedWord n) {
        return (Word)Word.box(this.rawValue << (int)n.rawValue());
    }

    @Override
    public UnsignedWord unsignedShiftRight(UnsignedWord n) {
        return (UnsignedWord)Word.box(this.rawValue >>> (int)n.rawValue());
    }

    @Override
    public SignedWord signedShiftRight(UnsignedWord n) {
        return (SignedWord)Word.box(this.rawValue >> (int)n.rawValue());
    }

    @Override
    public SignedWord and(SignedWord val) {
        return (SignedWord)Word.box(this.rawValue & val.rawValue());
    }

    @Override
    public SignedWord or(SignedWord val) {
        return (SignedWord)Word.box(this.rawValue | val.rawValue());
    }

    @Override
    public SignedWord xor(SignedWord val) {
        return (SignedWord)Word.box(this.rawValue ^ val.rawValue());
    }

    @Override
    public Word not() {
        return (Word)Word.box(this.rawValue ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean equal(UnsignedWord val) {
        return this.rawValue == val.rawValue();
    }

    @Override
    public boolean notEqual(UnsignedWord val) {
        return this.rawValue != val.rawValue();
    }

    @Override
    public boolean belowThan(UnsignedWord val) {
        return Long.compareUnsigned(this.rawValue, val.rawValue()) < 0;
    }

    @Override
    public boolean belowOrEqual(UnsignedWord val) {
        return Long.compareUnsigned(this.rawValue, val.rawValue()) <= 0;
    }

    @Override
    public boolean aboveThan(UnsignedWord val) {
        return Long.compareUnsigned(this.rawValue, val.rawValue()) > 0;
    }

    @Override
    public boolean aboveOrEqual(UnsignedWord val) {
        return Long.compareUnsigned(this.rawValue, val.rawValue()) >= 0;
    }

    @Override
    public boolean equal(SignedWord val) {
        return this.rawValue == val.rawValue();
    }

    @Override
    public boolean notEqual(SignedWord val) {
        return this.rawValue != val.rawValue();
    }

    @Override
    public boolean lessThan(SignedWord val) {
        return this.rawValue < val.rawValue();
    }

    @Override
    public boolean lessOrEqual(SignedWord val) {
        return this.rawValue <= val.rawValue();
    }

    @Override
    public boolean greaterThan(SignedWord val) {
        return this.rawValue > val.rawValue();
    }

    @Override
    public boolean greaterOrEqual(SignedWord val) {
        return this.rawValue >= val.rawValue();
    }

    @Override
    public Word add(int val) {
        return (Word)Word.box(this.rawValue + (long)val);
    }

    @Override
    public Word subtract(int val) {
        return (Word)Word.box(this.rawValue - (long)val);
    }

    @Override
    public Word multiply(int val) {
        return (Word)Word.box(this.rawValue * (long)val);
    }

    @Override
    public UnsignedWord unsignedDivide(int val) {
        return (UnsignedWord)Word.box(Long.divideUnsigned(this.rawValue, val));
    }

    @Override
    public UnsignedWord unsignedRemainder(int val) {
        return (UnsignedWord)Word.box(Long.remainderUnsigned(this.rawValue, val));
    }

    @Override
    public SignedWord signedDivide(int val) {
        return (SignedWord)Word.box(this.rawValue / (long)val);
    }

    @Override
    public SignedWord signedRemainder(int val) {
        return (SignedWord)Word.box(this.rawValue % (long)val);
    }

    @Override
    public Word shiftLeft(int n) {
        return (Word)Word.box(this.rawValue << n);
    }

    @Override
    public UnsignedWord unsignedShiftRight(int n) {
        return (UnsignedWord)Word.box(this.rawValue >>> n);
    }

    @Override
    public SignedWord signedShiftRight(int n) {
        return (SignedWord)Word.box(this.rawValue >> n);
    }

    @Override
    public Word and(int val) {
        return (Word)Word.box(this.rawValue & (long)val);
    }

    @Override
    public Word or(int val) {
        return (Word)Word.box(this.rawValue | (long)val);
    }

    @Override
    public Word xor(int val) {
        return (Word)Word.box(this.rawValue ^ (long)val);
    }

    @Override
    public boolean equal(int val) {
        return this.rawValue == 0L;
    }

    @Override
    public boolean notEqual(int val) {
        return this.rawValue != 0L;
    }

    @Override
    public boolean belowThan(int val) {
        return Long.compareUnsigned(this.rawValue, val) < 0;
    }

    @Override
    public boolean belowOrEqual(int val) {
        return Long.compareUnsigned(this.rawValue, val) <= 0;
    }

    @Override
    public boolean aboveThan(int val) {
        return Long.compareUnsigned(this.rawValue, val) > 0;
    }

    @Override
    public boolean aboveOrEqual(int val) {
        return Long.compareUnsigned(this.rawValue, val) >= 0;
    }

    @Override
    public boolean lessThan(int val) {
        return this.rawValue < (long)val;
    }

    @Override
    public boolean lessOrEqual(int val) {
        return this.rawValue <= (long)val;
    }

    @Override
    public boolean greaterThan(int val) {
        return this.rawValue > (long)val;
    }

    @Override
    public boolean greaterOrEqual(int val) {
        return this.rawValue >= (long)val;
    }

    @Override
    public boolean equal(ComparableWord val) {
        return this.rawValue == val.rawValue();
    }

    @Override
    public boolean notEqual(ComparableWord val) {
        return this.rawValue != val.rawValue();
    }

    @Override
    public long rawValue() {
        return this.rawValue;
    }
}

