/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.org.tukaani.xz.lz;

import java.nio.ByteOrder;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.org.tukaani.xz.lz.BasicMatchLengthFinder;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.org.tukaani.xz.lz.MatchLengthFinder;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.org.tukaani.xz.lz.UnalignedLongLEMatchLengthFinder;

final class MatchLength {
    static final int EXTRA_SIZE;
    private static final MatchLengthFinder matchLengthFinder;

    static int getLen(byte[] buf, int off, int delta, int len, int lenLimit) {
        assert (off >= 0);
        assert (delta > 0);
        assert (len >= 0);
        assert (lenLimit >= len);
        return matchLengthFinder.getLen(buf, off, delta, len, lenLimit);
    }

    private MatchLength() {
    }

    static {
        String prop = System.getProperty("org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.org.tukaani.xz.MatchLengthFinder");
        if (prop == null) {
            String arch = System.getProperty("os.arch");
            prop = arch != null && arch.matches("^(amd64|x86_64|aarch64)$") && ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "UnalignedLongLE" : "Basic";
        }
        switch (prop) {
            case "Basic": {
                matchLengthFinder = new BasicMatchLengthFinder();
                break;
            }
            case "UnalignedLongLE": {
                matchLengthFinder = new UnalignedLongLEMatchLengthFinder();
                break;
            }
            default: {
                throw new Error("Unsupported value '" + prop + "' in the system property org.graalvm.shadowed.org.tukaani.xz.MatchLengthFinder. Supported values: Basic, UnalignedLongLE");
            }
        }
        EXTRA_SIZE = matchLengthFinder.getExtraSize();
    }
}

