/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetICU;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetProviderICU;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.IntTrie;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.PropsVectors;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.UTF16;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.UnicodeSet;

public final class CharsetSelector {
    private IntTrie trie;
    private int[] pv;
    private String[] encodings;

    private void generateSelectorData(PropsVectors pvec, UnicodeSet excludedCodePoints, int mappingTypes) {
        int columns = (this.encodings.length + 31) / 32;
        for (int col = 0; col < columns; ++col) {
            pvec.setValue(0x110001, 0x110001, col, -1, -1);
        }
        for (int i = 0; i < this.encodings.length; ++i) {
            Charset testCharset = CharsetICU.forNameICU(this.encodings[i]);
            UnicodeSet unicodePointSet = new UnicodeSet();
            ((CharsetICU)testCharset).getUnicodeSet(unicodePointSet, mappingTypes);
            int column = i / 32;
            int mask = 1 << i % 32;
            int itemCount = unicodePointSet.getRangeCount();
            for (int j = 0; j < itemCount; ++j) {
                int startChar = unicodePointSet.getRangeStart(j);
                int endChar = unicodePointSet.getRangeEnd(j);
                pvec.setValue(startChar, endChar, column, -1, mask);
            }
        }
        if (!excludedCodePoints.isEmpty()) {
            int itemCount = excludedCodePoints.getRangeCount();
            for (int j = 0; j < itemCount; ++j) {
                int startChar = excludedCodePoints.getRangeStart(j);
                int endChar = excludedCodePoints.getRangeEnd(j);
                for (int col = 0; col < columns; ++col) {
                    pvec.setValue(startChar, endChar, col, -1, -1);
                }
            }
        }
        this.trie = pvec.compactToTrieWithRowIndexes();
        this.pv = pvec.getCompactedArray();
    }

    private boolean intersectMasks(int[] dest, int pvIndex, int len) {
        int oredDest = 0;
        for (int i = 0; i < len; ++i) {
            int n = i;
            int n2 = dest[n] & this.pv[pvIndex + i];
            dest[n] = n2;
            oredDest |= n2;
        }
        return oredDest == 0;
    }

    private List<String> selectForMask(int[] mask) {
        ArrayList<String> result = new ArrayList<String>();
        int columns = (this.encodings.length + 31) / 32;
        int numOnes = this.countOnes(mask, columns);
        if (numOnes > 0) {
            int k = 0;
            for (int j = 0; j < columns; ++j) {
                int v = mask[j];
                for (int i = 0; i < 32 && k < this.encodings.length; ++i, ++k) {
                    if ((v & 1) != 0) {
                        result.add(this.encodings[k]);
                    }
                    v >>= 1;
                }
            }
        }
        return result;
    }

    private int countOnes(int[] mask, int len) {
        int totalOnes = 0;
        for (int i = 0; i < len; ++i) {
            int ent = mask[i];
            while (ent != 0) {
                ent &= ent - 1;
                ++totalOnes;
            }
        }
        return totalOnes;
    }

    public CharsetSelector(List<String> charsetList, UnicodeSet excludedCodePoints, int mappingTypes) {
        if (mappingTypes != 1 && mappingTypes != 0) {
            throw new IllegalArgumentException("Unsupported mappingTypes");
        }
        int encodingCount = charsetList.size();
        if (encodingCount > 0) {
            this.encodings = charsetList.toArray(new String[0]);
        } else {
            this.encodings = CharsetProviderICU.getAvailableNames();
            encodingCount = this.encodings.length;
        }
        PropsVectors pvec = new PropsVectors((encodingCount + 31) / 32);
        this.generateSelectorData(pvec, excludedCodePoints, mappingTypes);
    }

    public List<String> selectForString(CharSequence unicodeText) {
        int c;
        int columns = (this.encodings.length + 31) / 32;
        int[] mask = new int[columns];
        for (int i = 0; i < columns; ++i) {
            mask[i] = -1;
        }
        for (int index = 0; index < unicodeText.length(); index += UTF16.getCharCount(c)) {
            c = UTF16.charAt(unicodeText, index);
            int pvIndex = this.trie.getCodePointValue(c);
            if (!this.intersectMasks(mask, pvIndex, columns)) continue;
            break;
        }
        return this.selectForMask(mask);
    }
}

