/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetDecoderICU;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetEncoderICU;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetICU;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetMBCS;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.UTF16;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.UnicodeSet;

class CharsetCompoundText
extends CharsetICU {
    private static final byte[] fromUSubstitution = new byte[]{63};
    private CharsetMBCS[] myConverterArray;
    private byte state;
    private static final byte INVALID = -2;
    private static final byte DO_SEARCH = -1;
    private static final byte COMPOUND_TEXT_SINGLE_0 = 0;
    private static final byte COMPOUND_TEXT_SINGLE_1 = 1;
    private static final byte COMPOUND_TEXT_SINGLE_2 = 2;
    private static final byte COMPOUND_TEXT_SINGLE_3 = 3;
    private static final byte IBM_915 = 12;
    private static final byte IBM_916 = 13;
    private static final byte IBM_914 = 14;
    private static final byte IBM_874 = 15;
    private static final byte IBM_912 = 16;
    private static final byte IBM_913 = 17;
    private static final byte ISO_8859_14 = 18;
    private static final byte IBM_923 = 19;
    private static final byte NUM_OF_CONVERTERS = 20;
    private static final byte SEARCH_LENGTH = 12;
    private static final byte[][] escSeqCompoundText = new byte[][]{{27, 45, 65}, {27, 45, 77}, {27, 45, 70}, {27, 45, 71}, {27, 36, 41, 65}, {27, 36, 41, 66}, {27, 36, 41, 67}, {27, 36, 41, 68}, {27, 36, 41, 71}, {27, 36, 41, 72}, {27, 36, 41, 73}, {27, 37, 71}, {27, 45, 76}, {27, 45, 72}, {27, 45, 68}, {27, 45, 84}, {27, 45, 66}, {27, 45, 67}, {27, 45, 95}, {27, 45, 98}};
    private static final byte ESC_START = 27;

    private static boolean isASCIIRange(int codepoint) {
        return codepoint == 0 || codepoint == 9 || codepoint == 10 || codepoint >= 32 && codepoint <= 127 || codepoint >= 160 && codepoint <= 255;
    }

    private static boolean isIBM915(int codepoint) {
        return codepoint >= 1025 && codepoint <= 1119 || codepoint == 8470;
    }

    private static boolean isIBM916(int codepoint) {
        return codepoint >= 1488 && codepoint <= 1514 || codepoint == 8215 || codepoint == 8254;
    }

    private static boolean isCompoundS3(int codepoint) {
        return codepoint == 1548 || codepoint == 1563 || codepoint == 1567 || codepoint >= 1569 && codepoint <= 1594 || codepoint >= 1600 && codepoint <= 1618 || codepoint >= 1632 && codepoint <= 1645 || codepoint == 8203 || codepoint >= 65136 && codepoint <= 65138 || codepoint == 65140 || codepoint >= 65142 && codepoint <= 65214;
    }

    private static boolean isCompoundS2(int codepoint) {
        return codepoint == 700 || codepoint == 701 || codepoint >= 900 && codepoint <= 974 || codepoint == 8213;
    }

    private static boolean isIBM914(int codepoint) {
        return codepoint == 256 || codepoint == 257 || codepoint == 274 || codepoint == 275 || codepoint == 278 || codepoint == 279 || codepoint == 290 || codepoint == 291 || codepoint >= 296 && codepoint <= 299 || codepoint == 302 || codepoint == 303 || codepoint >= 310 && codepoint <= 312 || codepoint == 315 || codepoint == 316 || codepoint == 325 || codepoint == 326 || codepoint >= 330 && codepoint <= 333 || codepoint == 342 || codepoint == 343 || codepoint >= 358 && codepoint <= 363 || codepoint == 370 || codepoint == 371;
    }

    private static boolean isIBM874(int codepoint) {
        return codepoint >= 3585 && codepoint <= 3642 || codepoint >= 3647 && codepoint <= 3675;
    }

    private static boolean isIBM912(int codepoint) {
        return codepoint >= 258 && codepoint <= 263 || codepoint >= 268 && codepoint <= 273 || codepoint >= 280 && codepoint <= 283 || codepoint == 313 || codepoint == 314 || codepoint == 317 || codepoint == 318 || codepoint >= 321 && codepoint <= 324 || codepoint == 327 || codepoint == 336 || codepoint == 337 || codepoint == 340 || codepoint == 341 || codepoint >= 344 && codepoint <= 347 || codepoint == 350 || codepoint == 351 || codepoint >= 352 && codepoint <= 357 || codepoint == 366 || codepoint == 367 || codepoint == 368 || codepoint == 369 || codepoint >= 377 && codepoint <= 382 || codepoint == 711 || codepoint == 728 || codepoint == 729 || codepoint == 731 || codepoint == 733;
    }

    private static boolean isIBM913(int codepoint) {
        return codepoint >= 264 && codepoint <= 267 || codepoint == 284 || codepoint == 285 || codepoint == 288 || codepoint == 289 || codepoint >= 292 && codepoint <= 295 || codepoint == 308 || codepoint == 309 || codepoint == 348 || codepoint == 349 || codepoint == 364 || codepoint == 365;
    }

    private static boolean isCompoundS1(int codepoint) {
        return codepoint == 286 || codepoint == 287 || codepoint == 304 || codepoint == 305 || codepoint >= 536 && codepoint <= 539;
    }

    private static boolean isISO8859_14(int codepoint) {
        return codepoint >= 372 && codepoint <= 375 || codepoint == 7690 || codepoint == 7691 || codepoint == 7710 || codepoint == 7711 || codepoint == 7744 || codepoint == 7745 || codepoint == 7766 || codepoint == 7767 || codepoint == 7776 || codepoint == 7777 || codepoint == 7786 || codepoint == 7787 || codepoint == 7922 || codepoint == 7923 || codepoint >= 7808 && codepoint <= 7813;
    }

    private static boolean isIBM923(int codepoint) {
        return codepoint == 338 || codepoint == 339 || codepoint == 376 || codepoint == 8364;
    }

    private static int findNextEsc(ByteBuffer source) {
        int sourceLimit = source.limit();
        for (int i = source.position() + 1; i < sourceLimit; ++i) {
            if (source.get(i) != 27) continue;
            return i;
        }
        return sourceLimit;
    }

    private static byte getState(int codepoint) {
        int state = -1;
        if (CharsetCompoundText.isASCIIRange(codepoint)) {
            state = 0;
        } else if (CharsetCompoundText.isIBM912(codepoint)) {
            state = 16;
        } else if (CharsetCompoundText.isIBM913(codepoint)) {
            state = 17;
        } else if (CharsetCompoundText.isISO8859_14(codepoint)) {
            state = 18;
        } else if (CharsetCompoundText.isIBM923(codepoint)) {
            state = 19;
        } else if (CharsetCompoundText.isIBM874(codepoint)) {
            state = 15;
        } else if (CharsetCompoundText.isIBM914(codepoint)) {
            state = 14;
        } else if (CharsetCompoundText.isCompoundS2(codepoint)) {
            state = 2;
        } else if (CharsetCompoundText.isCompoundS3(codepoint)) {
            state = 3;
        } else if (CharsetCompoundText.isIBM916(codepoint)) {
            state = 13;
        } else if (CharsetCompoundText.isIBM915(codepoint)) {
            state = 12;
        } else if (CharsetCompoundText.isCompoundS1(codepoint)) {
            state = 1;
        }
        return (byte)state;
    }

    private static byte findStateFromEscSeq(ByteBuffer source, byte[] toUBytes, int toUBytesLength) {
        byte i;
        byte state = -2;
        int sourceIndex = source.position();
        boolean matchFound = false;
        int offset = toUBytesLength;
        int sourceLimit = source.limit();
        for (i = 0; i < escSeqCompoundText.length; i = (byte)(i + 1)) {
            matchFound = true;
            for (int n = 0; n < escSeqCompoundText[i].length; n = (int)((byte)(n + 1))) {
                if (n < toUBytesLength) {
                    if (toUBytes[n] == escSeqCompoundText[i][n]) continue;
                    matchFound = false;
                    break;
                }
                if (sourceIndex + (n - offset) >= sourceLimit) {
                    return -1;
                }
                if (source.get(sourceIndex + (n - offset)) == escSeqCompoundText[i][n]) continue;
                matchFound = false;
                break;
            }
            if (matchFound) break;
        }
        if (matchFound) {
            state = i;
            source.position(sourceIndex + (escSeqCompoundText[i].length - offset));
        }
        return state;
    }

    public CharsetCompoundText(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.LoadConverters();
        this.maxBytesPerChar = 6;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
    }

    private void LoadConverters() {
        this.myConverterArray = new CharsetMBCS[20];
        this.myConverterArray[0] = null;
        for (int i = 1; i < 12; ++i) {
            Object name = "icu-internal-compound-";
            name = i <= 3 ? (String)name + "s" + i : (i <= 10 ? (String)name + "d" + (i - 3) : (String)name + "t");
            this.myConverterArray[i] = (CharsetMBCS)CharsetICU.forNameICU((String)name);
        }
        this.myConverterArray[12] = (CharsetMBCS)CharsetICU.forNameICU("ibm-915_P100-1995");
        this.myConverterArray[13] = (CharsetMBCS)CharsetICU.forNameICU("ibm-916_P100-1995");
        this.myConverterArray[14] = (CharsetMBCS)CharsetICU.forNameICU("ibm-914_P100-1995");
        this.myConverterArray[15] = (CharsetMBCS)CharsetICU.forNameICU("ibm-874_P100-1995");
        this.myConverterArray[16] = (CharsetMBCS)CharsetICU.forNameICU("ibm-912_P100-1995");
        this.myConverterArray[17] = (CharsetMBCS)CharsetICU.forNameICU("ibm-913_P100-2000");
        this.myConverterArray[18] = (CharsetMBCS)CharsetICU.forNameICU("iso-8859_14-1998");
        this.myConverterArray[19] = (CharsetMBCS)CharsetICU.forNameICU("ibm-923_P100-1998");
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderCompoundText(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderCompoundText(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
        for (int i = 1; i < 20; ++i) {
            this.myConverterArray[i].MBCSGetFilteredUnicodeSetForUnicode(this.myConverterArray[i].sharedData, setFillIn, which, 1);
        }
        setFillIn.add(0);
        setFillIn.add(9);
        setFillIn.add(10);
        setFillIn.add(32, 127);
        setFillIn.add(160, 255);
    }

    class CharsetDecoderCompoundText
    extends CharsetDecoderICU {
        CharsetMBCS.CharsetDecoderMBCS[] gbDecoder;

        public CharsetDecoderCompoundText(CharsetICU cs) {
            super(cs);
            this.gbDecoder = new CharsetMBCS.CharsetDecoderMBCS[20];
            for (int i = 0; i < 20; ++i) {
                this.gbDecoder[i] = i == 0 ? null : (CharsetMBCS.CharsetDecoderMBCS)CharsetCompoundText.this.myConverterArray[i].newDecoder();
            }
        }

        @Override
        protected void implReset() {
            super.implReset();
            for (int i = 0; i < 20; ++i) {
                if (this.gbDecoder[i] == null) continue;
                this.gbDecoder[i].implReset();
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            byte currentState;
            CoderResult err = CoderResult.UNDERFLOW;
            byte[] sourceChar = new byte[]{0};
            byte tmpState = currentState = CharsetCompoundText.this.state;
            int sourceLimit = source.limit();
            if (!source.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            while (source.hasRemaining()) {
                if (target.hasRemaining()) {
                    sourceChar[0] = this.toULength > 0 ? this.toUBytesArray[0] : source.get(source.position());
                    if (sourceChar[0] == 27) {
                        tmpState = CharsetCompoundText.findStateFromEscSeq(source, this.toUBytesArray, this.toULength);
                        if (tmpState == -1) {
                            while (source.hasRemaining()) {
                                this.toUBytesArray[this.toULength++] = source.get();
                            }
                            break;
                        }
                        if (tmpState < 0) {
                            err = CoderResult.malformedForLength(1);
                            if (this.toULength != 0) break;
                            source.get();
                            break;
                        }
                        this.toULength = 0;
                    }
                    if (tmpState != currentState) {
                        currentState = tmpState;
                    }
                    if (currentState == 0) {
                        while (source.hasRemaining()) {
                            if (!target.hasRemaining()) {
                                err = CoderResult.OVERFLOW;
                            } else if (source.get(source.position()) != 27) {
                                if (!target.hasRemaining()) continue;
                                target.put((char)(0xFF & source.get()));
                                continue;
                            }
                            break;
                        }
                    } else if (source.hasRemaining()) {
                        source.limit(CharsetCompoundText.findNextEsc(source));
                        CharsetMBCS.CharsetDecoderMBCS decoder = this.gbDecoder[currentState];
                        decoder.toUBytesArray = this.toUBytesArray;
                        decoder.toULength = this.toULength;
                        err = decoder.decodeLoop(source, target, offsets, true);
                        this.toULength = decoder.toULength;
                        decoder.toULength = 0;
                        if (err.isError() && err.isOverflow()) {
                            this.charErrorBufferArray = decoder.charErrorBufferArray;
                            this.charErrorBufferBegin = decoder.charErrorBufferBegin;
                            this.charErrorBufferLength = decoder.charErrorBufferLength;
                            decoder.charErrorBufferBegin = 0;
                            decoder.charErrorBufferLength = 0;
                        }
                        source.limit(sourceLimit);
                    }
                    if (!err.isError()) continue;
                    break;
                }
                err = CoderResult.OVERFLOW;
                break;
            }
            CharsetCompoundText.this.state = currentState;
            return err;
        }
    }

    class CharsetEncoderCompoundText
    extends CharsetEncoderICU {
        CharsetMBCS.CharsetEncoderMBCS[] gbEncoder;

        public CharsetEncoderCompoundText(CharsetICU cs) {
            super(cs, fromUSubstitution);
            this.gbEncoder = new CharsetMBCS.CharsetEncoderMBCS[20];
            for (int i = 0; i < 20; ++i) {
                this.gbEncoder[i] = i == 0 ? null : (CharsetMBCS.CharsetEncoderMBCS)CharsetCompoundText.this.myConverterArray[i].newEncoder();
            }
        }

        @Override
        protected void implReset() {
            super.implReset();
            for (int i = 0; i < 20; ++i) {
                if (this.gbEncoder[i] == null) continue;
                this.gbEncoder[i].implReset();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult err = CoderResult.UNDERFLOW;
            char[] sourceCharArray = new char[]{'\u0000'};
            ByteBuffer tmpTargetBuffer = ByteBuffer.allocate(3);
            byte[] targetBytes = new byte[10];
            int targetLength = 0;
            byte currentState = CharsetCompoundText.this.state;
            byte tmpState = 0;
            int i = 0;
            boolean gotoGetTrail = false;
            if (!source.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            int sourceChar = this.fromUChar32;
            if (sourceChar != 0 && target.hasRemaining()) {
                gotoGetTrail = true;
            }
            block0: while (source.hasRemaining()) {
                block23: {
                    block21: {
                        block19: {
                            block22: {
                                block20: {
                                    block18: {
                                        if (!target.hasRemaining()) break block19;
                                        if (!gotoGetTrail) {
                                            sourceChar = source.get();
                                        }
                                        targetLength = 0;
                                        tmpTargetBuffer.position(0);
                                        tmpTargetBuffer.limit(3);
                                        if (UTF16.isSurrogate(sourceChar) || gotoGetTrail) {
                                            if (UTF16.isLeadSurrogate(sourceChar) || gotoGetTrail) {
                                                gotoGetTrail = false;
                                                if (source.hasRemaining()) {
                                                    char trail = source.get();
                                                    source.position(source.position() - 1);
                                                    if (UTF16.isTrailSurrogate(trail)) {
                                                        source.get();
                                                        sourceChar = UCharacter.getCodePoint(sourceChar, trail);
                                                        this.fromUChar32 = 0;
                                                        break block18;
                                                    } else {
                                                        err = CoderResult.malformedForLength(1);
                                                        this.fromUChar32 = sourceChar;
                                                        break;
                                                    }
                                                }
                                                this.fromUChar32 = sourceChar;
                                                break;
                                            }
                                            err = CoderResult.malformedForLength(1);
                                            this.fromUChar32 = sourceChar;
                                            break;
                                        }
                                    }
                                    tmpState = CharsetCompoundText.getState(sourceChar);
                                    sourceCharArray[0] = (char)sourceChar;
                                    if (tmpState >= 0) break block20;
                                    break block21;
                                }
                                if (tmpState != 0) break block22;
                                tmpTargetBuffer.put(0, (byte)sourceChar);
                                tmpTargetBuffer.limit(1);
                                break block23;
                            }
                            err = this.gbEncoder[tmpState].cnvMBCSFromUnicodeWithOffsets(CharBuffer.wrap(sourceCharArray), tmpTargetBuffer, offsets, true);
                            if (err.isError()) break block23;
                            tmpTargetBuffer.limit(tmpTargetBuffer.position());
                            break block23;
                        }
                        err = CoderResult.OVERFLOW;
                        break;
                    }
                    for (i = 1; i < 12; ++i) {
                        err = this.gbEncoder[i].cnvMBCSFromUnicodeWithOffsets(CharBuffer.wrap(sourceCharArray), tmpTargetBuffer, offsets, true);
                        if (err.isError()) continue;
                        tmpState = (byte)i;
                        tmpTargetBuffer.limit(tmpTargetBuffer.position());
                        this.implReset();
                        break;
                    }
                }
                if (err.isError()) break;
                if (currentState != tmpState) {
                    currentState = tmpState;
                    for (i = 0; i < escSeqCompoundText[currentState].length; ++i) {
                        targetBytes[i] = escSeqCompoundText[currentState][i];
                    }
                    targetLength = i;
                }
                for (i = 0; i < tmpTargetBuffer.limit(); ++i) {
                    targetBytes[i + targetLength] = tmpTargetBuffer.get(i);
                }
                targetLength += i;
                for (i = 0; i < targetLength; ++i) {
                    if (target.hasRemaining()) {
                        target.put(targetBytes[i]);
                        continue;
                    }
                    err = CoderResult.OVERFLOW;
                    continue block0;
                }
            }
            if (err.isOverflow()) {
                int m = 0;
                for (int n = i; n < targetLength; ++n) {
                    this.errorBuffer[m++] = targetBytes[n];
                }
                this.errorBufferLength = m;
            }
            CharsetCompoundText.this.state = currentState;
            return err;
        }
    }
}

