/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.impl;

import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageInfo;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageSingletons;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.impl.ClassLoadingSupport;

public final class ClassLoading {
    private ClassLoading() {
    }

    public static boolean isSupported() {
        if (!ImageInfo.inImageRuntimeCode()) {
            return true;
        }
        return ImageSingletons.lookup(ClassLoadingSupport.class).isSupported();
    }

    public static ArbitraryClassLoadingScope allowArbitraryClassLoading() {
        if (!ClassLoading.isSupported()) {
            throw new IllegalStateException("Runtime class loading is not supported. It must be enabled at build-time with -H:+RuntimeClassLoading.");
        }
        return new ArbitraryClassLoadingScope();
    }

    public static final class ArbitraryClassLoadingScope
    implements AutoCloseable {
        private boolean closed;

        ArbitraryClassLoadingScope() {
            if (!ImageInfo.inImageRuntimeCode()) {
                return;
            }
            ClassLoadingSupport support = ImageSingletons.lookup(ClassLoadingSupport.class);
            support.startIgnoreReflectionConfigurationScope();
        }

        @Override
        public void close() {
            if (this.closed) {
                throw new IllegalStateException("ArbitraryClassLoadingScope is already closed");
            }
            this.closed = true;
            if (!ImageInfo.inImageRuntimeCode()) {
                return;
            }
            ImageSingletons.lookup(ClassLoadingSupport.class).endIgnoreReflectionConfigurationScope();
        }
    }
}

