/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.constant;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageSingletons;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.Platform;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.Platforms;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.impl.CConstantValueSupport;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface CConstant {
    public String value() default "";

    public static final class ValueAccess {
        private ValueAccess() {
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public static <T> T get(Class<?> declaringClass, String methodName, Class<T> returnType) {
            return ImageSingletons.lookup(CConstantValueSupport.class).getCConstantValue(declaringClass, methodName, returnType);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public static <T> T get(Enum<?> cEnum, String methodName) {
            return ImageSingletons.lookup(CConstantValueSupport.class).getCEnumValue(cEnum, methodName);
        }
    }
}

