/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.jniutils;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.WordFactory;

public class HSObject {
    private final JNI.JObject handle;
    private final Cleaner cleaner;
    private HSObject next;
    private static final Set<Cleaner> CLEANERS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ReferenceQueue<HSObject> CLEANERS_QUEUE = new ReferenceQueue();

    public HSObject(JNI.JNIEnv env, JNI.JObject handle) {
        this(env, handle, false, false);
    }

    public HSObject(JNI.JNIEnv env, JNI.JObject handle, boolean allowGlobalDuplicates, boolean weak) {
        HSObject.cleanHandles(env);
        if (HSObject.checkingGlobalDuplicates(allowGlobalDuplicates)) {
            HSObject.checkNonExistingGlobalReference(env, handle);
        }
        String name = this.getClass().getName();
        this.handle = weak ? JNIUtil.NewWeakGlobalRef(env, handle, name) : JNIUtil.NewGlobalRef(env, handle, name);
        this.cleaner = new Cleaner(this, this.handle, allowGlobalDuplicates, weak);
        CLEANERS.add(this.cleaner);
        this.next = null;
    }

    private static boolean checkingGlobalDuplicates(boolean allowGlobalDuplicates) {
        return !allowGlobalDuplicates && (HSObject.assertionsEnabled() || JNIUtil.tracingAt(1));
    }

    public HSObject(JNIMethodScope scope, JNI.JObject handle) {
        this.handle = handle;
        this.next = scope.locals;
        scope.locals = this;
        this.cleaner = null;
    }

    static int invalidate(HSObject head) {
        HSObject o = head;
        int count = 0;
        while (o != null) {
            HSObject next = o.next;
            o.next = o;
            o = next;
            ++count;
        }
        return count;
    }

    public final JNI.JObject getHandle() {
        if (this.next == this) {
            throw new IllegalArgumentException("Reclaimed JNI reference: " + String.valueOf(this));
        }
        return this.handle;
    }

    public String toString() {
        return String.format("%s[0x%x]", this.getClass().getSimpleName(), this.handle.rawValue());
    }

    public final void release(JNI.JNIEnv env) {
        if (this.cleaner != null) {
            assert (this.next == null || this.next == this);
            this.next = this;
            this.cleaner.clean(env);
        }
    }

    public static void cleanHandles(JNI.JNIEnv env) {
        Cleaner cleaner;
        while ((cleaner = (Cleaner)CLEANERS_QUEUE.poll()) != null) {
            cleaner.clean(env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkNonExistingGlobalReference(JNI.JNIEnv env, JNI.JObject handle) {
        Iterator<Cleaner> iterator = CLEANERS.iterator();
        while (iterator.hasNext()) {
            Cleaner cleaner;
            Cleaner cleaner2 = cleaner = iterator.next();
            synchronized (cleaner2) {
                if (cleaner.handle.isNonNull() && JNIUtil.IsSameObject(env, handle, cleaner.handle)) {
                    throw new IllegalArgumentException("Global JNI handle already exists for object referenced by " + handle.rawValue());
                }
            }
        }
    }

    private static boolean assertionsEnabled() {
        boolean res = false;
        if (!$assertionsDisabled) {
            res = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return res;
    }

    private static final class Cleaner
    extends PhantomReference<HSObject> {
        private JNI.JObject handle;
        private final boolean allowGlobalDuplicates;
        private final boolean weak;

        Cleaner(HSObject referent, JNI.JObject handle, boolean allowGlobalDuplicates, boolean weak) {
            super(referent, CLEANERS_QUEUE);
            this.handle = handle;
            this.allowGlobalDuplicates = allowGlobalDuplicates;
            this.weak = weak;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clean(JNI.JNIEnv env) {
            if (CLEANERS.remove(this)) {
                if (HSObject.checkingGlobalDuplicates(this.allowGlobalDuplicates)) {
                    Cleaner cleaner = this;
                    synchronized (cleaner) {
                        this.delete(env);
                        this.handle = (JNI.JObject)WordFactory.nullPointer();
                    }
                } else {
                    this.delete(env);
                }
            }
        }

        private void delete(JNI.JNIEnv env) {
            if (this.weak) {
                JNIUtil.DeleteWeakGlobalRef(env, (JNI.JWeak)this.handle);
            } else {
                JNIUtil.DeleteGlobalRef(env, this.handle);
            }
        }
    }
}

