/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.debug;

import java.util.LinkedHashMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeCost;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleCompilerListener;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.AbstractCompilationTask;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedTruffleRuntime;

public final class TraceCompilationPolymorphismListener
extends AbstractGraalTruffleRuntimeListener {
    private TraceCompilationPolymorphismListener(OptimizedTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(OptimizedTruffleRuntime runtime) {
        runtime.addListener(new TraceCompilationPolymorphismListener(runtime));
    }

    @Override
    public void onCompilationSuccess(final OptimizedCallTarget target, AbstractCompilationTask task, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        if (target.getOptionValue(OptimizedRuntimeOptions.TraceCompilationPolymorphism).booleanValue()) {
            target.accept(new NodeVisitor(){
                final /* synthetic */ TraceCompilationPolymorphismListener this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean visit(Node node) {
                    if (node != null && (node.getCost() == NodeCost.MEGAMORPHIC || node.getCost() == NodeCost.POLYMORPHIC)) {
                        NodeCost cost = node.getCost();
                        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
                        props.put("simpleName", node.getClass().getSimpleName());
                        props.put("subtree", "\n" + NodeUtil.printCompactTreeToString(node));
                        String msg = cost == NodeCost.MEGAMORPHIC ? "megamorphic" : "polymorphic";
                        this.this$0.runtime.logEvent(target, 0, msg, node.toString(), props, null);
                    }
                    return true;
                }
            });
        }
    }
}

