/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.debug;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleCompilerListener;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.AbstractCompilationTask;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedTruffleRuntime;

public final class TraceASTCompilationListener
extends AbstractGraalTruffleRuntimeListener {
    private TraceASTCompilationListener(OptimizedTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(OptimizedTruffleRuntime runtime) {
        runtime.addListener(new TraceASTCompilationListener(runtime));
    }

    @Override
    public void onCompilationSuccess(OptimizedCallTarget target, AbstractCompilationTask task, TruffleCompilerListener.GraphInfo graphInfo, TruffleCompilerListener.CompilationResultInfo compilationResultInfo) {
        if (target.getOptionValue(OptimizedRuntimeOptions.TraceCompilationAST).booleanValue()) {
            StringWriter logMessage = new StringWriter();
            try (PrintWriter out = new PrintWriter(logMessage);){
                TraceASTCompilationListener.printCompactTree(out, target);
            }
            this.runtime.logEvent(target, 0, "opt AST", target.toString(), target.getDebugProperties(), logMessage.toString());
        }
    }

    private static void printCompactTree(final PrintWriter out, OptimizedCallTarget target) {
        target.accept(new NodeVisitor(){
            private boolean newLine = false;

            @Override
            public boolean visit(Node node) {
                if (node == null) {
                    return true;
                }
                Node parent = node.getParent();
                if (this.newLine) {
                    out.println();
                } else {
                    this.newLine = true;
                }
                if (parent == null) {
                    out.printf("%s", node.getClass().getSimpleName());
                } else {
                    String fieldName = NodeUtil.findChildFieldName(parent, node);
                    out.printf("%s = %s", fieldName, node.getClass().getSimpleName());
                }
                return true;
            }
        });
    }
}

