/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.IndirectCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedRuntimeAccessor;

@NodeInfo
public final class OptimizedIndirectCallNode
extends IndirectCallNode {
    @CompilerDirectives.CompilationFinal
    private Class<? extends Throwable> exceptionProfile;

    OptimizedIndirectCallNode() {
    }

    @Override
    public Object call(CallTarget target, Object ... arguments) {
        try {
            OptimizedCallTarget optimizedTarget = (OptimizedCallTarget)target;
            if (CompilerDirectives.isPartialEvaluationConstant(optimizedTarget)) {
                return optimizedTarget.callDirect(this, arguments);
            }
            return optimizedTarget.callIndirect(this, arguments);
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
    }

    private RuntimeException handleException(Throwable t) {
        Throwable profiled = this.profileExceptionType(t);
        OptimizedRuntimeAccessor.LANGUAGE.addStackFrameInfo(this, null, profiled, null);
        throw OptimizedCallTarget.rethrow(profiled);
    }

    private <T extends Throwable> T profileExceptionType(T value) {
        Class<? extends Throwable> clazz = this.exceptionProfile;
        if (clazz != Throwable.class) {
            if (clazz != null && value.getClass() == clazz) {
                if (CompilerDirectives.inInterpreter()) {
                    return value;
                }
                return (T)CompilerDirectives.castExact(value, clazz);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.exceptionProfile = clazz == null ? value.getClass() : Throwable.class;
        }
        return value;
    }
}

