/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime;

import java.lang.module.ModuleDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl.Accessor;

public final class ModulesSupport {
    private static final Accessor.ModulesAccessor ACCESSOR = ModulesSupport.initializeModulesAccessor();

    private ModulesSupport() {
    }

    public static String exportJVMCI(Class<?> toClass) {
        Module previousModule = null;
        HashSet<Module> seenModules = new HashSet<Module>();
        for (Class<?> currentClass = toClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            String s;
            Module currentModule = currentClass.getModule();
            if (!currentModule.equals(previousModule) && (s = ModulesSupport.exportJVMCI(currentModule, seenModules)) != null) {
                return s;
            }
            previousModule = currentModule;
        }
        return null;
    }

    public static String exportJVMCI(Module module) {
        return ModulesSupport.exportJVMCI(module, new HashSet<Module>());
    }

    private static String exportJVMCI(Module module, Set<Module> seenModules) {
        Module jvmciModule;
        ModuleLayer layer = module.getLayer();
        if (layer == null) {
            layer = ModuleLayer.boot();
        }
        if ((jvmciModule = (Module)layer.findModule("jdk.internal.vm.ci").orElse(null)) == null) {
            return "JVMCI is not enabled for this JVM. Enable JVMCI using -XX:+EnableJVMCI.";
        }
        if (ACCESSOR == null) {
            return "The Truffle attach library is not available or cannot be loaded. This can happen if the Truffle jar files are invalid or if Truffle is loaded multiple times in separate class loaders.";
        }
        ModulesSupport.addExportsRecursive(layer, jvmciModule, module, seenModules);
        return null;
    }

    private static void addExportsRecursive(ModuleLayer layer, Module sourceModule, Module exportTo, Set<Module> seenModules) {
        if (seenModules.contains(exportTo)) {
            return;
        }
        for (String pn : sourceModule.getPackages()) {
            ModulesSupport.addExports(sourceModule, pn, exportTo);
        }
        seenModules.add(exportTo);
        ModuleDescriptor descriptor = exportTo.getDescriptor();
        if (descriptor != null) {
            for (ModuleDescriptor.Requires requires : descriptor.requires()) {
                String name;
                Module requiredModule = layer.findModule(requires.name()).orElse(null);
                if (requiredModule == null || (name = requiredModule.getName()).startsWith("java.") || name.startsWith("jdk.")) continue;
                ModulesSupport.addExportsRecursive(layer, sourceModule, requiredModule, seenModules);
            }
        }
    }

    public static void addExports(Module base, String p, Module target) {
        if (target.isNamed()) {
            ACCESSOR.addExports(base, p, target);
        } else {
            ACCESSOR.addExportsToAllUnnamed(base, p);
        }
    }

    public static void addOpens(Module base, String p, Module target) {
        if (target.isNamed()) {
            ACCESSOR.addOpens(base, p, target);
        } else {
            ACCESSOR.addOpensToAllUnnamed(base, p);
        }
    }

    public static void exportTruffleRuntimeTo(Class<?> client) {
        Module clientModule;
        Module truffleModule = ModulesSupport.class.getModule();
        if (truffleModule != (clientModule = client.getModule())) {
            Set<String> packages = truffleModule.getPackages();
            for (String pkg : packages) {
                boolean exported = truffleModule.isExported(pkg, clientModule);
                if (exported) continue;
                truffleModule.addExports(pkg, clientModule);
            }
        }
    }

    public static Accessor.JavaLangSupport getJavaLangSupport() {
        return ACCESSOR.getJavaLangSupport();
    }

    private static Accessor.ModulesAccessor initializeModulesAccessor() {
        try {
            Class<?> resourceCacheClass = Class.forName("com.oracle.truffle.polyglot.JDKSupport", false, ModulesSupport.class.getClassLoader());
            Method getModulesAccessor = resourceCacheClass.getDeclaredMethod("getModulesAccessor", new Class[0]);
            getModulesAccessor.setAccessible(true);
            return (Accessor.ModulesAccessor)getModulesAccessor.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }
}

