/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.logging.Level;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLogger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedRuntimeAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.TruffleSplittingStrategy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.debug.StatisticsListener;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.Pair;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionValues;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.SandboxPolicy;

public final class EngineData {
    int splitLimit;
    int splitCount;
    public final long id;
    private Function<String, TruffleLogger> loggerFactory;
    @CompilerDirectives.CompilationFinal
    OptionValues engineOptions;
    final TruffleSplittingStrategy.SplitStatisticsData splittingStatistics;
    @CompilerDirectives.CompilationFinal
    public StatisticsListener statisticsListener;
    @CompilerDirectives.CompilationFinal
    public boolean splitting;
    @CompilerDirectives.CompilationFinal
    public boolean splittingAllowForcedSplits;
    @CompilerDirectives.CompilationFinal
    public boolean splittingDumpDecisions;
    @CompilerDirectives.CompilationFinal
    public boolean splittingTraceEvents;
    @CompilerDirectives.CompilationFinal
    public boolean traceSplittingSummary;
    @CompilerDirectives.CompilationFinal
    public boolean traceSplits;
    @CompilerDirectives.CompilationFinal
    public int splittingMaxCalleeSize;
    @CompilerDirectives.CompilationFinal
    public int splittingMaxPropagationDepth;
    @CompilerDirectives.CompilationFinal
    public double splittingGrowthLimit;
    @CompilerDirectives.CompilationFinal
    public boolean compilation;
    @CompilerDirectives.CompilationFinal
    public boolean compileImmediately;
    @CompilerDirectives.CompilationFinal
    public boolean multiTier;
    @CompilerDirectives.CompilationFinal
    public boolean returnTypeSpeculation;
    @CompilerDirectives.CompilationFinal
    public boolean argumentTypeSpeculation;
    @CompilerDirectives.CompilationFinal
    public boolean traceCompilation;
    @CompilerDirectives.CompilationFinal
    public boolean traceCompilationDetails;
    @CompilerDirectives.CompilationFinal
    public boolean backgroundCompilation;
    @CompilerDirectives.CompilationFinal
    public OptimizedRuntimeOptions.ExceptionAction compilationFailureAction;
    @CompilerDirectives.CompilationFinal
    public String compileOnly;
    @CompilerDirectives.CompilationFinal
    public boolean callTargetStatistics;
    @CompilerDirectives.CompilationFinal
    public boolean callTargetStatisticDetails;
    @CompilerDirectives.CompilationFinal
    public boolean profilingEnabled;
    @CompilerDirectives.CompilationFinal
    public boolean traceTransferToInterpreter;
    @CompilerDirectives.CompilationFinal
    public boolean traceDeoptimizeFrame;
    @CompilerDirectives.CompilationFinal
    public boolean compileAOTOnCreate;
    @CompilerDirectives.CompilationFinal
    public boolean firstTierOnly;
    @CompilerDirectives.CompilationFinal
    public long stoppedCompilationRetryDelay;
    @CompilerDirectives.CompilationFinal
    public boolean priorityQueue;
    @CompilerDirectives.CompilationFinal
    public boolean weightingBothTiers;
    @CompilerDirectives.CompilationFinal
    public boolean traversingFirstTierPriority;
    @CompilerDirectives.CompilationFinal
    public double traversingFirstTierBonus;
    @CompilerDirectives.CompilationFinal
    public double traversingInvalidatedBonus;
    @CompilerDirectives.CompilationFinal
    public double traversingOSRBonus;
    @CompilerDirectives.CompilationFinal
    public boolean propagateCallAndLoopCount;
    @CompilerDirectives.CompilationFinal
    public int propagateCallAndLoopCountMaxDepth;
    @CompilerDirectives.CompilationFinal
    public int maximumCompilations;
    @CompilerDirectives.CompilationFinal
    public int callThresholdInInterpreter;
    @CompilerDirectives.CompilationFinal
    public int callAndLoopThresholdInInterpreter;
    @CompilerDirectives.CompilationFinal
    public int callThresholdInFirstTier;
    @CompilerDirectives.CompilationFinal
    public int callAndLoopThresholdInFirstTier;
    @CompilerDirectives.CompilationFinal
    public long interpreterCallStackHeadRoom;
    public BooleanSupplier cancelledPredicate;
    private volatile Pair<List<String>, List<String>> parsedCompileOnly;
    private Map<String, String> compilerOptions;
    private volatile Object polyglotEngine;
    private volatile boolean closed;
    private volatile Map<Class<?>, Object> engineLocals;
    private final AtomicBoolean logShutdownCompilations = new AtomicBoolean(true);

    EngineData(Object polyglotEngine, OptionValues runtimeOptions, Function<String, TruffleLogger> loggerFactory, SandboxPolicy sandboxPolicy) {
        Objects.requireNonNull(polyglotEngine);
        Objects.requireNonNull(runtimeOptions);
        this.polyglotEngine = polyglotEngine;
        this.id = OptimizedRuntimeAccessor.ENGINE.getEngineId(polyglotEngine);
        this.loggerFactory = loggerFactory;
        this.loadOptions(runtimeOptions, sandboxPolicy);
        this.splittingStatistics = new TruffleSplittingStrategy.SplitStatisticsData();
    }

    public void ensureClosed() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public static IllegalArgumentException sandboxPolicyException(SandboxPolicy sandboxPolicy, String reason, String fix) {
        Objects.requireNonNull(sandboxPolicy);
        Objects.requireNonNull(reason);
        Objects.requireNonNull(fix);
        String spawnIsolateHelp = sandboxPolicy.isStricterOrEqual(SandboxPolicy.ISOLATED) ? " If you switch to a less strict sandbox policy you can still spawn an isolate with an isolated heap using Builder.option(\"engine.SpawnIsolate\",\"true\")." : "";
        String message = String.format("The validation for the given sandbox policy %s failed. %s In order to resolve this %s or switch to a less strict sandbox policy using Builder.sandbox(SandboxPolicy).%s", new Object[]{sandboxPolicy, reason, fix, spawnIsolateHelp});
        return new IllegalArgumentException(message);
    }

    public void preinitializeContext() {
        OptimizedRuntimeAccessor.ENGINE.preinitializeContext(this.polyglotEngine);
    }

    public Object finalizeStore() {
        return OptimizedRuntimeAccessor.ENGINE.finalizeStore(this.polyglotEngine);
    }

    public void restoreStore(Object finalizationResult) {
        OptimizedRuntimeAccessor.ENGINE.restoreStore(this.polyglotEngine, finalizationResult);
    }

    public Object getEngineLock() {
        return OptimizedRuntimeAccessor.ENGINE.getEngineLock(this.polyglotEngine);
    }

    public Object getEngineLogHandler() {
        return OptimizedRuntimeAccessor.ENGINE.getEngineLogHandler(this.polyglotEngine);
    }

    public <T> T getEngineLocal(Class<T> symbol) {
        Map<Class<?>, Object> data = this.engineLocals;
        if (data == null) {
            return null;
        }
        return (T)data.get(symbol);
    }

    public void clearEngineLocal(Class<?> symbol) {
        Map<Class<?>, Object> data = this.engineLocals;
        if (data == null) {
            return;
        }
        data.remove(symbol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putEngineLocal(Class<T> symbol, T value) {
        Object prev;
        Map<Class<?>, Object> data = this.engineLocals;
        if (data == null) {
            EngineData engineData = this;
            synchronized (engineData) {
                data = this.engineLocals;
                if (data == null) {
                    data = new ConcurrentHashMap();
                    this.engineLocals = data;
                }
            }
        }
        if ((prev = data.putIfAbsent(symbol, symbol.cast(value))) != null) {
            throw new IllegalArgumentException("Cannot set engine local. Key " + String.valueOf(symbol) + " is already defined.");
        }
    }

    void onEngineCreated(Object engine) {
        assert (this.polyglotEngine == engine);
        OptimizedTruffleRuntime.getRuntime().onEngineCreated(this);
        OptimizedTruffleRuntime.getRuntime().getEngineCacheSupport().onEngineCreated(this);
    }

    void onEnginePatch(OptionValues newRuntimeOptions, Function<String, TruffleLogger> newLoggerFactory, SandboxPolicy sandboxPolicy) {
        this.loggerFactory = newLoggerFactory;
        this.loadOptions(newRuntimeOptions, sandboxPolicy);
        OptimizedTruffleRuntime.getRuntime().onEngineCreated(this);
        OptimizedTruffleRuntime.getRuntime().getEngineCacheSupport().onEnginePatch(this);
    }

    public Object getPolyglotEngine() {
        return this.polyglotEngine;
    }

    boolean onEngineClosing() {
        return OptimizedTruffleRuntime.getRuntime().getEngineCacheSupport().onEngineClosing(this);
    }

    void onEngineClosed() {
        OptimizedTruffleRuntime.getRuntime().getListener().onEngineClosed(this);
        OptimizedTruffleRuntime.getRuntime().getEngineCacheSupport().onEngineClosed(this);
        this.polyglotEngine = null;
    }

    public boolean onStoreCache(Path targetPath, long cancelledWord) {
        return OptimizedTruffleRuntime.getRuntime().getEngineCacheSupport().onStoreCache(this, targetPath, cancelledWord);
    }

    private void loadOptions(OptionValues options, SandboxPolicy sandboxPolicy) {
        this.engineOptions = options;
        this.splitting = options.get(OptimizedRuntimeOptions.Splitting) != false && options.get(OptimizedRuntimeOptions.Mode) != OptimizedRuntimeOptions.EngineModeEnum.LATENCY;
        this.splittingAllowForcedSplits = options.get(OptimizedRuntimeOptions.SplittingAllowForcedSplits);
        this.splittingDumpDecisions = options.get(OptimizedRuntimeOptions.SplittingDumpDecisions);
        this.splittingMaxCalleeSize = options.get(OptimizedRuntimeOptions.SplittingMaxCalleeSize);
        this.splittingMaxPropagationDepth = options.get(OptimizedRuntimeOptions.SplittingMaxPropagationDepth);
        this.splittingTraceEvents = options.get(OptimizedRuntimeOptions.SplittingTraceEvents);
        this.traceSplittingSummary = options.get(OptimizedRuntimeOptions.TraceSplittingSummary);
        this.traceSplits = options.get(OptimizedRuntimeOptions.TraceSplitting);
        this.splittingGrowthLimit = options.get(OptimizedRuntimeOptions.SplittingGrowthLimit);
        this.compilation = options.get(OptimizedRuntimeOptions.Compilation);
        this.compileOnly = options.get(OptimizedRuntimeOptions.CompileOnly);
        this.compileImmediately = options.get(OptimizedRuntimeOptions.CompileImmediately);
        this.multiTier = !this.compileImmediately && options.get(OptimizedRuntimeOptions.MultiTier) != false;
        this.compileAOTOnCreate = options.get(OptimizedRuntimeOptions.CompileAOTOnCreate);
        this.firstTierOnly = options.get(OptimizedRuntimeOptions.Mode) == OptimizedRuntimeOptions.EngineModeEnum.LATENCY;
        this.propagateCallAndLoopCount = options.get(OptimizedRuntimeOptions.PropagateLoopCountToLexicalSingleCaller);
        this.propagateCallAndLoopCountMaxDepth = options.get(OptimizedRuntimeOptions.PropagateLoopCountToLexicalSingleCallerMaxDepth);
        this.stoppedCompilationRetryDelay = options.get(OptimizedRuntimeOptions.StoppedCompilationRetryDelay);
        this.priorityQueue = options.get(OptimizedRuntimeOptions.PriorityQueue);
        this.weightingBothTiers = options.get(OptimizedRuntimeOptions.TraversingQueueWeightingBothTiers);
        this.traversingFirstTierPriority = options.get(OptimizedRuntimeOptions.TraversingQueueFirstTierPriority);
        this.traversingFirstTierBonus = options.get(OptimizedRuntimeOptions.TraversingQueueFirstTierBonus) * (double)options.get(OptimizedRuntimeOptions.LastTierCompilationThreshold).intValue() / (double)options.get(OptimizedRuntimeOptions.FirstTierCompilationThreshold).intValue();
        this.maximumCompilations = options.get(OptimizedRuntimeOptions.MaximumCompilations);
        this.traversingInvalidatedBonus = options.get(OptimizedRuntimeOptions.TraversingQueueInvalidatedBonus);
        this.traversingOSRBonus = options.get(OptimizedRuntimeOptions.TraversingQueueOSRBonus);
        this.returnTypeSpeculation = options.get(OptimizedRuntimeOptions.ReturnTypeSpeculation);
        this.argumentTypeSpeculation = options.get(OptimizedRuntimeOptions.ArgumentTypeSpeculation);
        this.traceCompilation = options.get(OptimizedRuntimeOptions.TraceCompilation);
        this.traceCompilationDetails = options.get(OptimizedRuntimeOptions.TraceCompilationDetails);
        this.backgroundCompilation = options.get(OptimizedRuntimeOptions.BackgroundCompilation) != false && !this.compileAOTOnCreate;
        this.callThresholdInInterpreter = this.computeCallThresholdInInterpreter(options);
        this.callAndLoopThresholdInInterpreter = this.computeCallAndLoopThresholdInInterpreter(options);
        this.callThresholdInFirstTier = this.computeCallThresholdInFirstTier(options);
        this.callAndLoopThresholdInFirstTier = this.computeCallAndLoopThresholdInFirstTier(options);
        this.callTargetStatisticDetails = options.get(OptimizedRuntimeOptions.CompilationStatisticDetails);
        this.callTargetStatistics = options.get(OptimizedRuntimeOptions.CompilationStatistics) != false || this.callTargetStatisticDetails;
        this.statisticsListener = this.callTargetStatistics ? StatisticsListener.createEngineListener(OptimizedTruffleRuntime.getRuntime()) : null;
        this.profilingEnabled = options.get(OptimizedRuntimeOptions.Profiling);
        this.traceTransferToInterpreter = options.get(OptimizedRuntimeOptions.TraceTransferToInterpreter);
        this.traceDeoptimizeFrame = options.get(OptimizedRuntimeOptions.TraceDeoptimizeFrame);
        this.compilationFailureAction = options.get(OptimizedRuntimeOptions.CompilationFailureAction);
        this.validateOptions(sandboxPolicy);
        this.parsedCompileOnly = null;
        Map<String, String> compilerOptionValues = OptimizedTruffleRuntime.CompilerOptionsDescriptors.extractOptions(this.engineOptions);
        this.updateCompilerOptions(compilerOptionValues);
        this.compilerOptions = compilerOptionValues;
    }

    private void updateCompilerOptions(Map<String, String> options) {
        if (this.compilationFailureAction == OptimizedRuntimeOptions.ExceptionAction.ExitVM) {
            options.put("compiler.DiagnoseFailure", "true");
        } else if (this.compilationFailureAction == OptimizedRuntimeOptions.ExceptionAction.Diagnose) {
            options.put("compiler.DiagnoseFailure", "true");
        } else if (this.compilationFailureAction == OptimizedRuntimeOptions.ExceptionAction.Throw) {
            options.put("compiler.DiagnoseFailure", "true");
        }
        if (TruffleOptions.AOT && this.traceTransferToInterpreter) {
            options.put("compiler.NodeSourcePositions", "true");
        }
        if (this.callTargetStatistics || this.callTargetStatisticDetails) {
            options.put("compiler.LogInlinedTargets", "true");
        }
    }

    public Map<String, String> getCompilerOptions() {
        return this.compilerOptions;
    }

    boolean acceptForCompilation(OptimizedCallTarget target) {
        if (!this.compilation) {
            return false;
        }
        Pair<List<String>, List<String>> value = this.getCompileOnly();
        if (value != null) {
            String name = target.getName();
            List<String> includes = value.getLeft();
            boolean included = includes.isEmpty();
            if (name != null) {
                for (int i = 0; !included && i < includes.size(); ++i) {
                    if (!name.contains(includes.get(i))) continue;
                    included = true;
                }
            }
            if (!included) {
                return false;
            }
            if (name != null) {
                for (String exclude : value.getRight()) {
                    if (!name.contains(exclude)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private Pair<List<String>, List<String>> getCompileOnly() {
        if (this.compileOnly == null) {
            return null;
        }
        Pair<List<String>, List<String>> result = this.parsedCompileOnly;
        if (result == null) {
            String[] items;
            ArrayList<String> includesList = new ArrayList<String>();
            ArrayList<String> excludesList = new ArrayList<String>();
            for (String item : items = this.compileOnly.split(",")) {
                if (item.startsWith("~")) {
                    excludesList.add(item.substring(1));
                    continue;
                }
                includesList.add(item);
            }
            this.parsedCompileOnly = result = Pair.create(includesList, excludesList);
        }
        return result;
    }

    public OptionValues getEngineOptions() {
        return this.engineOptions;
    }

    public Collection<OptimizedCallTarget> getCallTargets() {
        if (this.polyglotEngine == null) {
            throw new IllegalStateException("The polyglot engine is closed.");
        }
        return OptimizedRuntimeAccessor.ENGINE.findCallTargets(this.polyglotEngine);
    }

    private void validateOptions(SandboxPolicy sandboxPolicy) {
        if (sandboxPolicy.isStricterOrEqual(SandboxPolicy.CONSTRAINED) && this.compilationFailureAction != OptimizedRuntimeOptions.ExceptionAction.Silent && this.compilationFailureAction != OptimizedRuntimeOptions.ExceptionAction.Print) {
            throw OptimizedRuntimeAccessor.ENGINE.createPolyglotEngineException(EngineData.sandboxPolicyException(sandboxPolicy, "The engine.CompilationFailureAction option is set to " + this.compilationFailureAction.name() + ", but must be set to Silent or Print.", "use the default value (Silent) by removing Builder.option(\"engine.CompilationFailureAction\", ...) or set it to Print"));
        }
        if (this.compilationFailureAction == OptimizedRuntimeOptions.ExceptionAction.Throw && this.backgroundCompilation) {
            this.getEngineLogger().log(Level.WARNING, "The 'Throw' value of the 'engine.CompilationFailureAction' option requires the 'engine.BackgroundCompilation' option to be set to 'false'.");
        }
    }

    private int computeCallThresholdInInterpreter(OptionValues options) {
        if (this.compileImmediately) {
            return 0;
        }
        if (this.multiTier) {
            return Math.min(options.get(OptimizedRuntimeOptions.FirstTierMinInvokeThreshold), options.get(OptimizedRuntimeOptions.FirstTierCompilationThreshold));
        }
        return Math.min(options.get(OptimizedRuntimeOptions.MinInvokeThreshold), options.get(OptimizedRuntimeOptions.SingleTierCompilationThreshold));
    }

    private int computeCallAndLoopThresholdInInterpreter(OptionValues options) {
        if (this.compileImmediately) {
            return 0;
        }
        if (this.multiTier) {
            return options.get(OptimizedRuntimeOptions.FirstTierCompilationThreshold);
        }
        return options.get(OptimizedRuntimeOptions.SingleTierCompilationThreshold);
    }

    private int computeCallThresholdInFirstTier(OptionValues options) {
        if (this.compileImmediately) {
            return 0;
        }
        return Math.min(options.get(OptimizedRuntimeOptions.MinInvokeThreshold), options.get(OptimizedRuntimeOptions.LastTierCompilationThreshold));
    }

    private int computeCallAndLoopThresholdInFirstTier(OptionValues options) {
        if (this.compileImmediately) {
            return 0;
        }
        return options.get(OptimizedRuntimeOptions.LastTierCompilationThreshold);
    }

    public TruffleLogger getEngineLogger() {
        return this.getLogger("engine");
    }

    public TruffleLogger getLogger(String loggerId) {
        return this.polyglotEngine != null ? this.loggerFactory.apply(loggerId) : null;
    }

    public AtomicBoolean logShutdownCompilations() {
        return this.logShutdownCompilations;
    }

    public void mergeLoadedSources(Source[] sources) {
        OptimizedRuntimeAccessor.SOURCE.mergeLoadedSources(sources);
    }

    public Object enterLanguage(TruffleLanguage<?> language) {
        return OptimizedRuntimeAccessor.ENGINE.enterLanguageFromRuntime(language);
    }

    public void leaveLanguage(TruffleLanguage<?> language, Object prev) {
        OptimizedRuntimeAccessor.ENGINE.leaveLanguageFromRuntime(language, prev);
    }

    public TruffleLanguage<?> getLanguage(OptimizedCallTarget target) {
        RootNode root = target.getRootNode();
        return OptimizedRuntimeAccessor.NODES.getLanguage(root);
    }
}

