/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.visitors;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.AtomicGroup;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Group;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.SubexpressionCall;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.visitors.DepthFirstTraversalRegexASTVisitor;

public class PropagateDeadFlagVisitor
extends DepthFirstTraversalRegexASTVisitor {
    private int deadFlagsSeen = 0;

    public static void propagateDeadFlag(RegexASTNode runRoot) {
        new PropagateDeadFlagVisitor().run(runRoot);
    }

    private void mark(RegexASTNode node) {
        if (this.deadFlagsSeen > 0) {
            node.markAsDead();
        }
    }

    private void incFlagsSeen(RegexASTNode node) {
        if (node.isDead()) {
            ++this.deadFlagsSeen;
        }
    }

    private void decFlagsSeen(RegexASTNode node) {
        if (node.isDead()) {
            --this.deadFlagsSeen;
        }
        this.mark(node);
    }

    @Override
    protected void visit(BackReference backReference) {
        this.mark(backReference);
    }

    @Override
    protected void visit(Group group) {
        this.incFlagsSeen(group);
    }

    @Override
    protected void visit(Sequence sequence) {
        this.incFlagsSeen(sequence);
    }

    @Override
    protected void visit(SubexpressionCall subexpressionCall) {
        this.mark(subexpressionCall);
    }

    @Override
    protected void visit(PositionAssertion assertion) {
        this.mark(assertion);
    }

    @Override
    protected void visit(LookBehindAssertion assertion) {
        this.incFlagsSeen(assertion);
    }

    @Override
    protected void visit(LookAheadAssertion assertion) {
        this.incFlagsSeen(assertion);
    }

    @Override
    protected void visit(AtomicGroup atomicGroup) {
        this.incFlagsSeen(atomicGroup);
    }

    @Override
    protected void visit(CharacterClass characterClass) {
        this.mark(characterClass);
    }

    @Override
    protected void leave(Group group) {
        this.decFlagsSeen(group);
    }

    @Override
    protected void leave(Sequence sequence) {
        this.decFlagsSeen(sequence);
    }

    @Override
    protected void leave(LookBehindAssertion assertion) {
        this.decFlagsSeen(assertion);
    }

    @Override
    protected void leave(LookAheadAssertion assertion) {
        this.decFlagsSeen(assertion);
    }

    @Override
    protected void leave(AtomicGroup atomicGroup) {
        this.decFlagsSeen(atomicGroup);
    }
}

