/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.visitors;

import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.UnsupportedRegexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.LongArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.ASTStepVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.TransitionGuard;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexFlavor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.Token;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Group;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookAroundAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Term;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.MathUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TBitSet;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicSet;

public abstract class NFATraversalRegexASTVisitor {
    protected final RegexAST ast;
    private Term root;
    private final LongArrayBuffer curPath = new LongArrayBuffer(8);
    private final TBitSet insideEmptyGuardGroup;
    private RegexASTNode cur;
    private Set<LookBehindAssertion> traversableLookBehindAssertions;
    private boolean canTraverseCaret = false;
    private boolean ignoreMatchBoundaryAssertions = false;
    private TBitSet matchedConditionGroups;
    private boolean forward = true;
    private boolean done = false;
    private boolean shouldRetreat = false;
    private boolean recalcTransitionGuards = false;
    private final EconomicSet<DeduplicationKey> pathDeduplicationSet = EconomicSet.create();
    private final LongArrayBuffer dedupKey = new LongArrayBuffer(8);
    private final TBitSet lookAroundsOnPath;
    private int dollarsOnPath = 0;
    private int caretsOnPath = 0;
    private int matchBeginAssertionsOnPath = 0;
    private int matchEndAssertionsOnPath = 0;
    private final int[] lookAroundVisitedCount;
    private final TBitSet captureGroupUpdates;
    private final TBitSet captureGroupClears;
    private final TBitSet referencedGroupBoundaries;
    private int firstGroup = -1;
    private int lastGroup = -1;
    private final int[] bqLastCounterReset;
    private final int[] bqLastZeroWidthEnter;
    private final TBitSet bqExited;
    private final TBitSet bqBypassed;
    private final TBitSet referencedCaptureGroupsTmp;
    private final LongArrayBuffer transitionGuards = new LongArrayBuffer(8);
    private final LongArrayBuffer transitionGuardsCanonicalized = new LongArrayBuffer(8);
    private long[] transitionGuardsResult = null;

    protected NFATraversalRegexASTVisitor(RegexAST ast) {
        this.ast = ast;
        this.insideEmptyGuardGroup = new TBitSet(ast.getGroupsWithGuards().size());
        this.lookAroundsOnPath = new TBitSet(ast.getSubtrees().size());
        this.lookAroundVisitedCount = new int[ast.getSubtrees().size()];
        this.captureGroupUpdates = new TBitSet(ast.getNumberOfCaptureGroups() * 2);
        this.captureGroupClears = new TBitSet(ast.getNumberOfCaptureGroups() * 2);
        this.referencedGroupBoundaries = new TBitSet(ast.getNumberOfCaptureGroups() * 2);
        this.bqLastCounterReset = new int[ast.getQuantifierCount()];
        this.bqLastZeroWidthEnter = new int[ast.getGroupsWithGuards().size()];
        this.bqExited = new TBitSet(ast.getGroupsWithGuards().size());
        this.bqBypassed = new TBitSet(ast.getGroupsWithGuards().size());
        PrimitiveIterator.OfInt ofInt = ast.getReferencedGroups().iterator();
        while (ofInt.hasNext()) {
            int i = (Integer)ofInt.next();
            this.referencedGroupBoundaries.set(Group.groupNumberToBoundaryIndexStart(i));
            this.referencedGroupBoundaries.set(Group.groupNumberToBoundaryIndexEnd(i));
        }
        this.referencedCaptureGroupsTmp = new TBitSet(ast.getNumberOfCaptureGroups());
    }

    public Set<LookBehindAssertion> getTraversableLookBehindAssertions() {
        return this.traversableLookBehindAssertions;
    }

    public void setTraversableLookBehindAssertions(Set<LookBehindAssertion> traversableLookBehindAssertions) {
        this.traversableLookBehindAssertions = traversableLookBehindAssertions;
    }

    public boolean canTraverseCaret() {
        return this.canTraverseCaret;
    }

    public void setCanTraverseCaret(boolean canTraverseCaret) {
        this.canTraverseCaret = canTraverseCaret;
    }

    public void setIgnoreMatchBoundaryAssertions(boolean ignoreMatchBoundaryAssertions) {
        this.ignoreMatchBoundaryAssertions = ignoreMatchBoundaryAssertions;
    }

    public void setMatchedConditionGroups(TBitSet matchedConditionGroups) {
        this.matchedConditionGroups = matchedConditionGroups;
    }

    public TBitSet getMatchedConditionGroups() {
        assert (this.isBuildingDFA());
        return this.matchedConditionGroups;
    }

    protected TBitSet getCurrentMatchedConditionGroups() {
        assert (this.isBuildingDFA());
        if (!this.ast.getProperties().hasConditionalBackReferences()) {
            return this.matchedConditionGroups;
        }
        TBitSet currentMatchedConditionGroups = this.matchedConditionGroups.copy();
        PrimitiveIterator.OfInt ofInt = this.ast.getConditionGroups().iterator();
        while (ofInt.hasNext()) {
            int conditionGroup = (Integer)ofInt.next();
            if (this.getCaptureGroupClears().get(Group.groupNumberToBoundaryIndexEnd(conditionGroup))) {
                currentMatchedConditionGroups.clear(conditionGroup);
            }
            if (!this.getCaptureGroupUpdates().get(Group.groupNumberToBoundaryIndexEnd(conditionGroup))) continue;
            currentMatchedConditionGroups.set(conditionGroup);
        }
        return currentMatchedConditionGroups;
    }

    protected boolean isReverse() {
        return !this.forward;
    }

    public void setReverse(boolean reverse) {
        this.forward = !reverse;
    }

    private void setShouldRetreat() {
        this.shouldRetreat = true;
    }

    protected RegexFlavor getFlavor() {
        return this.ast.getOptions().getFlavor();
    }

    protected abstract boolean isBuildingDFA();

    protected abstract boolean canPruneAfterUnconditionalFinalState();

    private boolean canTraverseLookArounds() {
        return this.isBuildingDFA();
    }

    protected void run(Term runRoot) {
        this.clearCaptureGroupData();
        this.recalcTransitionGuards = false;
        assert (this.insideEmptyGuardGroup.isEmpty());
        assert (this.curPath.isEmpty());
        assert (this.dollarsOnPath == 0);
        assert (this.caretsOnPath == 0);
        assert (this.matchBeginAssertionsOnPath == 0);
        assert (this.matchEndAssertionsOnPath == 0);
        assert (this.lookAroundsOnPath.isEmpty());
        assert (NFATraversalRegexASTVisitor.isEmpty(this.lookAroundVisitedCount)) : Arrays.toString(this.lookAroundVisitedCount);
        assert (!this.shouldRetreat);
        assert (this.transitionGuards.isEmpty());
        assert (this.captureGroupUpdates.isEmpty());
        assert (this.captureGroupClears.isEmpty());
        assert (this.firstGroup == -1);
        assert (this.lastGroup == -1);
        this.root = runRoot;
        this.pathDeduplicationSet.clear();
        if (runRoot.isGroup() && runRoot.getParent().isSubtreeRoot()) {
            this.cur = runRoot;
        } else {
            if (runRoot.isGroup()) {
                this.pushGroupExit(runRoot.asGroup());
            }
            this.advanceTerm(runRoot);
        }
        boolean foundNextTarget = false;
        while (!this.done) {
            while (!this.done && !foundNextTarget) {
                foundNextTarget = this.doAdvance();
                if (this.isBuildingDFA() && this.cur.isOptionalQuantifier()) {
                    foundNextTarget = this.advanceTerm(this.cur.asGroup());
                }
                if (!foundNextTarget) continue;
                foundNextTarget = this.deduplicatePath(false);
            }
            if (this.done) break;
            assert (this.cur == this.pathGetNode(this.curPath.peek()));
            this.visit(this.cur);
            if (this.canPruneAfterUnconditionalFinalState() && this.cur.isMatchFound() && !this.dollarsOnPath() && !this.caretsOnPath() && this.lookAroundsOnPath.isEmpty() && !this.hasTransitionGuards() && !this.root.isPrefix()) {
                this.insideEmptyGuardGroup.clear();
                this.curPath.clear();
                this.clearCaptureGroupData();
                this.clearTransitionGuards();
                this.transitionGuardsResult = null;
                this.matchBeginAssertionsOnPath = 0;
                this.matchEndAssertionsOnPath = 0;
                break;
            }
            this.transitionGuardsResult = null;
            this.retreat();
            foundNextTarget = false;
            if (!this.cur.isGroup() || !this.cur.hasEmptyGuard() || this.done) continue;
            foundNextTarget = this.advanceTerm(this.cur.asGroup());
        }
        this.clearTransitionGuards();
        this.done = false;
    }

    protected abstract void visit(RegexASTNode var1);

    protected abstract void enterLookAhead(LookAheadAssertion var1);

    protected abstract void leaveLookAhead(LookAheadAssertion var1);

    protected boolean caretsOnPath() {
        return this.caretsOnPath > 0;
    }

    protected boolean dollarsOnPath() {
        return this.dollarsOnPath > 0;
    }

    protected boolean matchBeginAssertionsOnPath() {
        return this.matchBeginAssertionsOnPath > 0;
    }

    protected boolean matchEndAssertionsOnPath() {
        return this.matchEndAssertionsOnPath > 0;
    }

    protected boolean hasTransitionGuards() {
        this.calcTransitionGuardsResult();
        return this.transitionGuardsResult.length > 0;
    }

    protected long[] getTransitionGuardsOnPath() {
        this.calcTransitionGuardsResult();
        return this.transitionGuardsResult;
    }

    protected int needsMaintainGuard() {
        assert (this.cur instanceof Term);
        Group parentQuant = this.root.getQuantifiedParentGroup();
        Group otherParent = ((Term)this.cur).getQuantifiedParentGroup();
        if (parentQuant != null && parentQuant.equals(otherParent)) {
            PrimitiveIterator.OfLong ofLong = this.transitionGuardsCanonicalized.iterator();
            while (ofLong.hasNext()) {
                long guard = (Long)ofLong.next();
                if (!TransitionGuard.isQuantifierOp(guard)) continue;
                return -1;
            }
            return parentQuant.getQuantifier().getIndex();
        }
        return -1;
    }

    protected void calcTransitionGuardsResult() {
        if (this.transitionGuardsResult == null) {
            this.transitionGuardsResult = this.getTransitionGuards().isEmpty() ? TransitionGuard.NO_GUARDS : this.getTransitionGuards().toArray();
        }
    }

    protected GroupBoundaries getGroupBoundaries() {
        return this.ast.createGroupBoundaries(this.getCaptureGroupUpdates(), this.getCaptureGroupClears(), this.getFirstGroup(), this.getLastGroup());
    }

    private boolean doAdvance() {
        if (this.cur.isDead()) {
            return this.retreat();
        }
        if (this.cur.isSequence()) {
            Sequence sequence = (Sequence)this.cur;
            if (sequence.isEmpty()) {
                Group parent = sequence.getParent();
                if (sequence.isQuantifierPassThroughSequence()) {
                    assert (this.pathGetNode(this.curPath.peek()) == parent && PathElement.isGroupEnter(this.curPath.peek()));
                    this.switchEnterToPassThrough(parent);
                } else {
                    this.pushGroupExit(parent);
                }
                return this.advanceTerm(parent);
            }
            this.cur = this.forward ? sequence.getFirstTerm() : sequence.getLastTerm();
            return false;
        }
        if (this.cur.isGroup()) {
            Group group = (Group)this.cur;
            this.pushGroupEnter(group, 1);
            if (group.hasEmptyGuard()) {
                this.insideEmptyGuardGroup.set(group.getGroupsWithGuardsIndex());
            }
            this.cur = group.getFirstAlternative();
            return this.deduplicatePath(true);
        }
        this.curPath.add(PathElement.create(this.cur));
        if (this.cur.isPositionAssertion()) {
            return this.advancePositionAssertion(this.cur.asPositionAssertion());
        }
        if (this.cur.isLookAroundAssertion()) {
            return this.advanceLookAround(this.cur.asLookAroundAssertion());
        }
        assert (this.cur.isCharacterClass() || this.cur.isBackReference() || this.cur.isMatchFound() || this.cur.isAtomicGroup());
        if ((this.forward && this.dollarsOnPath() || !this.forward && this.caretsOnPath()) && !NFATraversalRegexASTVisitor.canMatchEmptyString(this.cur)) {
            return this.retreat();
        }
        if (!this.ignoreMatchBoundaryAssertions) {
            if ((this.forward && this.matchBeginAssertionsOnPath() || !this.forward && this.matchEndAssertionsOnPath()) && !this.isRootEnterOnPath() && !NFATraversalRegexASTVisitor.canMatchEmptyString(this.cur)) {
                return this.retreat();
            }
            if (this.matchEndAssertionsOnPath() && (this.cur.isCharacterClass() || this.cur.isBackReference())) {
                return this.retreat();
            }
        }
        return true;
    }

    private boolean advanceLookAround(LookAroundAssertion lookAround) {
        if (this.canTraverseLookArounds()) {
            if (lookAround.isLookAheadAssertion()) {
                this.enterLookAhead(lookAround.asLookAheadAssertion());
                this.addLookAroundToVisitedSet();
                return this.advanceTerm(lookAround);
            }
            assert (lookAround.isLookBehindAssertion());
            this.addLookAroundToVisitedSet();
            if (this.traversableLookBehindAssertions == null || this.traversableLookBehindAssertions.contains(lookAround.asLookBehindAssertion())) {
                return this.advanceTerm(lookAround);
            }
            return this.retreat();
        }
        return true;
    }

    private boolean advancePositionAssertion(PositionAssertion assertion) {
        switch (assertion.type) {
            case CARET: {
                ++this.caretsOnPath;
                if (this.canTraverseCaret) {
                    return this.advanceTerm(assertion);
                }
                return this.retreat();
            }
            case DOLLAR: {
                ++this.dollarsOnPath;
                return this.advanceTerm(assertion);
            }
            case MATCH_BEGIN: {
                if (!this.ignoreMatchBoundaryAssertions) {
                    ++this.matchBeginAssertionsOnPath;
                    if (this.forward && this.isBuildingDFA() && !this.isRootEnterOnPath()) {
                        return this.retreat();
                    }
                }
                return this.advanceTerm(assertion);
            }
            case MATCH_END: {
                if (!this.ignoreMatchBoundaryAssertions) {
                    ++this.matchEndAssertionsOnPath;
                    if (!this.forward && this.isBuildingDFA() && !this.isRootEnterOnPath()) {
                        return this.retreat();
                    }
                }
                return this.advanceTerm(assertion);
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private boolean advanceTerm(Term term) {
        if (this.ast.isNFAInitialState(term) || term.getParent().isSubtreeRoot() && (term.isPositionAssertion() || term.isMatchFound())) {
            assert (term.isPositionAssertion() || term.isMatchFound());
            this.cur = term.isPositionAssertion() ? term.asPositionAssertion().getNext() : term.asMatchFound().getNext();
            return false;
        }
        Term curTerm = term;
        while (!curTerm.getParent().isSubtreeRoot()) {
            if (curTerm.isGroupWithGuards() && this.insideEmptyGuardGroup.get(curTerm.asGroup().getGroupsWithGuardsIndex()) && !this.getFlavor().emptyChecksMonitorCaptureGroups()) {
                Group curGroup = curTerm.asGroup();
                Token.Quantifier quantifier = curGroup.getQuantifier();
                if (!this.getFlavor().emptyChecksOnMandatoryLoopIterations() && curGroup.isMandatoryQuantifier() && !curGroup.isExpandedQuantifier() && (!this.ast.getOptions().isBooleanMatch() || this.ast.getProperties().hasBackReferences() || this.caretsOnPath() || this.isReverse() && this.dollarsOnPath())) {
                    assert (quantifier.getMin() > 0);
                    if (this.isBuildingDFA()) {
                        throw new UnsupportedRegexException("Cannot compile regex with empty state to DFA/NFA");
                    }
                    this.popGroupExit();
                    this.cur = curTerm;
                    this.curPath.add(PathElement.create(this.cur));
                    return true;
                }
                if (this.isBuildingDFA() && curGroup.isMandatoryQuantifier() && !this.lookAroundsOnPath.isEmpty()) {
                    for (int i = this.curPath.length() - 1; i >= 0; --i) {
                        long element = this.curPath.get(i);
                        RegexASTNode node = this.pathGetNode(element);
                        if (PathElement.isGroupEnter(element) && node == curGroup) break;
                        if (!node.isLookAheadAssertion()) continue;
                        throw new UnsupportedRegexException("empty path with look-ahead assertion in expression with bounded quantifier");
                    }
                }
                return this.retreat();
            }
            Sequence parentSeq = (Sequence)curTerm.getParent();
            if (curTerm == (this.forward ? parentSeq.getLastTerm() : parentSeq.getFirstTerm())) {
                Group parentGroup = parentSeq.getParent();
                this.pushGroupExit(parentGroup);
                if (parentGroup.isLoop()) {
                    this.cur = parentGroup;
                    return false;
                }
                curTerm = parentGroup;
                continue;
            }
            this.cur = parentSeq.getTerms().get(curTerm.getSeqIndex() + (this.forward ? 1 : -1));
            return false;
        }
        assert (curTerm.isGroup());
        assert (curTerm.getParent().isSubtreeRoot());
        this.cur = curTerm.getSubTreeParent().getMatchFound();
        return false;
    }

    private boolean retreat() {
        this.shouldRetreat = false;
        while (!this.curPath.isEmpty()) {
            long lastElement = this.curPath.peek();
            RegexASTNode node = this.pathGetNode(lastElement);
            if (PathElement.isGroup(lastElement)) {
                Group group = (Group)node;
                if (PathElement.isGroupEnter(lastElement) || PathElement.isGroupPassThrough(lastElement)) {
                    if (this.pathGroupHasNext(lastElement)) {
                        this.switchNextGroupAlternative(group);
                        this.cur = this.pathGroupGetNext(lastElement);
                        return this.deduplicatePath(true);
                    }
                    if (PathElement.isGroupEnter(lastElement)) {
                        this.popGroupEnter();
                    } else {
                        assert (PathElement.isGroupPassThrough(lastElement));
                        this.popGroupPassThrough();
                    }
                    if (!group.hasEmptyGuard()) continue;
                    this.insideEmptyGuardGroup.clear(group.getGroupsWithGuardsIndex());
                    continue;
                }
                if (PathElement.isGroupExit(lastElement) && this.needsZeroWidthEscape(group)) {
                    this.switchExitToEscape(group);
                    Group parentGroup = group.getParent().getParent().asGroup();
                    this.pushGroupExit(parentGroup);
                    return this.advanceTerm(parentGroup);
                }
                if (PathElement.isGroupExit(lastElement)) {
                    this.popGroupExit();
                    continue;
                }
                assert (PathElement.isGroupEscape(lastElement));
                this.popGroupEscape(group);
                continue;
            }
            this.curPath.pop();
            if (this.canTraverseLookArounds() && node.isLookAroundAssertion()) {
                this.popLookAround(node, lastElement);
                continue;
            }
            if (!node.isPositionAssertion()) continue;
            this.popPositionAssertion(node);
        }
        this.done = true;
        return false;
    }

    private void popLookAround(RegexASTNode node, long pathElement) {
        if (node.isLookAheadAssertion()) {
            this.leaveLookAhead(node.asLookAheadAssertion());
        }
        this.removeLookAroundFromVisitedSet(pathElement);
    }

    private void popPositionAssertion(RegexASTNode node) {
        switch (node.asPositionAssertion().type) {
            case CARET: {
                --this.caretsOnPath;
                break;
            }
            case DOLLAR: {
                --this.dollarsOnPath;
                break;
            }
            case MATCH_BEGIN: {
                if (this.ignoreMatchBoundaryAssertions) break;
                --this.matchBeginAssertionsOnPath;
                break;
            }
            case MATCH_END: {
                if (this.ignoreMatchBoundaryAssertions) break;
                --this.matchEndAssertionsOnPath;
            }
        }
    }

    private boolean deduplicatePath(boolean internal) {
        boolean isDuplicate;
        this.calcTransitionGuards();
        if (this.shouldRetreat) {
            return this.retreat();
        }
        if (internal && this.getFlavor().emptyChecksMonitorCaptureGroups()) {
            return false;
        }
        assert (internal == this.cur.isSequence());
        boolean captureGroupsMatter = !this.cur.isMatchFound() && (this.getFlavor().backreferencesToUnmatchedGroupsFail() && this.ast.getProperties().hasBackReferences() || this.isBuildingDFA() && this.ast.getProperties().hasConditionalBackReferences());
        long id = this.cur.getId();
        if (this.caretsOnPath()) {
            id |= 0x100000000L;
        }
        if (this.dollarsOnPath()) {
            id |= 0x200000000L;
        }
        if (this.matchBeginAssertionsOnPath()) {
            id |= 0x400000000L;
        }
        if (this.matchEndAssertionsOnPath()) {
            id |= 0x800000000L;
        }
        this.dedupKey.clear();
        this.dedupKey.add(id);
        this.dedupKey.addAll(this.lookAroundsOnPath.getInternalArray());
        if (internal) {
            this.dedupKey.addAll(this.insideEmptyGuardGroup.getInternalArray());
        }
        if (captureGroupsMatter) {
            this.dedupKeyAddGroupBoundaries(this.getCaptureGroupUpdates());
            this.dedupKeyAddGroupBoundaries(this.getCaptureGroupClears());
        }
        PrimitiveIterator.OfLong ofLong = this.getTransitionGuards().iterator();
        while (ofLong.hasNext()) {
            long guard = (Long)ofLong.next();
            if (TransitionGuard.is(guard, TransitionGuard.Kind.updateCG)) continue;
            this.dedupKey.add(guard);
        }
        DeduplicationKey key = new DeduplicationKey(this.dedupKey.toArray());
        boolean bl = isDuplicate = !this.pathDeduplicationSet.add(key);
        if (isDuplicate) {
            return this.retreat();
        }
        return !internal;
    }

    private void dedupKeyAddGroupBoundaries(TBitSet boundaries) {
        long[] bitset = boundaries.getInternalArray();
        long[] referenced = this.referencedGroupBoundaries.getInternalArray();
        assert (bitset.length == referenced.length);
        for (int i = 0; i < bitset.length; ++i) {
            this.dedupKey.add(bitset[i] & referenced[i]);
        }
    }

    private static boolean canMatchEmptyString(RegexASTNode node) {
        if (node.isBackReference()) {
            return node.asBackReference().mayMatchEmptyString();
        }
        return !node.isCharacterClass();
    }

    private RegexASTNode pathGetNode(long pathElement) {
        return this.ast.getState(PathElement.getNodeId(pathElement));
    }

    private boolean pathGroupHasNext(long pathElement) {
        return PathElement.getGroupAltIndex(pathElement) < ((Group)this.pathGetNode(pathElement)).size();
    }

    private Sequence pathGroupGetNext(long pathElement) {
        return ((Group)this.pathGetNode(pathElement)).getAlternatives().get(PathElement.getGroupAltIndex(pathElement));
    }

    protected boolean isRootEnterOnPath() {
        return this.isGroupEnterOnPath(this.ast.getRoot());
    }

    private boolean isGroupEnterOnPath(Group group) {
        int groupNodeId = group.getId();
        PrimitiveIterator.OfLong ofLong = this.curPath.iterator();
        while (ofLong.hasNext()) {
            long element = (Long)ofLong.next();
            if (PathElement.getNodeId(element) != groupNodeId || !PathElement.isGroupEnter(element)) continue;
            return true;
        }
        return false;
    }

    private void pushGroupEnter(Group group, int groupAltIndex) {
        this.curPath.add(PathElement.createGroupEnter(group, groupAltIndex));
        this.recalcTransitionGuards = true;
    }

    private int popGroupEnter() {
        long pathEntry = this.curPath.pop();
        assert (PathElement.isGroupEnter(pathEntry));
        this.recalcTransitionGuards = true;
        return PathElement.getGroupAltIndex(pathEntry);
    }

    private void switchNextGroupAlternative(Group group) {
        int groupAltIndex;
        if (PathElement.isGroupEnter(this.curPath.peek())) {
            groupAltIndex = this.popGroupEnter();
        } else {
            assert (PathElement.isGroupPassThrough(this.curPath.peek()));
            groupAltIndex = this.popGroupPassThrough();
        }
        this.pushGroupEnter(group, groupAltIndex + 1);
    }

    private void pushGroupExit(Group group) {
        this.curPath.add(PathElement.createGroupExit(group));
        this.recalcTransitionGuards = true;
    }

    private void popGroupExit() {
        long pathEntry = this.curPath.pop();
        assert (PathElement.isGroupExit(pathEntry));
        this.recalcTransitionGuards = true;
    }

    private void pushGroupPassThrough(Group group, int groupAltIndex) {
        this.curPath.add(PathElement.createGroupPassThrough(group, groupAltIndex));
        this.recalcTransitionGuards = true;
    }

    private int popGroupPassThrough() {
        long pathEntry = this.curPath.pop();
        int groupAltIndex = PathElement.getGroupAltIndex(pathEntry);
        assert (PathElement.isGroupPassThrough(pathEntry));
        this.recalcTransitionGuards = true;
        return groupAltIndex;
    }

    private void switchEnterToPassThrough(Group group) {
        int groupAltIndex = this.popGroupEnter();
        this.pushGroupPassThrough(group, groupAltIndex);
    }

    private void switchExitToEscape(Group group) {
        this.popGroupExit();
        this.pushGroupEscape(group);
    }

    private void pushGroupEscape(Group group) {
        long groupEscape = PathElement.createGroupEscape(group);
        this.curPath.add(groupEscape);
        this.recalcTransitionGuards = true;
    }

    private void popGroupEscape(Group group) {
        long pathEntry = this.curPath.pop();
        assert (PathElement.isGroupEscape(pathEntry));
        assert (group == this.pathGetNode(pathEntry));
        this.recalcTransitionGuards = true;
    }

    private void clearCaptureGroupData() {
        this.captureGroupUpdates.clear();
        this.captureGroupClears.clear();
        this.firstGroup = -1;
        this.lastGroup = -1;
    }

    private TBitSet getCaptureGroupUpdates() {
        this.calcTransitionGuards();
        return this.captureGroupUpdates;
    }

    private TBitSet getCaptureGroupClears() {
        this.calcTransitionGuards();
        return this.captureGroupClears;
    }

    private int getFirstGroup() {
        this.calcTransitionGuards();
        return this.firstGroup;
    }

    private int getLastGroup() {
        this.calcTransitionGuards();
        return this.lastGroup;
    }

    private LongArrayBuffer getTransitionGuards() {
        this.calcTransitionGuards();
        return this.transitionGuardsCanonicalized;
    }

    private void calcTransitionGuards() {
        if (this.recalcTransitionGuards) {
            this.calculateTransitionGuards();
            this.recalcTransitionGuards = false;
        }
    }

    private int getBoundaryIndexStart(Group group) {
        return this.forward ? group.getBoundaryIndexStart() : group.getBoundaryIndexEnd();
    }

    private int getBoundaryIndexEnd(Group group) {
        return this.forward ? group.getBoundaryIndexEnd() : group.getBoundaryIndexStart();
    }

    private void calcGroupBoundariesEnter(Group group) {
        if (group.isCapturing()) {
            this.captureGroupUpdate(this.getBoundaryIndexStart(group));
            if (this.updatesLastGroupField(group) && this.firstGroup == -1) {
                this.firstGroup = group.getGroupNumber();
            }
        }
        if (this.clearsEnclosedGroups(group)) {
            int lo = Group.groupNumberToBoundaryIndexStart(group.getEnclosedCaptureGroupsLo());
            int hi = Group.groupNumberToBoundaryIndexEnd(group.getEnclosedCaptureGroupsHi() - 1);
            this.captureGroupClears.setRange(lo, hi);
            this.captureGroupUpdates.clearRange(lo, hi);
        }
    }

    private void calcGroupBoundariesExit(Group group) {
        if (group.isCapturing()) {
            this.captureGroupUpdate(this.getBoundaryIndexEnd(group));
            if (this.updatesLastGroupField(group)) {
                this.lastGroup = group.getGroupNumber();
            }
        }
    }

    private void captureGroupUpdate(int boundary) {
        this.captureGroupUpdates.set(boundary);
        this.captureGroupClears.clear(boundary);
    }

    private void calculateTransitionGuards() {
        int i;
        this.clearCaptureGroupData();
        this.bqExited.clear();
        this.bqBypassed.clear();
        Arrays.fill(this.bqLastZeroWidthEnter, -1);
        Arrays.fill(this.bqLastCounterReset, -1);
        this.transitionGuards.clear();
        this.transitionGuardsCanonicalized.clear();
        for (i = 0; i < this.curPath.length(); ++i) {
            Token.Quantifier quantifier;
            long element = this.curPath.get(i);
            if (!PathElement.isGroup(element)) continue;
            Group group = (Group)this.pathGetNode(element);
            int groupAltIndex = PathElement.getGroupAltIndex(element);
            if (PathElement.isGroupEnter(element)) {
                if (group.hasQuantifier()) {
                    quantifier = group.getQuantifier();
                    if (quantifier.hasIndex()) {
                        if (this.bqExited.get(group.getGroupsWithGuardsIndex()) && !this.bqBypassed.get(group.getGroupsWithGuardsIndex())) {
                            if (!this.isBuildingDFA() && group.isMandatoryQuantifier()) {
                                this.pushTransitionGuard(TransitionGuard.createCountLtMin(quantifier));
                            } else if (!quantifier.isInfiniteLoop()) {
                                this.pushTransitionGuard(TransitionGuard.createCountLtMax(quantifier));
                            }
                            this.pushTransitionGuard(TransitionGuard.createCountInc(quantifier));
                        } else if (group.isOptionalQuantifier()) {
                            this.pushTransitionGuard(TransitionGuard.createCountSetMin(quantifier));
                        } else {
                            this.pushTransitionGuard(TransitionGuard.createCountSet1(quantifier));
                        }
                    }
                    if (group.getEnclosedZeroWidthGroupsHi() - group.getEnclosedZeroWidthGroupsLo() > 0) {
                        this.bqBypassed.clearRange(group.getEnclosedZeroWidthGroupsLo(), group.getEnclosedZeroWidthGroupsHi() - 1);
                        this.bqExited.clearRange(group.getEnclosedZeroWidthGroupsLo(), group.getEnclosedZeroWidthGroupsHi() - 1);
                    }
                    if (this.needsEmptyCheck(group)) {
                        this.pushTransitionGuard(TransitionGuard.createEnterZeroWidth(quantifier));
                    }
                }
                if (this.needsUpdateCGStepByStep(group) && (this.getFlavor().usesLastGroupResultField() || !this.captureGroupUpdates.get(this.getBoundaryIndexStart(group)))) {
                    this.pushTransitionGuard(TransitionGuard.createUpdateCG(this.getBoundaryIndexStart(group)));
                }
                this.calcGroupBoundariesEnter(group);
                if (!group.isConditionalBackReferenceGroup()) continue;
                this.pushTransitionGuard(NFATraversalRegexASTVisitor.getConditionalBackReferenceGroupTransitionGuard(group, groupAltIndex));
                continue;
            }
            if (PathElement.isGroupExitOrEscape(element)) {
                if (PathElement.isGroupExit(element)) {
                    if (group.hasQuantifier()) {
                        quantifier = group.getQuantifier();
                        if (quantifier.hasIndex()) {
                            if (!this.root.isGroup()) {
                                this.bqLastCounterReset[quantifier.getIndex()] = this.transitionGuards.length();
                            }
                            this.bqExited.set(group.getGroupsWithGuardsIndex());
                        }
                        if (this.needsEmptyCheck(group)) {
                            this.pushTransitionGuard(TransitionGuard.createExitZeroWidth(quantifier));
                        }
                    }
                } else if (PathElement.isGroupEscape(element) && group.hasQuantifier()) {
                    quantifier = group.getQuantifier();
                    if (quantifier.hasIndex()) {
                        this.bqLastCounterReset[quantifier.getIndex()] = this.transitionGuards.length();
                        if (this.bqBypassed.get(group.getGroupsWithGuardsIndex())) {
                            this.setShouldRetreat();
                        }
                        this.bqBypassed.set(group.getGroupsWithGuardsIndex());
                    }
                    if (quantifier.hasZeroWidthIndex()) {
                        this.pushTransitionGuard(TransitionGuard.createEscapeZeroWidth(quantifier));
                    }
                }
                this.pushRecursiveBackrefUpdates(group);
                if (this.needsUpdateCGStepByStep(group) && (this.getFlavor().usesLastGroupResultField() || !this.captureGroupUpdates.get(this.getBoundaryIndexEnd(group)))) {
                    this.pushTransitionGuard(TransitionGuard.createUpdateCG(this.getBoundaryIndexEnd(group)));
                }
                this.calcGroupBoundariesExit(group);
                continue;
            }
            if (!PathElement.isGroupPassThrough(element)) continue;
            Group quantifierGroup = NFATraversalRegexASTVisitor.getQuantifiedGroupFromPassthrough(group, groupAltIndex);
            Token.Quantifier quantifier2 = quantifierGroup.getQuantifier();
            if (quantifierGroup.isExpandedQuantifier()) continue;
            if (quantifierGroup.isDead()) {
                if (quantifier2.getMin() <= 0 || quantifierGroup.isOptionalQuantifier()) continue;
                this.setShouldRetreat();
                continue;
            }
            if (!quantifier2.hasIndex()) continue;
            if (this.bqBypassed.get(quantifierGroup.getGroupsWithGuardsIndex())) {
                this.setShouldRetreat();
            }
            this.bqBypassed.set(quantifierGroup.getGroupsWithGuardsIndex());
            if (!quantifierGroup.isMandatoryQuantifier() && (quantifier2.getMin() <= 0 || quantifierGroup.isOptionalQuantifier())) continue;
            if (this.root.isGroup() || !this.bqExited.get(quantifierGroup.getGroupsWithGuardsIndex())) {
                this.setShouldRetreat();
            }
            if (quantifier2.getMin() <= 1) continue;
            this.pushTransitionGuard(TransitionGuard.createCountGeMin(quantifier2));
        }
        for (i = 0; i < this.transitionGuards.length(); ++i) {
            long guard = this.transitionGuards.get(i);
            if (!this.shouldKeepGuard(guard, i)) continue;
            this.transitionGuardsCanonicalized.add(guard);
        }
    }

    private boolean shouldKeepGuard(long guard, int guardPosition) {
        switch (TransitionGuard.getKind(guard)) {
            case countSet1: 
            case countInc: 
            case countSetMinInc: {
                return this.getFlavor().emptyChecksMonitorCaptureGroups() || guardPosition >= this.bqLastCounterReset[TransitionGuard.getQuantifierIndex(guard)];
            }
            case enterZeroWidth: {
                int zeroWidthQuantifierIndex = TransitionGuard.getZeroWidthQuantifierIndex(guard);
                Group quantifiedTerm = (Group)this.ast.getZeroWidthQuantifiables().get(zeroWidthQuantifierIndex);
                return this.bqLastZeroWidthEnter[zeroWidthQuantifierIndex] == guardPosition && (quantifiedTerm.hasCaret() || quantifiedTerm.hasLookArounds() || quantifiedTerm.hasBackReferences() || quantifiedTerm.hasAtomicGroups() || this.hasReferencedCaptureGroups(quantifiedTerm) || this.cur.isGroup() && this.cur.asGroup().getQuantifier().getZeroWidthIndex() != zeroWidthQuantifierIndex);
            }
            case updateRecursiveBackrefPointer: {
                for (int i = this.transitionGuards.length() - 1; i > guardPosition; --i) {
                    if (this.transitionGuards.get(i) != guard) continue;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private boolean hasReferencedCaptureGroups(Group quantifiedTerm) {
        if (!this.ast.getProperties().hasBackReferences() || !quantifiedTerm.hasCaptureGroups()) {
            return false;
        }
        this.referencedCaptureGroupsTmp.clear();
        this.referencedCaptureGroupsTmp.setRange(quantifiedTerm.getCaptureGroupsLo(), quantifiedTerm.getCaptureGroupsHi() - 1);
        return !this.ast.getReferencedGroups().isDisjoint(this.referencedCaptureGroupsTmp);
    }

    private static Group getQuantifiedGroupFromPassthrough(Group group, int groupAltIndex) {
        Term quantifiedTerm;
        assert (group.size() == 2 && groupAltIndex - 1 >= 0 && groupAltIndex - 1 <= 1);
        int otherAltIndex = groupAltIndex - 1 ^ 1;
        Sequence otherAlternative = group.getAlternatives().get(otherAltIndex);
        Term term = quantifiedTerm = group.isInLookBehindAssertion() ? otherAlternative.getLastTerm() : otherAlternative.getFirstTerm();
        assert (!otherAlternative.isEmpty() && quantifiedTerm.isGroup());
        Group quantifierGroup = quantifiedTerm.asGroup();
        assert (quantifierGroup.hasQuantifier());
        return quantifierGroup;
    }

    private boolean needsUpdateCGStepByStep(Group group) {
        return this.getFlavor().matchesTransitionsStepByStep() && group.isCapturing();
    }

    private boolean needsEmptyCheck(Group group) {
        assert (group.hasQuantifier());
        return group.getQuantifier().hasZeroWidthIndex() && (this.getFlavor().emptyChecksOnMandatoryLoopIterations() || !group.isMandatoryUnrolledQuantifier());
    }

    private boolean needsZeroWidthEscape(Group group) {
        if (this.getFlavor().failingEmptyChecksDontBacktrack()) {
            return group.hasQuantifier() && group.getQuantifier().hasZeroWidthIndex();
        }
        return group.hasNotUnrolledQuantifier() && group.getQuantifier().hasZeroWidthIndex() && group.getQuantifier().getMin() > 0 && group.isMandatoryQuantifier();
    }

    private boolean clearsEnclosedGroups(Group group) {
        return !this.getFlavor().nestedCaptureGroupsKeptOnLoopReentry() && group.hasQuantifier() && group.hasEnclosedCaptureGroups();
    }

    private boolean updatesLastGroupField(Group group) {
        return this.getFlavor().usesLastGroupResultField() && group.isCapturing() && group.getGroupNumber() != 0;
    }

    private static long getConditionalBackReferenceGroupTransitionGuard(Group group, int groupAltIndex) {
        assert (group.isConditionalBackReferenceGroup());
        int referencedGroupNumber = group.asConditionalBackReferenceGroup().getReferencedGroupNumber();
        if (groupAltIndex == 1) {
            return TransitionGuard.createCheckGroupMatched(referencedGroupNumber);
        }
        assert (groupAltIndex == 2);
        return TransitionGuard.createCheckGroupNotMatched(referencedGroupNumber);
    }

    private void pushRecursiveBackrefUpdates(Group group) {
        if (this.getFlavor().supportsRecursiveBackreferences() && this.ast.getProperties().hasRecursiveBackReferences() && group.isCapturing() && this.ast.isGroupRecursivelyReferenced(group.getGroupNumber())) {
            this.pushTransitionGuard(TransitionGuard.createUpdateRecursiveBackref(group.getGroupNumber()));
        }
    }

    private void clearTransitionGuards() {
        this.transitionGuards.clear();
        this.transitionGuardsCanonicalized.clear();
    }

    private void pushTransitionGuard(long guard) {
        block0 : switch (TransitionGuard.getKind(guard)) {
            case countSet1: 
            case countSetMinInc: {
                this.bqLastCounterReset[TransitionGuard.getQuantifierIndex((long)guard)] = this.transitionGuards.length();
                break;
            }
            case countLtMin: 
            case countGeMin: 
            case countLtMax: {
                if (!this.canOmitCounterCheck(guard)) break;
                return;
            }
            case exitZeroWidth: 
            case escapeZeroWidth: {
                boolean keptAliveByConsumedInput = false;
                boolean keptAliveByCaptureGroups = false;
                if (!this.transitionGuards.isEmpty() && this.transitionGuards.peek() == guard) {
                    return;
                }
                long enter = TransitionGuard.createEnterZeroWidthFromExit(guard);
                boolean enterFound = false;
                for (int i = this.transitionGuards.length() - 1; i >= 0; --i) {
                    long tg = this.transitionGuards.get(i);
                    if (tg == enter) {
                        enterFound = true;
                        break;
                    }
                    if (!this.getFlavor().emptyChecksMonitorCaptureGroups() || !TransitionGuard.is(tg, TransitionGuard.Kind.updateCG)) continue;
                    keptAliveByCaptureGroups = true;
                }
                if (!enterFound) {
                    keptAliveByConsumedInput = this.isBuildingDFA() || !NFATraversalRegexASTVisitor.canMatchEmptyString(this.root);
                }
                boolean keptAlive = keptAliveByConsumedInput || keptAliveByCaptureGroups;
                boolean isExit = TransitionGuard.is(guard, TransitionGuard.Kind.exitZeroWidth);
                boolean isEscape = TransitionGuard.is(guard, TransitionGuard.Kind.escapeZeroWidth);
                int zeroWidthQuantifierIndex = TransitionGuard.getZeroWidthQuantifierIndex(guard);
                if (isEscape) {
                    this.bqLastZeroWidthEnter[zeroWidthQuantifierIndex] = -1;
                }
                if ((isExit && !keptAlive || isEscape && keptAlive) && (this.isBuildingDFA() || isExit && enterFound || !NFATraversalRegexASTVisitor.canMatchEmptyString(this.root) || this.root.isMatchFound())) {
                    this.setShouldRetreat();
                }
                if (!this.isBuildingDFA() && NFATraversalRegexASTVisitor.canMatchEmptyString(this.root) && !this.root.isMatchFound() && (!this.root.isGroup() || this.root.asGroup().getQuantifier().getZeroWidthIndex() != zeroWidthQuantifierIndex) && (!isEscape || !enterFound || keptAliveByCaptureGroups)) break;
                return;
            }
            case enterZeroWidth: {
                int zeroWidthQuantifierIndex = TransitionGuard.getZeroWidthQuantifierIndex(guard);
                if (this.bqLastZeroWidthEnter[zeroWidthQuantifierIndex] < 0) {
                    this.bqLastZeroWidthEnter[zeroWidthQuantifierIndex] = this.transitionGuards.length();
                    break;
                }
                if (!this.getFlavor().emptyChecksMonitorCaptureGroups()) break;
                for (int i = this.transitionGuards.length() - 1; i >= this.bqLastZeroWidthEnter[zeroWidthQuantifierIndex]; --i) {
                    if (!TransitionGuard.is(this.transitionGuards.get(i), TransitionGuard.Kind.updateCG)) continue;
                    this.bqLastZeroWidthEnter[zeroWidthQuantifierIndex] = this.transitionGuards.length();
                    break block0;
                }
                break;
            }
            case checkGroupMatched: 
            case checkGroupNotMatched: {
                boolean groupMatched;
                assert ((this.isBuildingDFA() && this.getMatchedConditionGroups() != null) == this instanceof ASTStepVisitor);
                if (!this.isBuildingDFA() || this.getMatchedConditionGroups() == null) break;
                int referencedGroupNumber = TransitionGuard.getGroupNumber(guard);
                int groupEndIndex = Group.groupNumberToBoundaryIndexEnd(referencedGroupNumber);
                boolean bl = groupMatched = this.getMatchedConditionGroups().get(referencedGroupNumber) && !this.captureGroupClears.get(groupEndIndex) || this.captureGroupUpdates.get(groupEndIndex);
                if (TransitionGuard.is(guard, TransitionGuard.Kind.checkGroupMatched) != groupMatched) {
                    this.setShouldRetreat();
                }
                return;
            }
        }
        this.transitionGuards.add(guard);
    }

    private boolean canOmitCounterCheck(long guard) {
        assert (TransitionGuard.is(guard, TransitionGuard.Kind.countLtMin) || TransitionGuard.is(guard, TransitionGuard.Kind.countGeMin) || TransitionGuard.is(guard, TransitionGuard.Kind.countLtMax));
        int quantifierIndex = TransitionGuard.getQuantifierIndex(guard);
        int min = this.ast.getQuantifier(quantifierIndex).getMin();
        int max = this.ast.getQuantifier(quantifierIndex).getMax();
        int minPlus1 = MathUtil.saturatingInc(min);
        long countLtMin = TransitionGuard.createCountLtMin(quantifierIndex);
        long countGeMin = TransitionGuard.createCountGeMin(quantifierIndex);
        long countLtMax = TransitionGuard.createCountLtMax(quantifierIndex);
        long countInc = TransitionGuard.createCountInc(quantifierIndex);
        long countSetMin = TransitionGuard.createCountSetMin(quantifierIndex);
        long countSet1 = TransitionGuard.createCountSet1(quantifierIndex);
        int counterLow = 0;
        int counterHigh = Integer.MAX_VALUE;
        PrimitiveIterator.OfLong ofLong = this.transitionGuards.iterator();
        while (ofLong.hasNext()) {
            long existingGuard = (Long)ofLong.next();
            if (existingGuard == countLtMin) {
                counterHigh = Math.min(counterHigh, min - 1);
                continue;
            }
            if (existingGuard == countGeMin) {
                counterLow = Math.max(counterLow, min);
                continue;
            }
            if (existingGuard == countLtMax) {
                counterHigh = Math.min(counterHigh, max - 1);
                continue;
            }
            if (existingGuard == countSetMin) {
                counterLow = minPlus1;
                counterHigh = minPlus1;
                continue;
            }
            if (existingGuard == countSet1) {
                counterLow = 1;
                counterHigh = 1;
                continue;
            }
            if (existingGuard != countInc) continue;
            counterLow = MathUtil.saturatingInc(counterLow);
            counterHigh = MathUtil.saturatingInc(counterHigh);
        }
        switch (TransitionGuard.getKind(guard)) {
            case countLtMin: {
                if (counterHigh < min) {
                    return true;
                }
                if (counterLow >= min) {
                    this.setShouldRetreat();
                    return true;
                }
                return false;
            }
            case countLtMax: {
                if (counterHigh < max) {
                    return true;
                }
                if (counterLow >= max) {
                    this.setShouldRetreat();
                    return true;
                }
                return false;
            }
            case countGeMin: {
                if (counterLow >= min) {
                    return true;
                }
                if (counterHigh < min) {
                    this.setShouldRetreat();
                    return true;
                }
                return false;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private void addLookAroundToVisitedSet() {
        LookAroundAssertion la = (LookAroundAssertion)this.cur;
        int n = la.getGlobalSubTreeId();
        this.lookAroundVisitedCount[n] = this.lookAroundVisitedCount[n] + 1;
        this.lookAroundsOnPath.set(la.getGlobalSubTreeId());
    }

    private void removeLookAroundFromVisitedSet(long pathElement) {
        LookAroundAssertion la = (LookAroundAssertion)this.pathGetNode(pathElement);
        int n = la.getGlobalSubTreeId();
        this.lookAroundVisitedCount[n] = this.lookAroundVisitedCount[n] - 1;
        if (this.lookAroundVisitedCount[n] == 0) {
            this.lookAroundsOnPath.clear(la.getGlobalSubTreeId());
        }
    }

    private static boolean isEmpty(int[] array) {
        for (int i : array) {
            if (i == 0) continue;
            return false;
        }
        return true;
    }

    private void dumpPath() {
        System.out.println("NEW PATH");
        for (int i = 0; i < this.curPath.length(); ++i) {
            long element = this.curPath.get(i);
            if (PathElement.isGroup(element)) {
                Group group = (Group)this.pathGetNode(element);
                if (PathElement.isGroupEnter(element)) {
                    System.out.printf("ENTER (%2d)  %2d %s%n", PathElement.getGroupAltIndex(element), group.getId(), group);
                    continue;
                }
                if (PathElement.isGroupExit(element)) {
                    System.out.printf("EXIT        %2d %s%n", group.getId(), group);
                    continue;
                }
                if (PathElement.isGroupPassThrough(element)) {
                    System.out.printf("PASSTHROUGH %2d %s%n", group.getId(), group);
                    continue;
                }
                System.out.printf("ESCAPE      %2d %s%n", group.getId(), group);
                continue;
            }
            System.out.printf("NODE        %2d %s%n", PathElement.getNodeId(element), this.pathGetNode(element));
        }
    }

    protected void dumpTransitionGuards(long[] guards) {
        for (long guard : guards) {
            System.out.println(TransitionGuard.toString(guard));
        }
    }

    private static final class PathElement {
        private static final int PATH_GROUP_ALT_INDEX_OFFSET = 0;
        private static final int PATH_NODE_OFFSET = 16;
        private static final int GROUP_ACTION_OFFSET = 48;
        private static final long GROUP_ACTION_ENTER = 0x1000000000000L;
        private static final long GROUP_ACTION_EXIT = 0x2000000000000L;
        private static final long GROUP_ACTION_PASS_THROUGH = 0x4000000000000L;
        private static final long GROUP_ACTION_ESCAPE = 0x8000000000000L;
        private static final long GROUP_ACTION_ANY = 0xF000000000000L;

        private PathElement() {
        }

        private static long create(RegexASTNode node) {
            return (long)node.getId() << 16;
        }

        private static long createGroupEnter(Group group, int groupAltIndex) {
            return PathElement.create(group) | (long)(groupAltIndex << 0) | 0x1000000000000L;
        }

        public static long createGroupPassThrough(Group group, int groupAltIndex) {
            return PathElement.create(group) | (long)(groupAltIndex << 0) | 0x4000000000000L;
        }

        public static long createGroupExit(Group group) {
            return PathElement.create(group) | 0x2000000000000L;
        }

        public static long createGroupEscape(Group group) {
            return PathElement.create(group) | 0x8000000000000L;
        }

        private static int getNodeId(long pathElement) {
            return (int)(pathElement >>> 16);
        }

        private static int getGroupAltIndex(long pathElement) {
            return (short)(pathElement >>> 0);
        }

        private static boolean isGroup(long pathElement) {
            return (pathElement & 0xF000000000000L) != 0L;
        }

        private static boolean isGroupEnter(long pathElement) {
            return (pathElement & 0x1000000000000L) != 0L;
        }

        private static boolean isGroupExit(long pathElement) {
            return (pathElement & 0x2000000000000L) != 0L;
        }

        private static boolean isGroupPassThrough(long pathElement) {
            return (pathElement & 0x4000000000000L) != 0L;
        }

        private static boolean isGroupEscape(long pathElement) {
            return (pathElement & 0x8000000000000L) != 0L;
        }

        private static boolean isGroupExitOrEscape(long pathElement) {
            return (pathElement & 0xA000000000000L) != 0L;
        }
    }

    private static final class DeduplicationKey {
        private final long[] key;
        private final int hashCode;

        DeduplicationKey(long[] key) {
            this.key = key;
            this.hashCode = Arrays.hashCode(key);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeduplicationKey)) {
                return false;
            }
            DeduplicationKey other = (DeduplicationKey)obj;
            return Arrays.equals(this.key, other.key);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

