/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.AtomicGroup;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.CalcASTPropsVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Group;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.visitors.DepthFirstTraversalRegexASTVisitor;

public class CalcASTFlagsVisitor
extends DepthFirstTraversalRegexASTVisitor {
    private static final int OR_FLAGS_GROUP = 133171212;
    private final RegexAST ast;

    public CalcASTFlagsVisitor(RegexAST ast) {
        this.ast = ast;
    }

    public static void run(RegexAST ast) {
        CalcASTFlagsVisitor visitor = new CalcASTFlagsVisitor(ast);
        visitor.run(ast.getRoot());
    }

    @Override
    protected void visit(BackReference backReference) {
        backReference.setHasBackReferences();
        backReference.getParent().setHasBackReferences();
        backReference.setMayMatchEmptyString(true);
    }

    @Override
    protected void visit(Sequence sequence) {
        sequence.setMayMatchEmptyString(true);
    }

    @Override
    protected void leave(Group group) {
        int flags = 0;
        for (Sequence s : group.getAlternatives()) {
            flags |= s.getFlags(133171212);
        }
        if (group.isLoop()) {
            flags |= 0x200000;
        }
        if (group.isCapturing()) {
            flags |= 0x400000;
        }
        group.setFlags(flags, 133171212);
        if (group.getParent() != null) {
            if (!group.mayMatchEmptyString() && !group.hasMin0Quantifier()) {
                group.getParent().setMayMatchEmptyString(false);
            }
            group.getParent().setFlags(group.getParent().getFlags(133169164) | flags & 0xFFFFF7FF, 133169164);
        }
    }

    @Override
    protected void visit(CharacterClass characterClass) {
        if (!characterClass.hasMin0Quantifier()) {
            characterClass.getParent().setMayMatchEmptyString(false);
        }
    }

    @Override
    protected void visit(PositionAssertion assertion) {
        switch (assertion.type) {
            case CARET: {
                assertion.getParent().setHasCaret();
                break;
            }
            case DOLLAR: {
                assertion.getParent().setHasDollar();
                break;
            }
            case MATCH_BEGIN: 
            case MATCH_END: {
                this.ast.getProperties().setMatchBoundaryAssertions();
            }
        }
    }

    @Override
    protected void visit(LookBehindAssertion assertion) {
        assertion.setHasLookBehinds();
        assertion.getParent().setHasLookBehinds();
    }

    @Override
    protected void leave(LookBehindAssertion assertion) {
        CalcASTPropsVisitor.setFlagsLookAroundAssertion(assertion);
    }

    @Override
    protected void visit(LookAheadAssertion assertion) {
        assertion.setHasLookAheads();
        assertion.getParent().setHasLookAheads();
    }

    @Override
    protected void leave(LookAheadAssertion assertion) {
        CalcASTPropsVisitor.setFlagsLookAroundAssertion(assertion);
    }

    @Override
    protected void leave(AtomicGroup atomicGroup) {
        atomicGroup.setHasAtomicGroups();
        atomicGroup.getParent().setHasAtomicGroups();
        CalcASTPropsVisitor.setFlagsSubtreeRootNode(atomicGroup, 133169164);
        if (!atomicGroup.mayMatchEmptyString()) {
            atomicGroup.getParent().setMayMatchEmptyString(false);
        }
    }
}

