/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa;

import java.util.Arrays;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractTransitionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupPartialTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.Json;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonValue;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.EmptyArrays;

public final class DFASimpleCGTransition
extends DFAAbstractTransitionNode
implements JsonConvertible {
    private static final byte[] FULL_CLEAR_ARRAY = new byte[0];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] indexUpdates;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] indexClears;
    private final short lastGroup;
    private final boolean isFinalTransition;

    private DFASimpleCGTransition(short id, short successor, byte[] indexUpdates, byte[] indexClears, int lastGroup, boolean isFinalTransition) {
        super(id, successor);
        this.indexUpdates = indexUpdates;
        this.indexClears = indexClears;
        assert (lastGroup <= Short.MAX_VALUE);
        this.lastGroup = (short)lastGroup;
        this.isFinalTransition = isFinalTransition;
    }

    public static DFASimpleCGTransition create(short id, short successor, NFAStateTransition t, boolean fullClear, boolean isFinalTransition) {
        if (t == null || !fullClear && t.getGroupBoundaries().isEmpty()) {
            return null;
        }
        t.getGroupBoundaries().materializeArrays();
        return new DFASimpleCGTransition(id, successor, t.getGroupBoundaries().isEmpty() ? EmptyArrays.BYTE : t.getGroupBoundaries().updatesToByteArray(), fullClear ? FULL_CLEAR_ARRAY : t.getGroupBoundaries().clearsToByteArray(), t.getGroupBoundaries().getLastGroup(), isFinalTransition);
    }

    @Override
    void apply(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        int index = executor.isForward() ? locals.getIndex() : locals.getNextIndex();
        int[] result = this.isFinalTransition && executor.getProperties().isSimpleCGMustCopy() ? locals.getCGData().currentResult : locals.getCGData().results;
        this.apply(result, index, executor.getProperties().tracksLastGroup(), executor.isForward());
    }

    private boolean isFullClear() {
        return this.indexClears == FULL_CLEAR_ARRAY;
    }

    public void apply(int[] result, int currentIndex, boolean trackLastGroup, boolean forward) {
        CompilerAsserts.partialEvaluationConstant(this);
        if (this.isFullClear()) {
            Arrays.fill(result, -1);
        } else {
            this.applyIndexClear(result);
        }
        this.applyIndexUpdate(result, currentIndex);
        if (trackLastGroup && this.lastGroup != -1) {
            this.applyLastGroup(result, forward);
        }
    }

    private void applyLastGroup(int[] result, boolean forward) {
        if (forward || result[result.length - 1] == -1) {
            result[result.length - 1] = this.lastGroup;
        }
    }

    @ExplodeLoop
    private void applyIndexUpdate(int[] result, int currentIndex) {
        for (int i = 0; i < this.indexUpdates.length; ++i) {
            int targetIndex = Byte.toUnsignedInt(this.indexUpdates[i]);
            result[targetIndex] = currentIndex;
        }
    }

    @ExplodeLoop
    private void applyIndexClear(int[] result) {
        for (int i = 0; i < this.indexClears.length; ++i) {
            int targetIndex = Byte.toUnsignedInt(this.indexClears[i]);
            result[targetIndex] = -1;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DFASimpleCGTransition)) {
            return false;
        }
        DFASimpleCGTransition o = (DFASimpleCGTransition)obj;
        return this.getSuccessor() == o.getSuccessor() && this.lastGroup == o.lastGroup && this.isFullClear() == o.isFullClear() && Arrays.equals(this.indexUpdates, o.indexUpdates) && Arrays.equals(this.indexClears, o.indexClears);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indexUpdates), Arrays.hashCode(this.indexClears), this.lastGroup, this.getSuccessor());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("indexUpdates", DFACaptureGroupPartialTransition.IndexOperation.groupBoundariesToJsonObject(this.indexUpdates)), Json.prop("indexClears", DFACaptureGroupPartialTransition.IndexOperation.groupBoundariesToJsonObject(this.indexClears)), Json.prop("lastGroup", this.lastGroup));
    }
}

