/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.TransitionConstraint;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTracker;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonValue;

public final class DFABQTrackingTransitionConstraintsNode
extends DFAAbstractStateNode {
    @CompilerDirectives.CompilationFinal(dimensions=2)
    public final long[][] constraints;

    public DFABQTrackingTransitionConstraintsNode(short id, short[] successors, long[][] constraints) {
        super(id, successors);
        this.constraints = constraints;
    }

    @ExplodeLoop
    public static boolean constraintsAreSatisfied(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, long[] constraints) {
        CompilerAsserts.partialEvaluationConstant(executor);
        CompilerAsserts.partialEvaluationConstant(constraints);
        for (long constraint : constraints) {
            int qId = TransitionConstraint.getQuantifierID(constraint);
            CompilerAsserts.partialEvaluationConstant(constraint);
            CompilerAsserts.partialEvaluationConstant(qId);
            CounterTracker counterTracker = executor.getCounterTrackers()[qId];
            CompilerAsserts.partialEvaluationConstant(counterTracker);
            if (counterTracker.canExecute(constraint, locals.getFixedData(), locals.getIntArrays())) continue;
            return false;
        }
        return true;
    }

    @Override
    public JsonValue toJson() {
        return null;
    }
}

