/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.TransitionOp;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTracker;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerData;

public final class CounterTrackerTrivialAlwaysReEnter
extends CounterTracker {
    private final int min;
    private final int fixedOffset;

    public CounterTrackerTrivialAlwaysReEnter(int min, int numberOfCells, CounterTrackerData.Builder dataBuilder) {
        this.min = min;
        this.fixedOffset = dataBuilder.getFixedDataSize();
        dataBuilder.requestFixedSize(numberOfCells);
    }

    @Override
    @ExplodeLoop
    public void apply(long op, long[] data, int[][] intArrays) {
        CompilerAsserts.partialEvaluationConstant(op);
        int dst = this.mapId(TransitionOp.getTarget(op));
        int kind = TransitionOp.getKind(op);
        int modifier = TransitionOp.getModifier(op);
        switch (kind) {
            case 2: {
                if (modifier == 2) {
                    return;
                }
                CounterTrackerTrivialAlwaysReEnter.update(modifier, data, dst, 1L);
                break;
            }
            case 1: {
                CounterTrackerTrivialAlwaysReEnter.update(modifier, data, dst, data[this.mapId(TransitionOp.getSource(op))] + 1L);
                break;
            }
            case 0: {
                int src = this.mapId(TransitionOp.getSource(op));
                if (modifier == 3) {
                    long tmp = data[dst];
                    data[dst] = data[src];
                    data[src] = tmp;
                    break;
                }
                CounterTrackerTrivialAlwaysReEnter.update(modifier, data, dst, data[src]);
            }
        }
    }

    private static void update(int modifier, long[] data, int dst, long newCount) {
        CompilerAsserts.partialEvaluationConstant(modifier);
        if (modifier == 1) {
            data[dst] = newCount;
        } else {
            assert (modifier == 2);
            data[dst] = Math.max(newCount, data[dst]);
        }
    }

    @Override
    public void init(long[] fixedData, int[][] intArrays) {
    }

    @Override
    public boolean support(long operation) {
        return true;
    }

    private int mapId(int sId) {
        return sId + this.fixedOffset;
    }

    @Override
    protected boolean anyLtMax(int sId, long[] fixedData, int[][] intArrays) {
        return true;
    }

    @Override
    protected boolean anyGeMin(int sId, long[] fixedData, int[][] intArrays) {
        assert (this.min != 0);
        return fixedData[this.mapId(sId)] >= (long)this.min;
    }

    @Override
    protected boolean anyLtMin(int sId, long[] fixedData, int[][] intArrays) {
        assert (this.min != 0);
        return this.min > 1;
    }

    @Override
    public String dumpState(int sId, long[] fixedData, int[][] intArrays) {
        return "TrivialAlwaysReEnter, current value: " + fixedData[this.mapId(sId)];
    }
}

