/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.TransitionOp;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTracker;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.BitSets;

public final class CounterTrackerLong2
extends CounterTracker {
    private final int min;
    private final int max;
    private final long maskLtMax0;
    private final long maskLtMax1;
    private final long maskGeMin0;
    private final long maskGeMin1;
    private final long maskLtMin0;
    private final long maskLtMin1;
    private final long saturateMinMask;
    private final int fixedOffset;

    public CounterTrackerLong2(int min, int max, int numberOfCells, CounterTrackerData.Builder dataBuilder) {
        this.min = min;
        this.max = max;
        this.maskLtMax0 = BitSets.getRangeChunk(0, 0, max - 2);
        this.maskLtMax1 = BitSets.getRangeChunk(1, 0, max - 2);
        this.maskGeMin0 = BitSets.getRangeChunk(0, min - 1, Math.max(min, max) - 1);
        this.maskGeMin1 = BitSets.getRangeChunk(1, min - 1, Math.max(min, max) - 1);
        this.maskLtMin0 = min > 1 ? BitSets.getRangeChunk(0, 0, min - 2) : 0L;
        this.maskLtMin1 = min > 1 ? BitSets.getRangeChunk(1, 0, min - 2) : 0L;
        this.fixedOffset = dataBuilder.getFixedDataSize();
        this.saturateMinMask = max == -1 ? 1L << min - 1 : 0L;
        dataBuilder.requestFixedSize(numberOfCells * 2);
    }

    @Override
    public void apply(long op, long[] data, int[][] intArrays) {
        CompilerAsserts.partialEvaluationConstant(op);
        int dst = this.mapId(TransitionOp.getTarget(op));
        int kind = TransitionOp.getKind(op);
        int modifier = TransitionOp.getModifier(op);
        if (kind == 2) {
            if (modifier == 1) {
                data[dst] = 1L;
                data[dst + 1] = 0L;
            } else {
                assert (modifier == 2);
                int n = dst;
                data[n] = data[n] | 1L;
            }
        } else {
            int src = this.mapId(TransitionOp.getSource(op));
            long bits0 = data[src];
            long bits1 = data[src + 1];
            switch (kind) {
                case 1: {
                    long shifted1Saturated;
                    long shifted0 = bits0 << 1;
                    long shifted1 = bits1 << 1 | bits0 >>> 63;
                    long shifted0Saturated = this.max == -1 && this.min <= 64 ? shifted0 | bits0 & this.saturateMinMask : shifted0;
                    long l = shifted1Saturated = this.max == -1 && this.min > 64 ? shifted1 | bits1 & this.saturateMinMask : shifted1;
                    if (modifier == 1) {
                        data[dst] = shifted0Saturated;
                        data[dst + 1] = shifted1Saturated;
                        break;
                    }
                    assert (modifier == 2);
                    int n = dst;
                    data[n] = data[n] | shifted0Saturated;
                    int n2 = dst + 1;
                    data[n2] = data[n2] | shifted1Saturated;
                    break;
                }
                case 0: {
                    if (modifier == 3) {
                        data[src] = data[dst];
                        data[src + 1] = data[dst + 1];
                        data[dst] = bits0;
                        data[dst + 1] = bits1;
                        break;
                    }
                    if (modifier == 1) {
                        data[dst] = bits0;
                        data[dst + 1] = bits1;
                        break;
                    }
                    int n = dst;
                    data[n] = data[n] | bits0;
                    int n3 = dst + 1;
                    data[n3] = data[n3] | bits1;
                }
            }
        }
    }

    @Override
    public void init(long[] fixedData, int[][] intArrays) {
    }

    @Override
    public boolean support(long operation) {
        return true;
    }

    private int mapId(int sId) {
        return this.fixedOffset + (sId << 1);
    }

    @Override
    protected boolean anyLtMax(int sId, long[] fixedData, int[][] intArrays) {
        if (this.max == -1) {
            return true;
        }
        return this.intersect(sId, fixedData, this.maskLtMax0, this.maskLtMax1);
    }

    @Override
    protected boolean anyGeMin(int sId, long[] fixedData, int[][] intArrays) {
        assert (this.min != 0);
        return this.intersect(sId, fixedData, this.maskGeMin0, this.maskGeMin1);
    }

    @Override
    protected boolean anyLtMin(int sId, long[] fixedData, int[][] intArrays) {
        assert (this.min != 0);
        return this.intersect(sId, fixedData, this.maskLtMin0, this.maskLtMin1);
    }

    private boolean intersect(int sId, long[] fixedData, long mask0, long mask1) {
        int mapId = this.mapId(sId);
        CompilerAsserts.partialEvaluationConstant(mapId);
        CompilerAsserts.partialEvaluationConstant(mask0);
        CompilerAsserts.partialEvaluationConstant(mask1);
        return (fixedData[mapId] & mask0 | fixedData[mapId + 1] & mask1) != 0L;
    }

    @Override
    public String dumpState(int sId, long[] fixedData, int[][] intArrays) {
        return "BitsetLong2, current value: " + Long.toBinaryString(fixedData[this.mapId(sId) + 1]) + Long.toBinaryString(fixedData[this.mapId(sId)]);
    }
}

