/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.dfa;

import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.CodePointSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.StateSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.StateTransitionCanonicalizer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.TransitionSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.dfa.DFACaptureGroupTransitionBuilder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.dfa.DFAGenerator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.dfa.DFAStateTransitionBuilder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFA;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFAState;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;

public final class DFATransitionCanonicalizer
extends StateTransitionCanonicalizer<NFA, NFAState, NFAStateTransition, DFAStateTransitionBuilder> {
    private final DFAGenerator dfaGen;

    public DFATransitionCanonicalizer(DFAGenerator dfaGen) {
        super(dfaGen.getNfa(), dfaGen.isForward(), dfaGen.isForward(), dfaGen.getOptions().isBooleanMatch());
        this.dfaGen = dfaGen;
    }

    @Override
    protected boolean canMerge(DFAStateTransitionBuilder a, DFAStateTransitionBuilder b) {
        TransitionSet tsA = a.getTransitionSet();
        TransitionSet tsB = b.getTransitionSet();
        long[] constraintsA = a.getConstraints();
        long[] constraintsB = b.getConstraints();
        long[] opA = a.getOperations();
        long[] opB = b.getOperations();
        if (!Arrays.equals(constraintsA, constraintsB) || !Arrays.equals(opA, opB)) {
            return false;
        }
        if (this.isPrioritySensitive()) {
            if (tsA.size() != tsB.size()) {
                return false;
            }
            for (int i = 0; i < tsA.size(); ++i) {
                NFAStateTransition tA = (NFAStateTransition)tsA.getTransition(i);
                NFAStateTransition tB = (NFAStateTransition)tsB.getTransition(i);
                if (!tA.getTarget().equals(tB.getTarget())) {
                    return false;
                }
                if (!this.dfaGen.isGenericCG() || tA.getSource().equals(tB.getSource()) && tA.getGroupBoundaries().equals(tB.getGroupBoundaries())) continue;
                return false;
            }
            return true;
        }
        return tsA.getTargetStateSet().equals(tsB.getTargetStateSet());
    }

    protected DFAStateTransitionBuilder createTransitionBuilder(NFAStateTransition[] transitions, StateSet<NFA, NFAState> targetStateSet, CodePointSet matcherBuilder, long[] constraints, long[] operations) {
        if (this.dfaGen.isGenericCG()) {
            return new DFACaptureGroupTransitionBuilder(transitions, targetStateSet, matcherBuilder, constraints, operations, this.dfaGen);
        }
        return new DFAStateTransitionBuilder(transitions, targetStateSet, matcherBuilder, constraints, operations);
    }

    protected NFAStateTransition[] createTransitionArray(int size) {
        return new NFAStateTransition[size];
    }

    protected DFAStateTransitionBuilder[] createResultArray(int size) {
        return new DFAStateTransitionBuilder[size];
    }
}

