/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.dfa;

import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.CodePointSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.AbstractTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.BasicState;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.TransitionSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.IntRangesBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.ObjectArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.dfa.DFAGenerator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.dfa.DFAStateTransitionBuilder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFA;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFAState;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupLazyTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.DebugUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.Json;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonValue;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.EmptyArrays;

public final class DFAStateNodeBuilder
extends BasicState<DFAStateNodeBuilder, DFAStateTransitionBuilder>
implements JsonConvertible {
    private static final short FLAG_OVERRIDE_FINAL_STATE = 64;
    private static final short FLAG_FINAL_STATE_SUCCESSOR = 128;
    private static final short FLAG_BACKWARD_PREFIX_STATE = 256;
    private static final short FLAG_FORWARD = 512;
    private static final short FLAG_PRIORITY_SENSITIVE = 1024;
    private static final short FLAG_REACHABLE = 2048;
    private static final DFAStateTransitionBuilder[] EMPTY_TRANSITIONS = new DFAStateTransitionBuilder[0];
    private TransitionSet<NFA, NFAState, NFAStateTransition> nfaTransitionSet;
    private short backwardPrefixState = (short)-1;
    private NFAStateTransition anchoredFinalStateTransition;
    private NFAStateTransition unAnchoredFinalStateTransition;
    private long[][] anchoredFinalConstraints = null;
    private long[][] unAnchoredFinalConstraints = null;
    private byte preCalculatedUnAnchoredResult = (byte)-1;
    private byte preCalculatedAnchoredResult = (byte)-1;
    private DFACaptureGroupLazyTransition[] lazyTransitions;

    DFAStateNodeBuilder(int id, TransitionSet<NFA, NFAState, NFAStateTransition> nfaStateSet, boolean isBackwardPrefixState, boolean isInitialState, boolean forward, boolean prioritySensitive) {
        super(id, (AbstractTransition[])EMPTY_TRANSITIONS);
        assert (id <= Short.MAX_VALUE);
        this.nfaTransitionSet = nfaStateSet;
        this.setFlag((short)256, isBackwardPrefixState);
        this.setFlag((short)512, forward);
        this.setFlag((short)1024, prioritySensitive);
        this.setUnAnchoredInitialState(isInitialState);
        if (isBackwardPrefixState) {
            this.backwardPrefixState = (short)id;
        }
    }

    public void setNfaTransitionSet(TransitionSet<NFA, NFAState, NFAStateTransition> nfaTransitionSet) {
        this.nfaTransitionSet = nfaTransitionSet;
    }

    public TransitionSet<NFA, NFAState, NFAStateTransition> getNfaTransitionSet() {
        return this.nfaTransitionSet;
    }

    public void setOverrideFinalState(boolean overrideFinalState) {
        this.setFlag((short)64, overrideFinalState);
    }

    public boolean isFinalStateSuccessor() {
        return this.getFlag((short)128);
    }

    public void setFinalStateSuccessor() {
        this.setFlag((short)128);
    }

    public boolean isBackwardPrefixState() {
        return this.getFlag((short)256);
    }

    public void setIsBackwardPrefixState(boolean backwardPrefixState) {
        this.setFlag((short)256, backwardPrefixState);
    }

    @Override
    public boolean isUnAnchoredFinalState() {
        return this.getFlag((short)72);
    }

    @Override
    public boolean isFinalState() {
        return this.getFlag((short)76);
    }

    public boolean isForward() {
        return this.getFlag((short)512);
    }

    public boolean isPrioritySensitive() {
        return this.getFlag((short)1024);
    }

    public void setReachable() {
        this.setFlag((short)2048);
    }

    public boolean isReachable() {
        return this.getFlag((short)2048);
    }

    public void setLazyTransitions(DFACaptureGroupLazyTransition[] lazyTransitions) {
        this.lazyTransitions = lazyTransitions;
    }

    public DFACaptureGroupLazyTransition[] getLazyTransitions() {
        return this.lazyTransitions;
    }

    protected DFAStateTransitionBuilder[] createTransitionsArray(int length) {
        return new DFAStateTransitionBuilder[length];
    }

    public boolean coversFullCharSpace(CompilationBuffer compilationBuffer) {
        IntRangesBuffer indicesBuf = compilationBuffer.getIntRangesBuffer1();
        indicesBuf.ensureCapacity(((DFAStateTransitionBuilder[])this.getSuccessors()).length);
        int[] indices = indicesBuf.getBuffer();
        Arrays.fill(indices, 0, ((DFAStateTransitionBuilder[])this.getSuccessors()).length, 0);
        int nextLo = compilationBuffer.getEncoding().getMinValue();
        int i;
        while ((i = this.findNextLo(indices, nextLo)) >= 0) {
            CodePointSet ranges = ((DFAStateTransitionBuilder[])this.getSuccessors())[i].getCodePointSet();
            if (ranges.getHi(indices[i]) == compilationBuffer.getEncoding().getMaxValue()) {
                return true;
            }
            nextLo = ranges.getHi(indices[i]) + 1;
            int n = i;
            indices[n] = indices[n] + 1;
        }
        return false;
    }

    private int findNextLo(int[] indices, int findLo) {
        for (int i = 0; i < ((DFAStateTransitionBuilder[])this.getSuccessors()).length; ++i) {
            CodePointSet ranges = ((DFAStateTransitionBuilder[])this.getSuccessors())[i].getCodePointSet();
            if (indices[i] == ranges.size() || ranges.getLo(indices[i]) != findLo) continue;
            return i;
        }
        return -1;
    }

    public boolean hasBackwardPrefixState() {
        return this.backwardPrefixState >= 0;
    }

    public short getBackwardPrefixState() {
        return this.backwardPrefixState;
    }

    public void setBackwardPrefixState(short backwardPrefixState) {
        this.backwardPrefixState = backwardPrefixState;
    }

    public void setAnchoredFinalStateTransition(NFAStateTransition anchoredFinalStateTransition) {
        this.anchoredFinalStateTransition = anchoredFinalStateTransition;
    }

    public NFAStateTransition getAnchoredFinalStateTransition() {
        return this.anchoredFinalStateTransition;
    }

    public void setUnAnchoredFinalStateTransition(NFAStateTransition unAnchoredFinalStateTransition) {
        this.unAnchoredFinalStateTransition = unAnchoredFinalStateTransition;
    }

    public NFAStateTransition getUnAnchoredFinalStateTransition() {
        return this.unAnchoredFinalStateTransition;
    }

    public byte getPreCalculatedUnAnchoredResult() {
        return this.preCalculatedUnAnchoredResult;
    }

    public byte getPreCalculatedAnchoredResult() {
        return this.preCalculatedAnchoredResult;
    }

    void updatePreCalcUnAnchoredResult(int newResult) {
        if (newResult >= 0 && (this.preCalculatedUnAnchoredResult == -1 || Byte.toUnsignedInt(this.preCalculatedUnAnchoredResult) > newResult)) {
            this.preCalculatedUnAnchoredResult = (byte)newResult;
        }
    }

    private void updatePreCalcAnchoredResult(int newResult) {
        if (newResult >= 0 && (this.preCalculatedAnchoredResult == -1 || Byte.toUnsignedInt(this.preCalculatedAnchoredResult) > newResult)) {
            this.preCalculatedAnchoredResult = (byte)newResult;
        }
    }

    public void clearPreCalculatedResults() {
        this.preCalculatedUnAnchoredResult = (byte)-1;
        this.preCalculatedAnchoredResult = (byte)-1;
    }

    public DFAStateNodeBuilder updateFinalStateData(DFAGenerator dfaGenerator) {
        boolean forward = dfaGenerator.isForward();
        boolean traceFinder = dfaGenerator.getNfa().isTraceFinderNFA();
        if (forward) {
            for (NFAStateTransition t : (NFAStateTransition[])this.nfaTransitionSet.getTransitions()) {
                NFAState target = (NFAState)t.getTarget(true);
                if (target.hasUnGuardedTransitionToAnchoredFinalState(true) && this.anchoredFinalStateTransition == null) {
                    this.setGuardedAnchoredFinalState(false);
                    this.setAnchoredFinalState();
                    this.setAnchoredFinalStateTransition(target.getFirstTransitionToFinalState(true));
                } else if (target.hasGuardedTransitionToAnchoredFinalState() && !this.isFinalState()) {
                    this.setGuardedAnchoredFinalState(true);
                }
                if (target.hasUnGuardedTransitionToUnAnchoredFinalState(true)) {
                    this.setGuardedUnAnchoredFinalState(false);
                    this.setGuardedAnchoredFinalState(false);
                    this.setUnAnchoredFinalState();
                    this.setUnAnchoredFinalStateTransition(target.getTransitionToUnAnchoredFinalState(true));
                    return this;
                }
                if (!target.hasGuardedTransitionToUnAnchoredFinalState() || this.isUnAnchoredFinalState()) continue;
                this.setGuardedUnAnchoredFinalState(true);
            }
        } else {
            for (NFAStateTransition t : (NFAStateTransition[])this.nfaTransitionSet.getTransitions()) {
                NFAState target = (NFAState)t.getTarget(false);
                if (target.isAnchoredFinalState(false) && (!traceFinder || !this.isBackwardPrefixState() || target.hasPrefixStates())) {
                    if (traceFinder) {
                        assert (target.hasPossibleResults() && target.getPossibleResults().numberOfSetBits() == 1);
                        this.updatePreCalcAnchoredResult(target.getPossibleResults().iterator().nextInt());
                    }
                    this.setAnchoredFinalState();
                    this.setAnchoredFinalStateTransition(t);
                }
                if (!target.isUnAnchoredFinalState(false) || traceFinder && this.isBackwardPrefixState() && !target.hasPrefixStates()) continue;
                if (traceFinder) {
                    assert (target.hasPossibleResults() && target.getPossibleResults().numberOfSetBits() == 1);
                    this.updatePreCalcUnAnchoredResult(target.getPossibleResults().iterator().nextInt());
                }
                this.setUnAnchoredFinalState();
                this.setUnAnchoredFinalStateTransition(t);
            }
        }
        return this;
    }

    private void computeAnchoredFinalConstraints() {
        ObjectArrayBuffer buf = new ObjectArrayBuffer();
        for (NFAStateTransition t : (NFAStateTransition[])this.nfaTransitionSet.getTransitions()) {
            NFAState target = t.getTarget();
            if (!target.hasGuardedTransitionToAnchoredFinalState()) continue;
            buf.addAll((Object[])target.getAnchoredFinalTransitionConstraints());
        }
        this.anchoredFinalConstraints = (long[][])buf.toArray(x$0 -> new long[x$0][]);
    }

    private void computeUnAnchoredFinalConstraints() {
        ObjectArrayBuffer buf = new ObjectArrayBuffer();
        for (NFAStateTransition t : (NFAStateTransition[])this.nfaTransitionSet.getTransitions()) {
            NFAState target = t.getTarget();
            if (!target.hasGuardedTransitionToUnAnchoredFinalState()) continue;
            buf.addAll((Object[])target.getUnAnchoredFinalTransitionConstraints());
        }
        this.unAnchoredFinalConstraints = (long[][])buf.toArray(x$0 -> new long[x$0][]);
    }

    public long[][] getAnchoredFinalConstraints() {
        if (!this.isGuardedAnchoredFinalState()) {
            return EmptyArrays.LONG_2D;
        }
        if (this.anchoredFinalConstraints == null) {
            this.computeAnchoredFinalConstraints();
        }
        return this.anchoredFinalConstraints;
    }

    public long[][] getUnAnchoredFinalConstraints() {
        if (!this.isGuardedUnAnchoredFinalState()) {
            return EmptyArrays.LONG_2D;
        }
        if (this.unAnchoredFinalConstraints == null) {
            this.computeUnAnchoredFinalConstraints();
        }
        return this.unAnchoredFinalConstraints;
    }

    public String stateSetToString() {
        StringBuilder sb = new StringBuilder(this.nfaTransitionSet.toString());
        if (this.preCalculatedUnAnchoredResult != -1) {
            sb.append("_r").append(this.preCalculatedUnAnchoredResult);
        }
        if (this.preCalculatedAnchoredResult != -1) {
            sb.append("_rA").append(this.preCalculatedAnchoredResult);
        }
        return sb.toString();
    }

    public int hashCode() {
        int hashCode;
        if (this.isPrioritySensitive()) {
            hashCode = 1;
            for (int i = 0; i < this.nfaTransitionSet.size(); ++i) {
                hashCode = 31 * hashCode + this.nfaTransitionSet.getTransition(i).getTarget().hashCode();
            }
        } else {
            hashCode = this.nfaTransitionSet.getTargetStateSet().hashCode();
        }
        if (this.isBackwardPrefixState()) {
            hashCode *= 31;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DFAStateNodeBuilder)) {
            return false;
        }
        DFAStateNodeBuilder o = (DFAStateNodeBuilder)obj;
        if (this.isBackwardPrefixState() != o.isBackwardPrefixState()) {
            return false;
        }
        if (this.isPrioritySensitive()) {
            if (this.nfaTransitionSet.size() != o.nfaTransitionSet.size()) {
                return false;
            }
            for (int i = 0; i < this.nfaTransitionSet.size(); ++i) {
                if (((NFAState)this.nfaTransitionSet.getTransition(i).getTarget(this.isForward())).equals(o.nfaTransitionSet.getTransition(i).getTarget())) continue;
                return false;
            }
            return true;
        }
        return this.nfaTransitionSet.getTargetStateSet().equals(o.nfaTransitionSet.getTargetStateSet());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected boolean hasUnGuardedTransitionToUnAnchoredFinalState(boolean forward) {
        throw new UnsupportedOperationException();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return DebugUtil.appendNodeId(sb, this.getId()).append(": ").append(this.stateSetToString()).toString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("id", this.getId()), Json.prop("stateSet", Json.array(Arrays.stream((NFAStateTransition[])this.nfaTransitionSet.getTransitions()).map(x -> Json.val(((NFAState)x.getTarget(this.isForward())).getId())))), Json.prop("finalState", this.isUnAnchoredFinalState()), Json.prop("anchoredFinalState", this.isAnchoredFinalState()), Json.prop("transitions", Arrays.stream((DFAStateTransitionBuilder[])this.getSuccessors()).map(x -> Json.val(x.getId()))));
    }
}

