/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.ProvidedTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.StandardTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.UnsupportedRegexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.analysis.InputStringGenerator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.TRegexCompiler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexFlavor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexParser;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexValidator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.Encodings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TruffleNull;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptors;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.SandboxPolicy;

@TruffleLanguage.Registration(name="REGEX", id="regex", characterMimeTypes={"application/tregex"}, version="0.1", contextPolicy=TruffleLanguage.ContextPolicy.SHARED, internal=true, interactive=false, sandbox=SandboxPolicy.UNTRUSTED, website="https://github.com/oracle/graal/tree/master/regex")
@ProvidedTags(value={StandardTags.RootTag.class})
public final class RegexLanguage
extends TruffleLanguage<RegexContext> {
    public static final String NAME = "REGEX";
    public static final String ID = "regex";
    public static final String MIME_TYPE = "application/tregex";
    private final GroupBoundaries[] cachedGroupBoundaries = GroupBoundaries.createCachedGroupBoundaries();
    private static final TruffleLanguage.LanguageReference<RegexLanguage> REFERENCE = TruffleLanguage.LanguageReference.create(RegexLanguage.class);

    public GroupBoundaries[] getCachedGroupBoundaries() {
        return this.cachedGroupBoundaries;
    }

    @Override
    protected CallTarget parse(TruffleLanguage.ParsingRequest parsingRequest) {
        RegexSource source = RegexLanguage.createRegexSource(parsingRequest);
        if (source.getOptions().isGenerateInput()) {
            RegexFlavor flavor = source.getOptions().getFlavor();
            RegexParser parser = flavor.createParser(this, source, new CompilationBuffer(source.getEncoding()));
            return InputStringGenerator.generateRootNode(this, parser.parse()).getCallTarget();
        }
        return RootNode.createConstantNode(this.createRegexObject(source)).getCallTarget();
    }

    private static RegexSource createRegexSource(TruffleLanguage.ParsingRequest parsingRequest) {
        Source source = parsingRequest.getSource();
        String srcStr = source.getCharacters().toString();
        if (srcStr.length() < 2) {
            throw CompilerDirectives.shouldNotReachHere("malformed regex");
        }
        RegexOptions.Builder optBuilder = RegexOptions.builder(parsingRequest);
        int firstSlash = optBuilder.parseOptions();
        int lastSlash = srcStr.lastIndexOf(47);
        assert (firstSlash >= 0 && firstSlash <= srcStr.length());
        if (lastSlash <= firstSlash) {
            throw CompilerDirectives.shouldNotReachHere("malformed regex");
        }
        String pattern = srcStr.substring(firstSlash + 1, lastSlash);
        String flags = srcStr.substring(lastSlash + 1);
        if (optBuilder.getFlavor().getName().equals("ECMAScript")) {
            if (flags.indexOf(117) >= 0 || flags.indexOf(118) >= 0) {
                if (!optBuilder.isUtf16ExplodeAstralSymbols() && optBuilder.getEncoding() == Encodings.UTF_16_RAW) {
                    optBuilder.encoding(Encodings.UTF_16);
                }
            } else if (optBuilder.getEncoding() == Encodings.UTF_16) {
                optBuilder.encoding(Encodings.UTF_16_RAW);
            }
        }
        return new RegexSource(pattern, flags, optBuilder.build(), source);
    }

    private Object createRegexObject(RegexSource source) {
        if (source.getOptions().isValidate()) {
            RegexFlavor flavor = source.getOptions().getFlavor();
            RegexValidator validator = flavor.createValidator(this, source, new CompilationBuffer(source.getEncoding()));
            validator.validate();
            return TruffleNull.INSTANCE;
        }
        try {
            return TRegexCompiler.compile(this, source);
        }
        catch (UnsupportedRegexException e) {
            return TruffleNull.INSTANCE;
        }
    }

    @Override
    protected OptionDescriptors getSourceOptionDescriptors() {
        return RegexOptions.getDescriptors();
    }

    @Override
    protected RegexContext createContext(TruffleLanguage.Env env) {
        return new RegexContext(env);
    }

    @Override
    protected boolean patchContext(RegexContext context, TruffleLanguage.Env newEnv) {
        context.patchContext(newEnv);
        return true;
    }

    @Override
    protected Object getScope(RegexContext context) {
        return null;
    }

    public static RegexLanguage get(Node node) {
        return REFERENCE.get(node);
    }

    @Override
    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    public static final class RegexContext {
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.Env env;
        private static final TruffleLanguage.ContextReference<RegexContext> REFERENCE = TruffleLanguage.ContextReference.create(RegexLanguage.class);

        RegexContext(TruffleLanguage.Env env) {
            this.env = env;
        }

        void patchContext(TruffleLanguage.Env patchedEnv) {
            this.env = patchedEnv;
        }

        public TruffleLanguage.Env getEnv() {
            return this.env;
        }

        public static RegexContext get(Node node) {
            return REFERENCE.get(node);
        }
    }
}

