/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexBodyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.result.RegexResult;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.runtime.nodes.ExpectStringNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.runtime.nodes.ToLongNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.input.InputOps;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.input.InputReadNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.Encodings;

public abstract class RegexExecNode
extends RegexBodyNode {
    private final boolean mustCheckUTF16Surrogates;
    @Node.Child
    private ExpectStringNode expectStringNode = ExpectStringNode.create();
    @Node.Child
    private ToLongNode toLongNode = ToLongNode.create();
    @Node.Child
    private InputReadNode charAtNode;

    public RegexExecNode(RegexLanguage language, RegexSource source, boolean mustCheckUTF16Surrogates) {
        super(language, source);
        this.mustCheckUTF16Surrogates = this.getEncoding() == Encodings.UTF_16 && mustCheckUTF16Surrogates;
    }

    @Override
    public final RegexResult execute(VirtualFrame frame) {
        int regionTo;
        int regionFrom;
        int toIndex;
        Object[] args = frame.getArguments();
        TruffleString.Encoding encoding = this.getEncoding().getTStringEncoding();
        CompilerAsserts.partialEvaluationConstant((Object)encoding);
        TruffleString input = this.expectStringNode.execute(args[0], encoding);
        int length = InputOps.length(input, this.getEncoding());
        long fromIndex = this.toLongNode.execute(args[1]);
        if (fromIndex > Integer.MAX_VALUE) {
            return RegexResult.getNoMatchInstance();
        }
        if (args.length == 5) {
            long toIndexLong = this.toLongNode.execute(args[2]);
            long regionFromLong = this.toLongNode.execute(args[3]);
            long regionToLong = this.toLongNode.execute(args[4]);
            if (regionFromLong < 0L || regionFromLong > (long)length) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException(String.format("got illegal regionFrom value: %d. regionFrom must be >= 0 and <= input length (%d)", regionFromLong, length));
            }
            if (regionToLong < regionFromLong || regionToLong > (long)length) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException(String.format("got illegal regionTo value: %d. regionTo must be >= regionFrom (%d) and <= input length (%d)", regionToLong, regionFromLong, length));
            }
            if (fromIndex < regionFromLong || fromIndex > regionToLong) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException(String.format("got illegal fromIndex value: %d. fromIndex must be >= regionFrom (%d) and <= regionTo (%d)", fromIndex, regionFromLong, regionToLong));
            }
            if (toIndexLong < fromIndex || toIndexLong > regionToLong) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException(String.format("got illegal toIndex value: %d. toIndex must be >= fromIndex (%d) and <= regionTo (%d)", toIndexLong, fromIndex, regionToLong));
            }
            if (toIndexLong != regionToLong) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedOperationException(String.format("got non-equal toIndex (%d) and regionTo (%d), support for this is not implemented yet", toIndexLong, regionToLong));
            }
            toIndex = (int)toIndexLong;
            regionFrom = (int)regionFromLong;
            regionTo = (int)regionToLong;
        } else {
            assert (args.length == 2);
            toIndex = length;
            regionFrom = 0;
            regionTo = length;
            if (fromIndex < 0L || fromIndex > (long)length) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException(String.format("got illegal fromIndex value: %d. fromIndex must be >= 0 and <= input length (%d)", fromIndex, length));
            }
        }
        return this.execute(frame, input, this.adjustFromIndex(input, (int)fromIndex, regionFrom, regionTo), toIndex, regionFrom, regionTo);
    }

    private int adjustFromIndex(TruffleString input, int fromIndex, int regionFrom, int regionTo) {
        if (this.mustCheckUTF16Surrogates && fromIndex > regionFrom && fromIndex < regionTo) {
            assert (this.getEncoding() == Encodings.UTF_16);
            if (Character.isLowSurrogate((char)this.inputRead(input, fromIndex)) && Character.isHighSurrogate((char)this.inputRead(input, fromIndex - 1))) {
                return fromIndex - 1;
            }
        }
        return fromIndex;
    }

    public final int inputRead(TruffleString input, int i) {
        if (this.charAtNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.charAtNode = this.insert(InputReadNode.create());
        }
        return this.charAtNode.execute(this, input, i, this.getEncoding());
    }

    public boolean isBacktracking() {
        return false;
    }

    public boolean isNFA() {
        return false;
    }

    protected abstract RegexResult execute(VirtualFrame var1, TruffleString var2, int var3, int var4, int var5, int var6);
}

