/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util;

import java.util.HashMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;

public final class JSHashMap {
    private final HashMap<Object, Node> map = new HashMap();
    private final Node head;
    private Node tail;

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public JSHashMap() {
        Node dummy;
        this.head = dummy = new Node(null, null, null, null);
        this.tail = dummy;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public int size() {
        return this.map.size();
    }

    @CompilerDirectives.TruffleBoundary
    public void put(Object key, Object value) {
        Node newNode = new Node(key, value, null, null);
        Node oldNode = this.map.putIfAbsent(key, newNode);
        if (oldNode == null) {
            newNode.setPrev(this.tail);
            this.tail.setNext(newNode);
            this.tail = newNode;
        } else {
            oldNode.setValue(value);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object getOrInsert(Object key, Object value) {
        Node newNode = new Node(key, value, null, null);
        Node oldNode = this.map.putIfAbsent(key, newNode);
        if (oldNode == null) {
            newNode.setPrev(this.tail);
            this.tail.setNext(newNode);
            this.tail = newNode;
            return value;
        }
        return oldNode.getValue();
    }

    @CompilerDirectives.TruffleBoundary
    public Object get(Object key) {
        Node node = this.map.get(key);
        return node == null ? null : node.getValue();
    }

    @CompilerDirectives.TruffleBoundary
    public boolean has(Object key) {
        return this.map.containsKey(key);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean remove(Object key) {
        Node node = this.map.remove(key);
        if (node == null) {
            return false;
        }
        this.unlink(node);
        return true;
    }

    private void unlink(Node node) {
        Node next = node.getNext();
        Node prev = node.getPrev();
        prev.setNext(next);
        if (next != null) {
            next.setPrev(prev);
        } else {
            this.tail = prev;
        }
        node.setEmpty();
    }

    @CompilerDirectives.TruffleBoundary
    public void clear() {
        this.map.clear();
        for (Node current = this.head.getNext(); current != null; current = current.getNext()) {
            current.setEmpty();
        }
        this.head.setNext(null);
        this.tail = this.head;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.map.toString();
    }

    public Cursor getEntries() {
        return new CursorImpl(this.head);
    }

    @CompilerDirectives.TruffleBoundary
    public JSHashMap copy() {
        JSHashMap result = new JSHashMap();
        Cursor cursor = this.getEntries();
        while (cursor.advance()) {
            result.put(cursor.getKey(), cursor.getValue());
        }
        return result;
    }

    private static final class Node {
        private Object key;
        private Object value;
        private Node prev;
        private Node next;

        Node(Object key, Object value, Node prev, Node next) {
            this.key = key;
            this.value = value;
            this.prev = prev;
            this.next = next;
        }

        Object getKey() {
            return this.key;
        }

        Object getValue() {
            return this.value;
        }

        void setValue(Object value) {
            this.value = value;
        }

        Node getPrev() {
            return this.prev;
        }

        void setPrev(Node prev) {
            this.prev = prev;
        }

        Node getNext() {
            return this.next;
        }

        void setNext(Node next) {
            this.next = next;
        }

        void setEmpty() {
            this.key = null;
            this.value = null;
        }

        boolean isEmpty() {
            return this.key == null;
        }

        public String toString() {
            return "Node [key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + "]";
        }
    }

    private static final class CursorImpl
    implements Cursor {
        private Node current;

        CursorImpl(Node head) {
            this.current = head;
        }

        @Override
        public boolean advance() {
            if (this.current == null) {
                return false;
            }
            while (this.current.isEmpty() && this.current.getPrev() != null) {
                this.current = this.current.getPrev();
            }
            Node next = this.current.getNext();
            assert (next == null || next.getKey() != null);
            this.current = next;
            return next != null;
        }

        @Override
        public boolean shouldAdvance() {
            return this.current != null && this.current.isEmpty();
        }

        @Override
        public Object getKey() {
            Object key = this.current.getKey();
            assert (key != null);
            return key;
        }

        @Override
        public Object getValue() {
            Object value = this.current.getValue();
            assert (value != null);
            return value;
        }

        public String toString() {
            return "Cursor [current=" + String.valueOf(this.current) + "]";
        }

        @Override
        public Cursor copy() {
            return new CursorImpl(this.current);
        }
    }

    public static interface Cursor {
        public boolean advance();

        public boolean shouldAdvance();

        public Object getKey();

        public Object getValue();

        public Cursor copy();
    }
}

