/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util;

import java.time.ZoneId;
import java.time.zone.ZoneRulesProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.LazyValue;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.UTS35Validator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.ZoneRulesBasedTimeZone;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.CaseMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.Collator;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.CurrencyMetaInfo;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.DateFormat;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.NumberingSystem;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.Calendar;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.ChineseCalendar;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.GregorianCalendar;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.HebrewCalendar;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.IndianCalendar;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.IslamicCalendar;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.JapaneseCalendar;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.PersianCalendar;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.TimeZone;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.ULocale;

public final class IntlUtil {
    public static final String _2_DIGIT = "2-digit";
    public static final String ACCENT = "accent";
    public static final String ACCOUNTING = "accounting";
    public static final String ALWAYS = "always";
    public static final String AUTO = "auto";
    public static final String BEST_FIT = "best fit";
    public static final String BASE = "base";
    public static final String BASIC = "basic";
    public static final String CALENDAR = "calendar";
    public static final String CARDINAL = "cardinal";
    public static final String CASE = "case";
    public static final String CASE_FIRST = "caseFirst";
    public static final String CEIL = "ceil";
    public static final String CODE = "code";
    public static final String COLLATION = "collation";
    public static final String COMPACT = "compact";
    public static final String COMPACT_DISPLAY = "compactDisplay";
    public static final String CONJUNCTION = "conjunction";
    public static final String CURRENCY = "currency";
    public static final String CURRENCY_DISPLAY = "currencyDisplay";
    public static final String CURRENCY_SIGN = "currencySign";
    public static final String DATE_STYLE = "dateStyle";
    public static final String DATE_TIME_FIELD = "dateTimeField";
    public static final String DAY = "day";
    public static final String DAYS = "days";
    public static final String DAYS_DISPLAY = "daysDisplay";
    public static final String DAY_PERIOD = "dayPeriod";
    public static final String DEFAULT = "default";
    public static final String DECIMAL = "decimal";
    public static final String DIALECT = "dialect";
    public static final String DIGITAL = "digital";
    public static final String DIRECTION = "direction";
    public static final String DISJUNCTION = "disjunction";
    public static final String ELEMENT = "element";
    public static final String END_RANGE = "endRange";
    public static final String ENGINEERING = "engineering";
    public static final String ERA = "era";
    public static final String EXCEPT_ZERO = "exceptZero";
    public static final String EXPAND = "expand";
    public static final String FALLBACK = "fallback";
    public static final String FALSE = "false";
    public static final String FIRST_DAY = "firstDay";
    public static final String FIRST_DAY_OF_WEEK = "firstDayOfWeek";
    public static final String FLOOR = "floor";
    public static final String FORMAT_MATCHER = "formatMatcher";
    public static final String FRACTIONAL = "fractional";
    public static final String FRACTIONAL_DIGITS = "fractionalDigits";
    public static final String FRACTIONAL_SECOND_DIGITS = "fractionalSecondDigits";
    public static final String FRACTION_DIGITS = "fractionDigits";
    public static final String FULL = "full";
    public static final String GRANULARITY = "granularity";
    public static final String GRAPHEME = "grapheme";
    public static final String H11 = "h11";
    public static final String H12 = "h12";
    public static final String H23 = "h23";
    public static final String H24 = "h24";
    public static final String HALF_CEIL = "halfCeil";
    public static final String HALF_EVEN = "halfEven";
    public static final String HALF_EXPAND = "halfExpand";
    public static final String HALF_FLOOR = "halfFloor";
    public static final String HALF_TRUNC = "halfTrunc";
    public static final String HOUR = "hour";
    public static final String HOURS = "hours";
    public static final String HOURS_DISPLAY = "hoursDisplay";
    public static final String HOUR_CYCLE = "hourCycle";
    public static final String HOUR12 = "hour12";
    public static final String INDEX = "index";
    public static final String INFINITY = "infinity";
    public static final String INPUT = "input";
    public static final String INTEGER = "integer";
    public static final String IS_WORD_LIKE = "isWordLike";
    public static final String IGNORE_PUNCTUATION = "ignorePunctuation";
    public static final String LANGUAGE = "language";
    public static final String LANGUAGE_DISPLAY = "languageDisplay";
    public static final String LESS_PRECISION = "lessPrecision";
    public static final String LITERAL = "literal";
    public static final String LOCALE = "locale";
    public static final String LOCALE_MATCHER = "localeMatcher";
    public static final String LONG = "long";
    public static final String LONG_GENERIC = "longGeneric";
    public static final String LONG_OFFSET = "longOffset";
    public static final String LOOKUP = "lookup";
    public static final String LOWER = "lower";
    public static final String LTR = "ltr";
    public static final String MAXIMUM_FRACTION_DIGITS = "maximumFractionDigits";
    public static final String MAXIMUM_SIGNIFICANT_DIGITS = "maximumSignificantDigits";
    public static final String MEDIUM = "medium";
    public static final String MICROSECONDS = "microseconds";
    public static final String MICROSECONDS_DISPLAY = "microsecondsDisplay";
    public static final String MILLISECONDS = "milliseconds";
    public static final String MILLISECONDS_DISPLAY = "millisecondsDisplay";
    public static final String MIN2 = "min2";
    public static final String MINIMAL_DAYS = "minimalDays";
    public static final String MINIMUM_FRACTION_DIGITS = "minimumFractionDigits";
    public static final String MINIMUM_INTEGER_DIGITS = "minimumIntegerDigits";
    public static final String MINIMUM_SIGNIFICANT_DIGITS = "minimumSignificantDigits";
    public static final String MINUS_SIGN = "minusSign";
    public static final String MINUTE = "minute";
    public static final String MINUTES = "minutes";
    public static final String MINUTES_DISPLAY = "minutesDisplay";
    public static final String MONTH = "month";
    public static final String MONTHS = "months";
    public static final String MONTHS_DISPLAY = "monthsDisplay";
    public static final String MORE_PRECISION = "morePrecision";
    public static final String NAME = "name";
    public static final String NANOSECONDS = "nanoseconds";
    public static final String NANOSECONDS_DISPLAY = "nanosecondsDisplay";
    public static final String NARROW = "narrow";
    public static final String NARROW_SYMBOL = "narrowSymbol";
    public static final String NEGATIVE = "negative";
    public static final String NEVER = "never";
    public static final String NEXT = "next";
    public static final String NONE = "none";
    public static final String NOTATION = "notation";
    public static final String NUMERIC = "numeric";
    public static final String NUMBERING_SYSTEM = "numberingSystem";
    public static final String ORDINAL = "ordinal";
    public static final String PERCENT = "percent";
    public static final String PREVIOUS = "previous";
    public static final String PLURAL_CATEGORIES = "pluralCategories";
    public static final String PLUS_SIGN = "plusSign";
    public static final String QUARTER = "quarter";
    public static final String REGION = "region";
    public static final String ROUNDING_INCREMENT = "roundingIncrement";
    public static final String ROUNDING_MODE = "roundingMode";
    public static final String ROUNDING_PRIORITY = "roundingPriority";
    public static final String RTL = "rtl";
    public static final String SCIENTIFIC = "scientific";
    public static final String SCRIPT = "script";
    public static final String SEARCH = "search";
    public static final String SECOND = "second";
    public static final String SECONDS = "seconds";
    public static final String SECONDS_DISPLAY = "secondsDisplay";
    public static final String SEGMENT = "segment";
    public static final String SENTENCE = "sentence";
    public static final String SENSITIVITY = "sensitivity";
    public static final String SHARED = "shared";
    public static final String SHORT = "short";
    public static final String SHORT_GENERIC = "shortGeneric";
    public static final String SHORT_OFFSET = "shortOffset";
    public static final String SIGNIFICANT_DIGITS = "significantDigits";
    public static final String SIGN_DISPLAY = "signDisplay";
    public static final String SORT = "sort";
    public static final String SOURCE = "source";
    public static final String STANDARD = "standard";
    public static final String START_RANGE = "startRange";
    public static final String STRICT = "strict";
    public static final String STRIP_IF_INTEGER = "stripIfInteger";
    public static final String STYLE = "style";
    public static final String SYMBOL = "symbol";
    public static final String TIME_STYLE = "timeStyle";
    public static final String TIME_ZONE = "timeZone";
    public static final String TIME_ZONE_NAME = "timeZoneName";
    public static final String TRAILING_ZERO_DISPLAY = "trailingZeroDisplay";
    public static final String TRUNC = "trunc";
    public static final String TYPE = "type";
    public static final String UND = "und";
    public static final String UNIT = "unit";
    public static final String UNIT_DISPLAY = "unitDisplay";
    public static final String UPPER = "upper";
    public static final String USAGE = "usage";
    public static final String USE_GROUPING = "useGrouping";
    public static final String VALUE = "value";
    public static final String VARIANT = "variant";
    public static final String VARIANTS = "variants";
    public static final String WORD = "word";
    public static final String WEEKDAY = "weekday";
    public static final String WEEKEND = "weekend";
    public static final String WEEKS = "weeks";
    public static final String WEEKS_DISPLAY = "weeksDisplay";
    public static final String WEEK_OF_YEAR = "weekOfYear";
    public static final String YEAR = "year";
    public static final String YEARS = "years";
    public static final String YEARS_DISPLAY = "yearsDisplay";
    public static final String YEAR_NAME = "yearName";
    public static final TruffleString KEY_CALENDAR = Strings.CALENDAR;
    public static final TruffleString KEY_CASE_FIRST = Strings.constant("caseFirst");
    public static final TruffleString KEY_COLLATION = Strings.constant("collation");
    public static final TruffleString KEY_COMPACT_DISPLAY = Strings.constant("compactDisplay");
    public static final TruffleString KEY_CURRENCY = Strings.constant("currency");
    public static final TruffleString KEY_CURRENCY_DISPLAY = Strings.constant("currencyDisplay");
    public static final TruffleString KEY_CURRENCY_SIGN = Strings.constant("currencySign");
    public static final TruffleString KEY_DATE_STYLE = Strings.constant("dateStyle");
    public static final TruffleString KEY_DAY = Strings.DAY;
    public static final TruffleString KEY_DAYS = Strings.constant("days");
    public static final TruffleString KEY_DAYS_DISPLAY = Strings.constant("daysDisplay");
    public static final TruffleString KEY_DAY_PERIOD = Strings.constant("dayPeriod");
    public static final TruffleString KEY_DIRECTION = Strings.constant("direction");
    public static final TruffleString KEY_ERA = Strings.ERA;
    public static final TruffleString KEY_FALLBACK = Strings.constant("fallback");
    public static final TruffleString KEY_FIRST_DAY = Strings.constant("firstDay");
    public static final TruffleString KEY_FIRST_DAY_OF_WEEK = Strings.constant("firstDayOfWeek");
    public static final TruffleString KEY_FORMAT_MATCHER = Strings.constant("formatMatcher");
    public static final TruffleString KEY_FRACTIONAL_DIGITS = Strings.constant("fractionalDigits");
    public static final TruffleString KEY_FRACTIONAL_SECOND_DIGITS = Strings.FRACTIONAL_SECOND_DIGITS;
    public static final TruffleString KEY_GRANULARITY = Strings.constant("granularity");
    public static final TruffleString KEY_HOUR = Strings.HOUR;
    public static final TruffleString KEY_HOURS = Strings.constant("hours");
    public static final TruffleString KEY_HOURS_DISPLAY = Strings.constant("hoursDisplay");
    public static final TruffleString KEY_HOUR_CYCLE = Strings.constant("hourCycle");
    public static final TruffleString KEY_HOUR12 = Strings.constant("hour12");
    public static final TruffleString KEY_INDEX = Strings.INDEX;
    public static final TruffleString KEY_INPUT = Strings.INPUT;
    public static final TruffleString KEY_IS_WORD_LIKE = Strings.constant("isWordLike");
    public static final TruffleString KEY_IGNORE_PUNCTUATION = Strings.constant("ignorePunctuation");
    public static final TruffleString KEY_LANGUAGE = Strings.LANGUAGE;
    public static final TruffleString KEY_LANGUAGE_DISPLAY = Strings.constant("languageDisplay");
    public static final TruffleString KEY_LOCALE = Strings.constant("locale");
    public static final TruffleString KEY_LOCALE_MATCHER = Strings.constant("localeMatcher");
    public static final TruffleString KEY_LTR = Strings.constant("ltr");
    public static final TruffleString KEY_MAXIMUM_FRACTION_DIGITS = Strings.constant("maximumFractionDigits");
    public static final TruffleString KEY_MAXIMUM_SIGNIFICANT_DIGITS = Strings.constant("maximumSignificantDigits");
    public static final TruffleString KEY_MICROSECONDS = Strings.constant("microseconds");
    public static final TruffleString KEY_MICROSECONDS_DISPLAY = Strings.constant("microsecondsDisplay");
    public static final TruffleString KEY_MILLISECONDS = Strings.constant("milliseconds");
    public static final TruffleString KEY_MILLISECONDS_DISPLAY = Strings.constant("millisecondsDisplay");
    public static final TruffleString KEY_MINIMAL_DAYS = Strings.constant("minimalDays");
    public static final TruffleString KEY_MINIMUM_FRACTION_DIGITS = Strings.constant("minimumFractionDigits");
    public static final TruffleString KEY_MINIMUM_INTEGER_DIGITS = Strings.constant("minimumIntegerDigits");
    public static final TruffleString KEY_MINIMUM_SIGNIFICANT_DIGITS = Strings.constant("minimumSignificantDigits");
    public static final TruffleString KEY_MINUTE = Strings.MINUTE;
    public static final TruffleString KEY_MINUTES = Strings.constant("minutes");
    public static final TruffleString KEY_MINUTES_DISPLAY = Strings.constant("minutesDisplay");
    public static final TruffleString KEY_MONTH = Strings.MONTH;
    public static final TruffleString KEY_MONTHS = Strings.constant("months");
    public static final TruffleString KEY_MONTHS_DISPLAY = Strings.constant("monthsDisplay");
    public static final TruffleString KEY_NANOSECONDS = Strings.constant("nanoseconds");
    public static final TruffleString KEY_NANOSECONDS_DISPLAY = Strings.constant("nanosecondsDisplay");
    public static final TruffleString KEY_NOTATION = Strings.constant("notation");
    public static final TruffleString KEY_NUMERIC = Strings.constant("numeric");
    public static final TruffleString KEY_NUMBERING_SYSTEM = Strings.constant("numberingSystem");
    public static final TruffleString KEY_PLURAL_CATEGORIES = Strings.constant("pluralCategories");
    public static final TruffleString KEY_REGION = Strings.constant("region");
    public static final TruffleString KEY_ROUNDING_INCREMENT = Strings.ROUNDING_INCREMENT;
    public static final TruffleString KEY_ROUNDING_MODE = Strings.ROUNDING_MODE;
    public static final TruffleString KEY_ROUNDING_PRIORITY = Strings.constant("roundingPriority");
    public static final TruffleString KEY_RTL = Strings.constant("rtl");
    public static final TruffleString KEY_SCRIPT = Strings.SCRIPT;
    public static final TruffleString KEY_SECOND = Strings.SECOND;
    public static final TruffleString KEY_SECONDS = Strings.constant("seconds");
    public static final TruffleString KEY_SECONDS_DISPLAY = Strings.constant("secondsDisplay");
    public static final TruffleString KEY_SEGMENT = Strings.constant("segment");
    public static final TruffleString KEY_SENSITIVITY = Strings.constant("sensitivity");
    public static final TruffleString KEY_SIGN_DISPLAY = Strings.constant("signDisplay");
    public static final TruffleString KEY_SOURCE = Strings.SOURCE;
    public static final TruffleString KEY_STYLE = Strings.constant("style");
    public static final TruffleString KEY_TIME_STYLE = Strings.constant("timeStyle");
    public static final TruffleString KEY_TIME_ZONE = Strings.TIME_ZONE;
    public static final TruffleString KEY_TIME_ZONE_NAME = Strings.TIME_ZONE_NAME;
    public static final TruffleString KEY_TRAILING_ZERO_DISPLAY = Strings.constant("trailingZeroDisplay");
    public static final TruffleString KEY_TYPE = Strings.TYPE;
    public static final TruffleString KEY_UNIT = Strings.UNIT;
    public static final TruffleString KEY_UNIT_DISPLAY = Strings.constant("unitDisplay");
    public static final TruffleString KEY_USAGE = Strings.constant("usage");
    public static final TruffleString KEY_USE_GROUPING = Strings.constant("useGrouping");
    public static final TruffleString KEY_VALUE = Strings.VALUE;
    public static final TruffleString KEY_VARIANTS = Strings.constant("variants");
    public static final TruffleString KEY_WEEKDAY = Strings.constant("weekday");
    public static final TruffleString KEY_WEEKEND = Strings.constant("weekend");
    public static final TruffleString KEY_WEEKS = Strings.constant("weeks");
    public static final TruffleString KEY_WEEKS_DISPLAY = Strings.constant("weeksDisplay");
    public static final TruffleString KEY_YEAR = Strings.YEAR;
    public static final TruffleString KEY_YEARS = Strings.constant("years");
    public static final TruffleString KEY_YEARS_DISPLAY = Strings.constant("yearsDisplay");
    public static final TruffleString GREGORY = Strings.constant("gregory");
    public static final TruffleString GREGORY_INVERSE = Strings.constant("gregory-inverse");
    public static final TruffleString AD = Strings.constant("ad");
    public static final TruffleString BC = Strings.constant("bc");
    public static final TruffleString CE = Strings.constant("ce");
    public static final TruffleString BCE = Strings.constant("bce");
    public static final TruffleString REIWA = Strings.constant("reiwa");
    public static final TruffleString HEISEI = Strings.constant("heisei");
    public static final TruffleString SHOWA = Strings.constant("showa");
    public static final TruffleString TAISHO = Strings.constant("taisho");
    public static final TruffleString MEIJI = Strings.constant("meiji");
    public static final TruffleString JAPANESE = Strings.constant("japanese");
    public static final TruffleString JAPANESE_INVERSE = Strings.constant("japanese-inverse");
    private static final Set<String> SANCTIONED_SIMPLE_UNIT_IDENTIFIERS = Set.of("acre", "bit", "byte", "celsius", "centimeter", "day", "degree", "fahrenheit", "fluid-ounce", "foot", "gallon", "gigabit", "gigabyte", "gram", "hectare", "hour", "inch", "kilobit", "kilobyte", "kilogram", "kilometer", "liter", "megabit", "megabyte", "meter", "microsecond", "mile", "mile-scandinavian", "milliliter", "millimeter", "millisecond", "minute", "month", "nanosecond", "ounce", "percent", "petabyte", "pound", "second", "stone", "terabit", "terabyte", "week", "yard", "year");
    private static final LazyValue<Set<Locale>> AVAILABLE_LOCALES = new LazyValue<Set>(IntlUtil::initAvailableLocales);
    private static final String YES_PLACEHOLDER = "yes31415";
    private static final String TRUE_PLACEHOLDER = "true2718";

    private IntlUtil() {
    }

    public static Locale selectedLocale(JSContext ctx, String[] locales) {
        return IntlUtil.lookupMatcher(ctx, locales);
    }

    public static Locale bestAvailableLocale(JSContext context, Locale locale) {
        Locale candidate = locale;
        while (!IntlUtil.isAvailableLocale(context, candidate)) {
            String candidateLanguageTag = candidate.toLanguageTag();
            int pos = candidateLanguageTag.lastIndexOf(45);
            if (pos == -1) {
                return null;
            }
            if (pos >= 2 && candidateLanguageTag.charAt(pos - 2) == '-') {
                pos -= 2;
            }
            candidateLanguageTag = candidateLanguageTag.substring(0, pos);
            candidate = Locale.forLanguageTag(candidateLanguageTag);
        }
        return candidate;
    }

    @CompilerDirectives.TruffleBoundary
    public static Locale lookupMatcher(JSContext ctx, String[] requestedLocales) {
        for (String locale : requestedLocales) {
            Locale requestedLocale = Locale.forLanguageTag(locale);
            Locale noExtensionsLocale = requestedLocale.stripExtensions();
            Locale availableLocale = IntlUtil.bestAvailableLocale(ctx, noExtensionsLocale);
            if (availableLocale == null) continue;
            String unicodeExtension = requestedLocale.getExtension('u');
            if (unicodeExtension != null) {
                availableLocale = new Locale.Builder().setLocale(availableLocale).setExtension('u', unicodeExtension).build();
            }
            return availableLocale;
        }
        return ctx.getLocale();
    }

    @CompilerDirectives.TruffleBoundary
    public static List<Object> supportedLocales(JSContext ctx, String[] requestedLocales, String matcher) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String locale : requestedLocales) {
            Locale noExtensionsLocale = Locale.forLanguageTag(locale).stripExtensions();
            Locale availableLocale = IntlUtil.bestAvailableLocale(ctx, noExtensionsLocale);
            if (availableLocale == null) continue;
            result.add(Strings.fromJavaString(locale));
        }
        return result;
    }

    private static boolean isAvailableLocale(JSContext ctx, Locale locale) {
        return IntlUtil.getAvailableLocales().contains(locale) || ctx.getLocale().equals(locale);
    }

    private static Set<Locale> getAvailableLocales() {
        return AVAILABLE_LOCALES.get();
    }

    private static Set<Locale> initAvailableLocales() {
        HashSet<Locale> result = new HashSet<Locale>();
        try {
            for (ULocale ul : ULocale.getAvailableLocales()) {
                result.add(ul.toLocale());
                if (ul.getScript().isEmpty()) continue;
                result.add(new Locale.Builder().setLanguage(ul.getLanguage()).setRegion(ul.getCountry()).build());
            }
        }
        catch (MissingResourceException e) {
            throw Errors.createICU4JDataError(e);
        }
        return Set.of(result.toArray(new Locale[result.size()]));
    }

    public static boolean isValidNumberingSystem(String numberingSystem) {
        return Arrays.asList(NumberingSystem.getAvailableNames()).contains(numberingSystem);
    }

    public static String defaultNumberingSystemName(JSContext context, Locale locale) {
        if (context.isOptionV8CompatibilityMode() && "ar".equals(locale.toLanguageTag())) {
            return "latn";
        }
        return NumberingSystem.getInstance(locale).getName();
    }

    public static void validateUnicodeLocaleIdentifierType(String type, BranchProfile errorBranch) {
        if (!UTS35Validator.isStructurallyValidType(type)) {
            errorBranch.enter();
            throw Errors.createRangeErrorFormat("Invalid option: %s", null, type);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static String normalizeUnicodeLocaleIdentifierType(String type) {
        return type.toLowerCase();
    }

    public static boolean isWellFormedCurrencyCode(String currency) {
        return currency.length() == 3 && UTS35Validator.isAlpha(currency.charAt(0)) && UTS35Validator.isAlpha(currency.charAt(1)) && UTS35Validator.isAlpha(currency.charAt(2));
    }

    public static void ensureIsWellFormedCurrencyCode(String currency) {
        if (!IntlUtil.isWellFormedCurrencyCode(currency)) {
            throw Errors.createRangeErrorCurrencyNotWellFormed(currency);
        }
    }

    public static void ensureIsStructurallyValidLanguageId(String languageId) {
        if (!UTS35Validator.isStructurallyValidLanguageId(languageId)) {
            throw Errors.createRangeErrorInvalidLanguageId(languageId);
        }
    }

    public static void ensureIsStructurallyValidLanguageSubtag(String region) {
        if (!UTS35Validator.isStructurallyValidLanguageSubtag(region)) {
            throw Errors.createRangeErrorInvalidLanguageSubtag(region);
        }
    }

    public static void ensureIsStructurallyValidVariantSubtag(String variant) {
        if (!UTS35Validator.isStructurallyValidVariantSubtag(variant)) {
            throw Errors.createRangeErrorInvalidVariant(variant);
        }
    }

    public static void ensureIsStructurallyValidRegionSubtag(String region) {
        if (!UTS35Validator.isStructurallyValidRegionSubtag(region)) {
            throw Errors.createRangeErrorInvalidRegion(region);
        }
    }

    public static void ensureIsStructurallyValidScriptSubtag(String script) {
        if (!UTS35Validator.isStructurallyValidScriptSubtag(script)) {
            throw Errors.createRangeErrorInvalidScript(script);
        }
    }

    public static void ensureIsStructurallyValidCalendar(String calendar) {
        if (!UTS35Validator.isStructurallyValidType(calendar)) {
            throw Errors.createRangeErrorInvalidCalendar(calendar);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static String validateAndCanonicalizeLanguageTag(String languageTag) {
        if (!UTS35Validator.isWellFormedUnicodeBCP47LocaleIdentifier(languageTag)) {
            throw Errors.createRangeErrorFormat("Language tag is not well-formed: %s", null, languageTag);
        }
        return IntlUtil.canonicalizeLanguageTag(languageTag);
    }

    @CompilerDirectives.TruffleBoundary
    public static String canonicalizeLanguageTag(String languageTag) {
        try {
            Set<Character> extensions;
            ULocale locale = ULocale.createCanonical(ULocale.getName(languageTag));
            ULocale.Builder builder = new ULocale.Builder().setLocale(locale);
            String variant = locale.getVariant();
            if (variant.indexOf(95) != -1 || variant.indexOf(45) != -1) {
                Object[] variants = variant.split("[_-]");
                if (new HashSet<String>(Arrays.asList(variants)).size() != variants.length) {
                    throw Errors.createRangeErrorFormat("Language tag with duplicate variants: %s", null, languageTag);
                }
                Arrays.sort(variants);
                StringBuilder sb = new StringBuilder((String)variants[0]);
                for (int i = 1; i < variants.length; ++i) {
                    sb.append('-').append((String)variants[i]);
                }
                builder.setVariant(sb.toString());
            }
            if (!(extensions = locale.getExtensionKeys()).isEmpty()) {
                String tag = languageTag.toLowerCase();
                int privateExtIdx = extensions.contains(Character.valueOf('x')) ? tag.indexOf("-x-") : tag.length();
                for (Character c : extensions) {
                    int idx;
                    String extDelimiter;
                    int idx2;
                    if (c.charValue() == 'x' || (idx2 = tag.indexOf(extDelimiter = "-" + c + "-", (idx = tag.indexOf(extDelimiter)) + 1)) == -1 || idx2 >= privateExtIdx) continue;
                    throw Errors.createRangeErrorFormat("Language tag with duplicate singletons: %s", null, languageTag);
                }
                Locale loc = new Locale.Builder().setLanguageTag(languageTag).build();
                for (String key : loc.getUnicodeLocaleKeys()) {
                    String type = loc.getUnicodeLocaleType(key);
                    if (!(!"yes".equals(type) || "kb".equals(key) || "kc".equals(key) || "kh".equals(key) || "kk".equals(key) || "kn".equals(key))) {
                        type = YES_PLACEHOLDER;
                    }
                    if ("rg".equals(key) || "sd".equals(key)) {
                        type = IntlUtil.normalizeRGType(type);
                    }
                    builder.setUnicodeLocaleKeyword(key, type);
                }
                String string = new ULocale(languageTag).getExtension('t');
                if (string != null) {
                    builder.setExtension('t', IntlUtil.normalizeTransformedExtension(string));
                }
            }
            String result = IntlUtil.maybeAppendMissingLanguageSubTag(builder.build().toLanguageTag());
            return result.replaceAll("-yes31415", "-yes").replaceAll("-true2718", "-true");
        }
        catch (IllformedLocaleException e) {
            throw Errors.createRangeError(e.getMessage());
        }
    }

    public static String normalizeCAType(String type) {
        if ("gregorian".equals(type)) {
            return "gregory";
        }
        if ("ethiopic-amete-alem".equals(type)) {
            return "ethioaa";
        }
        if ("islamicc".equals(type)) {
            return "islamic-civil";
        }
        return type;
    }

    private static String normalizeRGType(String type) {
        if ("cn11".equals(type)) {
            return "cnbj";
        }
        if ("cz10a".equals(type)) {
            return "cz110";
        }
        if ("fra".equals(type) || "frg".equals(type)) {
            return "frges";
        }
        if ("lud".equals(type)) {
            return "lucl";
        }
        if ("no23".equals(type)) {
            return "no50";
        }
        return type;
    }

    private static String normalizeTransformedExtension(String extension) {
        String tlang = null;
        TreeMap<String, String> fields = new TreeMap<String, String>();
        boolean seenDash = true;
        String lastKey = null;
        int lastValueStart = -1;
        for (int i = 0; i < extension.length() - 1; ++i) {
            if (seenDash && UTS35Validator.isAlpha(extension.charAt(i)) && UTS35Validator.isDigit(extension.charAt(i + 1)) && (i + 2 == extension.length() || extension.charAt(i + 2) == '-')) {
                if (lastKey == null) {
                    tlang = extension.substring(0, Math.max(0, i - 1));
                } else {
                    fields.put(lastKey, extension.substring(lastValueStart, i - 1));
                }
                lastKey = extension.substring(i, i + 2);
                lastValueStart = i + 3;
            }
            seenDash = extension.charAt(i) == '-';
        }
        if (tlang == null) {
            tlang = extension;
        }
        if (lastKey != null) {
            fields.put(lastKey, extension.substring(lastValueStart));
        }
        StringBuilder normalized = new StringBuilder();
        if (!tlang.isEmpty()) {
            tlang = IntlUtil.validateAndCanonicalizeLanguageTag(tlang);
            normalized.append(tlang);
        }
        for (Map.Entry entry : fields.entrySet()) {
            String value;
            if (normalized.length() != 0) {
                normalized.append('-');
            }
            if ("names".equalsIgnoreCase(value = (String)entry.getValue())) {
                value = "prprname";
            }
            if ("true".equals(value)) {
                value = TRUE_PLACEHOLDER;
            }
            normalized.append((String)entry.getKey()).append('-').append(value);
        }
        return normalized.toString();
    }

    public static String maybeAppendMissingLanguageSubTag(String tag) {
        return tag.startsWith("x-") ? "und-" + tag : tag;
    }

    @CompilerDirectives.TruffleBoundary
    public static String toUpperCase(String in) {
        StringBuilder result = new StringBuilder(in.length());
        for (int i = 0; i < in.length(); ++i) {
            int c = in.codePointAt(i);
            if (c >= 97 && c <= 122) {
                result.append((char)(c - 32));
                continue;
            }
            result.append((char)c);
        }
        return result.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String toLowerCase(JSContext ctx, String s, String[] locales) {
        Locale strippedLocale = IntlUtil.selectedLocaleStripped(ctx, locales);
        StringBuilder result = new StringBuilder();
        CaseMap.Lower tr = CaseMap.toLower();
        tr.apply(strippedLocale, s, result, null);
        return result.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String toUpperCase(JSContext ctx, String s, String[] locales) {
        Locale strippedLocale = IntlUtil.selectedLocaleStripped(ctx, locales);
        StringBuilder result = new StringBuilder();
        CaseMap.Upper tr = CaseMap.toUpper();
        tr.apply(strippedLocale, s, result, null);
        return result.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static Locale selectedLocaleStripped(JSContext ctx, String[] locales) {
        return IntlUtil.selectedLocale(ctx, locales).stripExtensions();
    }

    public static JSObject makePart(JSContext context, JSRealm realm, String type, String value) {
        return IntlUtil.makePart(context, realm, type, value, null);
    }

    public static JSObject makePart(JSContext context, JSRealm realm, String type, String value, String unit) {
        return IntlUtil.makePart(context, realm, type, value, unit, null);
    }

    public static JSObject makePart(JSContext context, JSRealm realm, String type, String value, String unit, String source) {
        JSObject p = JSOrdinary.create(context, realm);
        JSObject.set((JSDynamicObject)p, KEY_TYPE, (Object)Strings.fromJavaString(type));
        JSObject.set((JSDynamicObject)p, KEY_VALUE, (Object)Strings.fromJavaString(value));
        if (unit != null) {
            JSObject.set((JSDynamicObject)p, KEY_UNIT, (Object)Strings.fromJavaString(unit));
        }
        if (source != null) {
            JSObject.set((JSDynamicObject)p, KEY_SOURCE, (Object)Strings.fromJavaString(source));
        }
        return p;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isSanctionedSimpleUnitIdentifier(String unitIdentifier) {
        return SANCTIONED_SIMPLE_UNIT_IDENTIFIERS.contains(unitIdentifier);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isWellFormedUnitIdentifier(String unitIdentifier) {
        if (IntlUtil.isSanctionedSimpleUnitIdentifier(unitIdentifier)) {
            return true;
        }
        String per = "-per-";
        int index = unitIdentifier.indexOf(per);
        if (index == -1) {
            return false;
        }
        String numerator = unitIdentifier.substring(0, index);
        String denominator = unitIdentifier.substring(index + per.length());
        return IntlUtil.isSanctionedSimpleUnitIdentifier(numerator) && IntlUtil.isSanctionedSimpleUnitIdentifier(denominator);
    }

    public static void ensureIsWellFormedUnitIdentifier(String unitIdentifier) {
        if (!IntlUtil.isWellFormedUnitIdentifier(unitIdentifier)) {
            throw Errors.createRangeErrorInvalidUnitIdentifier(unitIdentifier);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static TimeZone getICUTimeZone(String tzId, JSContext context) {
        assert (tzId != null);
        if (context.getLanguageOptions().zoneRulesBasedTimeZones()) {
            return new ZoneRulesBasedTimeZone(tzId, ZoneRulesProvider.getRules(tzId, false));
        }
        return TimeZone.getTimeZone(tzId);
    }

    @CompilerDirectives.TruffleBoundary
    public static TimeZone getICUTimeZone(ZoneId zoneId, JSContext context) {
        if (context.getLanguageOptions().zoneRulesBasedTimeZones()) {
            return new ZoneRulesBasedTimeZone(zoneId.getId(), zoneId.getRules());
        }
        return TimeZone.getTimeZone(IntlUtil.toICUTimeZoneId(zoneId));
    }

    @CompilerDirectives.TruffleBoundary
    public static TimeZone getICUTimeZoneForOffset(String tzOffset) {
        assert (tzOffset != null);
        return TimeZone.getTimeZone(IntlUtil.prependGMT(tzOffset));
    }

    @CompilerDirectives.TruffleBoundary
    private static String prependGMT(String tzId) {
        return "GMT" + tzId;
    }

    private static String toICUTimeZoneId(ZoneId zoneId) {
        Object tzid = zoneId.getId();
        char c = ((String)tzid).charAt(0);
        if (c == '+' || c == '-') {
            tzid = "GMT" + (String)tzid;
        } else if (c == 'Z' && ((String)tzid).length() == 1) {
            tzid = "UTC";
        } else if (((String)tzid).startsWith("UTC")) {
            tzid = "GMT" + ((String)tzid).substring(3);
        } else if (((String)tzid).startsWith("UT")) {
            tzid = "GMT" + ((String)tzid).substring(2);
        }
        return tzid;
    }

    public static String toJSHourCycle(DateFormat.HourCycle hourCycle) {
        switch (hourCycle) {
            case HOUR_CYCLE_11: {
                return H11;
            }
            case HOUR_CYCLE_12: {
                return H12;
            }
            case HOUR_CYCLE_23: {
                return H23;
            }
            case HOUR_CYCLE_24: {
                return H24;
            }
        }
        throw Errors.shouldNotReachHereUnexpectedValue((Object)hourCycle);
    }

    @CompilerDirectives.TruffleBoundary
    public static String[] availableCalendars(ULocale locale, boolean commonlyUsed) {
        String[] calendars = Calendar.getKeywordValuesForLocale(CALENDAR, locale, commonlyUsed);
        int length = 0;
        for (String calendar : calendars) {
            if ("unknown".equals(calendar)) continue;
            calendars[length++] = IntlUtil.normalizeCAType(calendar);
        }
        if (length != calendars.length) {
            String[] trimmed = new String[length];
            System.arraycopy(calendars, 0, trimmed, 0, length);
            calendars = trimmed;
        }
        return calendars;
    }

    @CompilerDirectives.TruffleBoundary
    public static String[] availableCalendars() {
        Object[] calendars = IntlUtil.availableCalendars(ULocale.ROOT, false);
        Arrays.sort(calendars);
        return calendars;
    }

    @CompilerDirectives.TruffleBoundary
    public static String canonicalizeCalendar(String id) {
        String canonical = IntlUtil.normalizeCAType(id.toLowerCase(Locale.ROOT));
        if (Arrays.binarySearch(IntlUtil.availableCalendars(), canonical) < 0) {
            throw Errors.createRangeErrorInvalidCalendar(id);
        }
        return canonical;
    }

    public static String normalizeCollation(String collation) {
        return switch (collation) {
            case "dictionary" -> "dict";
            case "gb2312han" -> "gb2312";
            case "phonebook" -> "phonebk";
            case "traditional" -> "trad";
            default -> collation;
        };
    }

    @CompilerDirectives.TruffleBoundary
    public static String[] availableCollations(ULocale locale, boolean commonOnly) {
        Object[] collations = locale == null ? Collator.getKeywordValues(COLLATION) : Collator.getKeywordValuesForLocale(COLLATION, locale, commonOnly);
        int length = 0;
        for (String string : collations) {
            if (SEARCH.equals(string) || STANDARD.equals(string)) continue;
            collations[length++] = IntlUtil.normalizeCollation(string);
        }
        if (length != collations.length) {
            String[] trimmed = new String[length];
            System.arraycopy(collations, 0, trimmed, 0, length);
            collations = trimmed;
        }
        Arrays.sort(collations);
        return collations;
    }

    @CompilerDirectives.TruffleBoundary
    public static String[] availableCollations() {
        return IntlUtil.availableCollations(null, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static String[] availableCurrencies() {
        List<String> list = CurrencyMetaInfo.getInstance().currencies(CurrencyMetaInfo.CurrencyFilter.all());
        Object[] currencies = list.toArray(new String[list.size()]);
        Arrays.sort(currencies);
        return currencies;
    }

    @CompilerDirectives.TruffleBoundary
    public static String[] availableNumberingSystems(JSContext context) {
        Object[] numberingSystems = NumberingSystem.getAvailableNames();
        if (context.isOptionV8CompatibilityMode()) {
            int length = 0;
            for (Object numberingSystem : numberingSystems) {
                if (NumberingSystem.getInstanceByName((String)numberingSystem).isAlgorithmic()) continue;
                numberingSystems[length++] = numberingSystem;
            }
            if (length != numberingSystems.length) {
                String[] trimmed = new String[length];
                System.arraycopy(numberingSystems, 0, trimmed, 0, length);
                numberingSystems = trimmed;
            }
        }
        Arrays.sort(numberingSystems);
        return numberingSystems;
    }

    @CompilerDirectives.TruffleBoundary
    public static String[] availableTimeZones() {
        Set<String> set = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL_LOCATION, null, null);
        Object[] timeZones = set.toArray(new String[set.size()]);
        Arrays.sort(timeZones);
        return timeZones;
    }

    @CompilerDirectives.TruffleBoundary
    public static String[] availableUnits() {
        Set<String> set = SANCTIONED_SIMPLE_UNIT_IDENTIFIERS;
        Object[] units = set.toArray(new String[set.size()]);
        Arrays.sort(units);
        return units;
    }

    public static String sourceString(int start, int limit, int startRangeStart, int startRangeLimit, int endRangeStart, int endRangeLimit) {
        String source = startRangeStart <= start && limit <= startRangeLimit ? START_RANGE : (endRangeStart <= start && limit <= endRangeLimit ? END_RANGE : SHARED);
        return source;
    }

    @CompilerDirectives.TruffleBoundary
    public static Calendar getCalendar(TruffleString calendarID) {
        Calendar cal = Calendar.getInstance(TimeZone.GMT_ZONE, new ULocale("und-u-ca-" + String.valueOf(calendarID)));
        if (cal instanceof GregorianCalendar) {
            GregorianCalendar gCal = (GregorianCalendar)cal;
            gCal.setGregorianChange(new Date(Long.MIN_VALUE));
        }
        return cal;
    }

    @CompilerDirectives.TruffleBoundary
    public static Calendar getCalendar(TruffleString calendarID, int year, int month, int day) {
        Calendar cal = IntlUtil.getCalendar(calendarID);
        cal.setTimeInMillis(86400000L * JSDate.isoDateToEpochDays(year, month - 1, day));
        return cal;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean hasLeapYears(Calendar cal) {
        return cal.getMaximum(6) != cal.getMinimum(6);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isLeapYear(Calendar cal) {
        return cal.inTemporalLeapYear();
    }

    @CompilerDirectives.TruffleBoundary
    public static int getCalendarField(Calendar cal, int field) {
        return cal.get(field);
    }

    @CompilerDirectives.TruffleBoundary
    public static int getCalendarFieldMax(Calendar cal, int field) {
        return cal.getActualMaximum(field);
    }

    @CompilerDirectives.TruffleBoundary
    public static String getTemporalMonthCode(Calendar cal) {
        return cal.getTemporalMonthCode();
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean calendarSupportsEra(TruffleString calendarID) {
        Calendar cal = IntlUtil.getCalendar(calendarID);
        return IntlUtil.calendarSupportsEra(cal);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean calendarSupportsEra(Calendar cal) {
        return cal.getMaximum(0) != cal.getMinimum(0) && !(cal instanceof ChineseCalendar);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object getEraYear(Calendar cal) {
        return IntlUtil.calendarSupportsEra(cal) ? Integer.valueOf(cal.get(1)) : Undefined.instance;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object getEra(Calendar cal) {
        return IntlUtil.calendarSupportsEra(cal) ? IntlUtil.getEraAsString(cal) : Undefined.instance;
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString getEraAsString(Calendar cal) {
        int era = cal.get(0);
        if (cal instanceof JapaneseCalendar) {
            if (era == JapaneseCalendar.REIWA) {
                return REIWA;
            }
            if (era == JapaneseCalendar.HEISEI) {
                return HEISEI;
            }
            if (era == JapaneseCalendar.SHOWA) {
                return SHOWA;
            }
            if (era == JapaneseCalendar.TAISHO) {
                return TAISHO;
            }
            if (era == JapaneseCalendar.MEIJI) {
                return MEIJI;
            }
            if (era == 1) {
                return JAPANESE;
            }
            if (era == 0) {
                return JAPANESE_INVERSE;
            }
        } else if (cal instanceof GregorianCalendar) {
            if (era == 1) {
                return GREGORY;
            }
            return GREGORY_INVERSE;
        }
        return Strings.UNKNOWN;
    }

    @CompilerDirectives.TruffleBoundary
    public static Integer canonicalizeEraInCalendar(Calendar cal, TruffleString era) {
        if (cal instanceof JapaneseCalendar) {
            if (Strings.equals(REIWA, era)) {
                return JapaneseCalendar.REIWA;
            }
            if (Strings.equals(HEISEI, era)) {
                return JapaneseCalendar.HEISEI;
            }
            if (Strings.equals(SHOWA, era)) {
                return JapaneseCalendar.SHOWA;
            }
            if (Strings.equals(TAISHO, era)) {
                return JapaneseCalendar.TAISHO;
            }
            if (Strings.equals(MEIJI, era)) {
                return JapaneseCalendar.MEIJI;
            }
            if (Strings.equals(JAPANESE, era) || Strings.equals(GREGORY, era) || Strings.equals(AD, era) || Strings.equals(CE, era)) {
                return 1;
            }
            if (Strings.equals(JAPANESE_INVERSE, era) || Strings.equals(GREGORY_INVERSE, era) || Strings.equals(BC, era) || Strings.equals(BCE, era)) {
                return 0;
            }
        } else if (cal instanceof GregorianCalendar) {
            if (Strings.equals(GREGORY, era) || Strings.equals(AD, era) || Strings.equals(CE, era)) {
                return 1;
            }
            if (Strings.equals(GREGORY_INVERSE, era) || Strings.equals(BC, era) || Strings.equals(BCE, era)) {
                return 0;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CompilerDirectives.TruffleBoundary
    static int maxDayInMonth(Calendar cal, String monthCode) {
        if (cal instanceof GregorianCalendar) {
            if ("M02".equals(monthCode)) {
                return 29;
            }
        } else {
            if (cal instanceof ChineseCalendar) {
                if ("M09L".equals(monthCode)) return 29;
                if (!"M11L".equals(monthCode)) return 30;
                return 29;
            }
            if (cal instanceof HebrewCalendar) {
                if ("M02".equals(monthCode)) return 30;
                if ("M03".equals(monthCode)) {
                    return 30;
                }
            } else if (cal instanceof IslamicCalendar) {
                IslamicCalendar iCal = (IslamicCalendar)cal;
                if (!iCal.isCivil()) {
                    if (iCal.getCalculationType() != IslamicCalendar.CalculationType.ISLAMIC_TBLA) return 30;
                }
                if ("M12".equals(monthCode)) {
                    return 30;
                }
            } else if (cal instanceof PersianCalendar) {
                if ("M12".equals(monthCode)) {
                    return 30;
                }
            } else if (cal instanceof IndianCalendar) {
                if ("M01".equals(monthCode)) {
                    return 31;
                }
            } else if (monthCode.equals("M13")) {
                return 6;
            }
        }
        cal.setTemporalMonthCode(monthCode);
        return cal.getActualMaximum(5);
    }
}

