/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir.Module;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;

public class ScriptOrModule {
    protected final JSContext context;
    protected final Source source;
    private volatile Map<TruffleString, Source> importSourceCache;
    private static final VarHandle IMPORT_SOURCE_CACHE_HANDLE;

    public ScriptOrModule(JSContext context, Source source) {
        this.context = context;
        this.source = source;
    }

    public final JSContext getContext() {
        return this.context;
    }

    public final Source getSource() {
        return this.source;
    }

    @CompilerDirectives.TruffleBoundary
    public AbstractModuleRecord addLoadedModule(JSRealm realm, Module.ModuleRequest moduleRequest, AbstractModuleRecord moduleRecord) {
        return realm.getModuleLoader().addLoadedModule(moduleRequest, moduleRecord);
    }

    public void rememberImportedModuleSource(TruffleString moduleSpecifier, Source moduleSource) {
        this.getImportSourceCache().put(moduleSpecifier, moduleSource);
    }

    private Map<TruffleString, Source> getImportSourceCache() {
        Map<TruffleString, Source> cache = this.importSourceCache;
        if (cache == null && !IMPORT_SOURCE_CACHE_HANDLE.compareAndSet(this, null, cache = new ConcurrentHashMap<TruffleString, Source>())) {
            cache = this.importSourceCache;
        }
        return cache;
    }

    static {
        try {
            IMPORT_SOURCE_CACHE_HANDLE = MethodHandles.lookup().findVarHandle(ScriptOrModule.class, "importSourceCache", Map.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }
}

