/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir.Module;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;

public abstract class CyclicModuleRecord
extends AbstractModuleRecord {
    private Status status;
    private int dfsIndex = -1;
    private int dfsAncestorIndex = -1;
    private final EconomicMap<LoadedModuleRequest, AbstractModuleRecord> loadedModules = EconomicMap.create();
    private CyclicModuleRecord cycleRoot = this;
    private final boolean hasTLA;
    private boolean asyncEvaluation;
    private long asyncEvaluationOrder;
    private PromiseCapabilityRecord topLevelPromiseCapability = null;
    private List<CyclicModuleRecord> asyncParentModules = null;
    private int pendingAsyncDependencies = 0;
    private Throwable evaluationError;
    private Object executionResult;

    protected CyclicModuleRecord(JSContext context, Source source, Object hostDefined, FrameDescriptor frameDescriptor) {
        this(context, source, hostDefined, frameDescriptor, false);
    }

    protected CyclicModuleRecord(JSContext context, Source source, Object hostDefined, FrameDescriptor frameDescriptor, boolean hasTLA) {
        super(context, source, hostDefined, frameDescriptor);
        this.hasTLA = hasTLA;
        this.status = Status.New;
    }

    public abstract List<Module.ModuleRequest> getRequestedModules();

    public abstract void initializeEnvironment(JSRealm var1);

    public abstract Object executeModule(JSRealm var1, PromiseCapabilityRecord var2);

    @Override
    public final JSPromiseObject evaluate(JSRealm realm) {
        return this.context.getEvaluator().moduleEvaluation(realm, this);
    }

    @Override
    public final void link(JSRealm realm) {
        this.context.getEvaluator().moduleLinking(realm, this);
    }

    @CompilerDirectives.TruffleBoundary
    public final AbstractModuleRecord getLoadedModule(Module.ModuleRequest moduleRequest) {
        return (AbstractModuleRecord)this.loadedModules.get(LoadedModuleRequest.of(moduleRequest));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final AbstractModuleRecord addLoadedModule(JSRealm realm, Module.ModuleRequest moduleRequest, AbstractModuleRecord module) {
        return this.loadedModules.putIfAbsent(LoadedModuleRequest.of(moduleRequest), module);
    }

    @CompilerDirectives.TruffleBoundary
    public final AbstractModuleRecord getImportedModule(Module.ModuleRequest moduleRequest) {
        AbstractModuleRecord loadedModule = this.getLoadedModule(moduleRequest);
        assert (loadedModule != null) : moduleRequest;
        return loadedModule;
    }

    @Override
    public final Status getStatus() {
        return this.status;
    }

    public final void setStatus(Status status) {
        this.status = status;
    }

    public final boolean isLinked() {
        return this.getStatus().compareTo(Status.Linked) >= 0;
    }

    public final boolean hasBeenEvaluated() {
        return this.getStatus() == Status.Evaluated || this.getStatus() == Status.EvaluatingAsync;
    }

    public final void setUnlinked() {
        this.setStatus(Status.Unlinked);
        this.clearEnvironment();
        this.dfsIndex = -1;
        this.dfsAncestorIndex = -1;
    }

    public final Throwable getEvaluationError() {
        assert (this.hasBeenEvaluated());
        return this.evaluationError;
    }

    public final void setEvaluationError(Throwable evaluationError) {
        assert (this.hasBeenEvaluated());
        this.evaluationError = evaluationError;
    }

    public final Object getExecutionResult() {
        assert (this.hasBeenEvaluated());
        return this.executionResult;
    }

    public final void setExecutionResult(Object executionResult) {
        this.executionResult = executionResult;
    }

    public final Object getExecutionResultOrThrow() {
        assert (this.hasBeenEvaluated());
        Throwable error = this.getEvaluationError();
        if (error != null) {
            throw JSRuntime.rethrow(error);
        }
        Object result = this.getExecutionResult();
        assert (result != null);
        return result;
    }

    public final int getDFSIndex() {
        assert (this.dfsIndex >= 0);
        return this.dfsIndex;
    }

    public final void setDFSIndex(int dfsIndex) {
        this.dfsIndex = dfsIndex;
    }

    public final int getDFSAncestorIndex() {
        assert (this.dfsAncestorIndex >= 0);
        return this.dfsAncestorIndex;
    }

    public final void setDFSAncestorIndex(int dfsAncestorIndex) {
        this.dfsAncestorIndex = dfsAncestorIndex;
    }

    public final PromiseCapabilityRecord getTopLevelCapability() {
        return this.topLevelPromiseCapability;
    }

    public final void setTopLevelCapability(PromiseCapabilityRecord capability) {
        this.topLevelPromiseCapability = capability;
    }

    public final boolean isAsyncEvaluation() {
        return this.asyncEvaluation;
    }

    public final void setAsyncEvaluation(boolean asyncEvaluation) {
        this.asyncEvaluation = asyncEvaluation;
    }

    public final List<CyclicModuleRecord> getAsyncParentModules() {
        return this.asyncParentModules;
    }

    public final void setPendingAsyncDependencies(int value) {
        this.pendingAsyncDependencies = value;
    }

    public final void initAsyncParentModules() {
        assert (this.asyncParentModules == null);
        this.asyncParentModules = new ArrayList<CyclicModuleRecord>();
    }

    public final void incPendingAsyncDependencies() {
        ++this.pendingAsyncDependencies;
    }

    public final void decPendingAsyncDependencies() {
        --this.pendingAsyncDependencies;
    }

    public final void appendAsyncParentModules(CyclicModuleRecord moduleRecord) {
        this.asyncParentModules.add(moduleRecord);
    }

    public final int getPendingAsyncDependencies() {
        return this.pendingAsyncDependencies;
    }

    public final void setAsyncEvaluatingOrder(long order) {
        this.asyncEvaluationOrder = order;
    }

    public final long getAsyncEvaluatingOrder() {
        return this.asyncEvaluationOrder;
    }

    public final boolean hasTLA() {
        return this.hasTLA;
    }

    public final void setCycleRoot(CyclicModuleRecord module) {
        this.cycleRoot = module;
    }

    public final CyclicModuleRecord getCycleRoot() {
        return this.cycleRoot;
    }

    @CompilerDirectives.TruffleBoundary
    public final boolean isReadyForSyncExecution() {
        return this.isReadyForSyncExecution(new HashSet<AbstractModuleRecord>());
    }

    private boolean isReadyForSyncExecution(Set<AbstractModuleRecord> seen) {
        CompilerAsserts.neverPartOfCompilation();
        if (!seen.add(this)) {
            return true;
        }
        if (this.getStatus() == Status.Evaluated) {
            return true;
        }
        if (this.getStatus() == Status.Evaluating || this.getStatus() == Status.EvaluatingAsync) {
            return false;
        }
        assert (this.getStatus() == Status.Linked) : this.getStatus();
        if (this.hasTLA()) {
            return false;
        }
        for (Module.ModuleRequest request : this.getRequestedModules()) {
            CyclicModuleRecord requiredCyclicModule;
            AbstractModuleRecord requiredModule = this.getImportedModule(request);
            if (!(requiredModule instanceof CyclicModuleRecord) || (requiredCyclicModule = (CyclicModuleRecord)requiredModule).isReadyForSyncExecution(seen)) continue;
            return false;
        }
        return true;
    }

    public static enum Status {
        New,
        Unlinked,
        Linking,
        Linked,
        Evaluating,
        EvaluatingAsync,
        Evaluated;

    }

    public record LoadedModuleRequest(TruffleString specifier, Map<TruffleString, TruffleString> attributes) {
        public static LoadedModuleRequest of(Module.ModuleRequest request) {
            return new LoadedModuleRequest(request.specifier(), request.attributes());
        }
    }
}

