/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects;

import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;

public final class AsyncContext {
    private static final AsyncContext EMPTY = new AsyncContext();
    private final Object[] mapping;

    private AsyncContext() {
        this(ScriptArray.EMPTY_OBJECT_ARRAY);
    }

    private AsyncContext(Object[] mapping) {
        this.mapping = mapping;
    }

    public static AsyncContext empty() {
        return EMPTY;
    }

    public AsyncContext withMapping(Symbol key, Object value) {
        int len = this.mapping.length;
        for (int i = 0; i < len; i += 2) {
            Object k = this.mapping[i];
            Object v = this.mapping[i + 1];
            if (k != key) continue;
            if (v == value) {
                return this;
            }
            Object[] newMapping = Arrays.copyOf(this.mapping, len);
            assert (newMapping[i] == key);
            newMapping[i + 1] = value;
            return new AsyncContext(newMapping);
        }
        Object[] newMapping = Arrays.copyOf(this.mapping, len + 2);
        newMapping[len] = key;
        newMapping[len + 1] = value;
        return new AsyncContext(newMapping);
    }

    public Object getOrDefault(Symbol asyncContextKey, Object defaultValue) {
        for (int i = 0; i < this.mapping.length; i += 2) {
            Object k = this.mapping[i];
            if (k != asyncContextKey) continue;
            return this.mapping[i + 1];
        }
        return defaultValue;
    }

    public String toString() {
        return "AsyncContext" + Arrays.toString(this.mapping);
    }
}

