/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.external;

public class XSum {
    private static final int XSUM_MANTISSA_BITS = 52;
    private static final int XSUM_EXP_BITS = 11;
    private static final long XSUM_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long XSUM_EXP_MASK = 2047L;
    private static final int XSUM_EXP_BIAS = 1023;
    private static final int XSUM_SIGN_BIT = 63;
    private static final long XSUM_SIGN_MASK = Long.MIN_VALUE;
    private static final int XSUM_SCHUNK_BITS = 64;
    private static final int XSUM_LOW_EXP_BITS = 5;
    private static final int XSUM_LOW_EXP_MASK = 31;
    private static final int XSUM_HIGH_EXP_BITS = 6;
    private static final int XSUM_SCHUNKS = 67;
    private static final int XSUM_LOW_MANTISSA_BITS = 32;
    private static final long XSUM_LOW_MANTISSA_MASK = 0xFFFFFFFFL;
    private static final int XSUM_SMALL_CARRY_BITS = 11;
    private static final int XSUM_SMALL_CARRY_TERMS = 2047;

    public static class SmallAccumulator {
        private long[] chunk = new long[67];
        private long inf;
        private long nan;
        private int addsUntilPropagate = 2047;

        public void addArray(double[] vec) {
            int m;
            int pos = 0;
            for (int n = vec.length; n > 0; n -= m) {
                if (this.addsUntilPropagate == 0) {
                    this.carryPropagate();
                }
                m = n <= this.addsUntilPropagate ? n : this.addsUntilPropagate;
                int nextPos = pos + m;
                for (int i = pos; i < nextPos; ++i) {
                    this.add1NoCarry(vec[i]);
                }
                this.addsUntilPropagate -= m;
                pos = nextPos;
            }
        }

        public void add(double value) {
            if (this.addsUntilPropagate == 0) {
                this.carryPropagate();
            }
            this.add1NoCarry(value);
            --this.addsUntilPropagate;
        }

        private int carryPropagate() {
            int uix;
            block15: {
                int u = 66;
                while (this.chunk[u] == 0L) {
                    if (u == 0) {
                        uix = 0;
                        break block15;
                    }
                    --u;
                }
                uix = -1;
                int i = 0;
                int e = u - 3;
                while ((this.chunk[i] | this.chunk[i + 1] | this.chunk[i + 2] | this.chunk[i + 3]) == 0L && (i += 4) <= e) {
                }
                while (true) {
                    long c;
                    if ((c = this.chunk[i]) == 0L && ++i <= u) {
                        continue;
                    }
                    if (c == 0L) break;
                    long chigh = c >> 32;
                    if (chigh == 0L) {
                        uix = i++;
                    } else {
                        long clow;
                        if (u == i) {
                            if (chigh == -1L) {
                                uix = i;
                                break;
                            }
                            u = i + 1;
                        }
                        if ((clow = c & 0xFFFFFFFFL) != 0L) {
                            uix = i;
                        }
                        this.chunk[i] = clow;
                        if (i + 1 >= 67) {
                            this.addInfNan(Long.MAX_VALUE);
                            u = i;
                        } else {
                            int n = i + 1;
                            this.chunk[n] = this.chunk[n] + chigh;
                        }
                        ++i;
                    }
                    if (i > u) break;
                }
                if (uix < 0) {
                    uix = 0;
                } else {
                    while (this.chunk[uix] == -1L && uix > 0) {
                        int n = uix - 1;
                        this.chunk[n] = this.chunk[n] + -4294967296L;
                        this.chunk[uix] = 0L;
                        --uix;
                    }
                }
            }
            this.addsUntilPropagate = 2046;
            return uix;
        }

        private void add1NoCarry(double value) {
            long ivalue = Double.doubleToRawLongBits(value);
            int exp = (int)(ivalue >> 52 & 0x7FFL);
            long mantissa = ivalue & 0xFFFFFFFFFFFFFL;
            int highExp = exp >> 5;
            int lowExp = exp & 0x1F;
            if (exp == 0) {
                if (mantissa == 0L) {
                    return;
                }
                lowExp = 1;
                exp = 1;
            } else {
                if ((long)exp == 2047L) {
                    this.addInfNan(ivalue);
                    return;
                }
                mantissa |= 0x10000000000000L;
            }
            long lowMantissa = mantissa << lowExp & 0xFFFFFFFFL;
            long highMantissa = mantissa >> 32 - lowExp;
            if (ivalue < 0L) {
                int n = highExp;
                this.chunk[n] = this.chunk[n] - lowMantissa;
                int n2 = highExp + 1;
                this.chunk[n2] = this.chunk[n2] - highMantissa;
            } else {
                int n = highExp;
                this.chunk[n] = this.chunk[n] + lowMantissa;
                int n3 = highExp + 1;
                this.chunk[n3] = this.chunk[n3] + highMantissa;
            }
        }

        private void addInfNan(long ivalue) {
            long mantissa = ivalue & 0xFFFFFFFFFFFFFL;
            if (mantissa == 0L) {
                if (this.inf == 0L) {
                    this.inf = ivalue;
                } else if (this.inf != ivalue) {
                    this.inf = Double.doubleToRawLongBits(Double.NaN);
                }
            } else if ((this.nan & 0xFFFFFFFFFFFFFL) <= mantissa) {
                this.nan = ivalue & Long.MAX_VALUE;
            }
        }

        public double round() {
            int e;
            long ivalue;
            int i;
            block24: {
                block25: {
                    long lower;
                    int j;
                    int more;
                    long intv;
                    block23: {
                        if (this.nan != 0L) {
                            return Double.longBitsToDouble(this.nan);
                        }
                        if (this.inf != 0L) {
                            return Double.longBitsToDouble(this.inf);
                        }
                        i = this.carryPropagate();
                        ivalue = this.chunk[i];
                        if (i <= 1) {
                            if (ivalue == 0L) {
                                return 0.0;
                            }
                            if (i == 0) {
                                long intv2 = ivalue >= 0L ? ivalue : -ivalue;
                                intv2 >>= 1;
                                if (ivalue < 0L) {
                                    intv2 |= Long.MIN_VALUE;
                                }
                                return Double.longBitsToDouble(intv2);
                            }
                            intv = ivalue * 0x80000000L + (this.chunk[0] >> 1);
                            if (intv < 0L) {
                                if (intv > -4503599627370496L) {
                                    intv = -intv | Long.MIN_VALUE;
                                    return Double.longBitsToDouble(intv);
                                }
                            } else if (intv < 0x10000000000000L) {
                                return Double.longBitsToDouble(intv);
                            }
                        }
                        intv = Double.doubleToRawLongBits(ivalue);
                        e = (int)(intv >> 52 & 0x7FFL);
                        more = 1077 - e;
                        ivalue *= 1L << more;
                        j = i - 1;
                        lower = this.chunk[j];
                        if (more >= 32) {
                            ivalue += lower << (more -= 32);
                            lower = --j < 0 ? 0L : this.chunk[j];
                        }
                        ivalue += lower >> 32 - more;
                        lower &= (1L << 32 - more) - 1L;
                        if (ivalue < 0L) break block23;
                        intv = 0L;
                        if ((ivalue & 2L) == 0L) break block24;
                        if ((ivalue & 1L) != 0L || (ivalue & 4L) != 0L) break block25;
                        if (lower == 0L) {
                            while (j > 0) {
                                if (this.chunk[--j] == 0L) continue;
                                lower = 1L;
                                break;
                            }
                        }
                        if (lower == 0L) break block24;
                        break block25;
                    }
                    if ((-ivalue & 0x40000000000000L) == 0L) {
                        long pos = 1L << 31 - more;
                        ivalue *= 2L;
                        if ((lower & pos) != 0L) {
                            ++ivalue;
                            lower &= pos ^ 0xFFFFFFFFFFFFFFFFL;
                        }
                        --e;
                    }
                    intv = Long.MIN_VALUE;
                    if (((ivalue = -ivalue) & 3L) == 3L) break block25;
                    if ((ivalue & 3L) <= 1L || (ivalue & 4L) == 0L) break block24;
                    if (lower == 0L) {
                        while (j > 0) {
                            if (this.chunk[--j] == 0L) continue;
                            lower = 1L;
                            break;
                        }
                    }
                    if (lower != 0L) break block24;
                }
                if (((ivalue += 4L) & 0x80000000000000L) != 0L) {
                    ivalue >>= 1;
                    ++e;
                }
            }
            ivalue >>= 2;
            if ((long)(e += (i << 5) - 1023 - 52) >= 2047L) {
                return Double.longBitsToDouble(intv |= 0x7FF0000000000000L);
            }
            intv += (long)e << 52;
            return Double.longBitsToDouble(intv += ivalue & 0xFFFFFFFFFFFFFL);
        }
    }
}

