/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.ConstructorBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.wasm.WebAssemblyModuleFunctionBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyModuleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSWebAssemblyModule
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.UC_MODULE;
    public static final TruffleString WEB_ASSEMBLY_MODULE = Strings.constant("WebAssembly.Module");
    public static final JSWebAssemblyModule INSTANCE = new JSWebAssemblyModule();

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    public static boolean isJSWebAssemblyModule(Object object) {
        return object instanceof JSWebAssemblyModuleObject;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, realm.getAbstractModuleSourcePrototype());
        JSObjectUtil.putConstructorProperty(prototype, constructor);
        JSObjectUtil.putToStringTag(prototype, WEB_ASSEMBLY_MODULE);
        return prototype;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWebAssemblyModulePrototype();
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    @Override
    public JSFunctionObject createConstructorObject(JSRealm realm) {
        return realm.lookupFunctionWithPrototype(ConstructorBuiltins.BUILTINS, this.getClassName(), realm.getAbstractModuleSourceConstructor());
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, WebAssemblyModuleFunctionBuiltins.BUILTINS);
    }

    public static JSWebAssemblyModuleObject create(JSContext context, JSRealm realm, Object wasmModule, Source wasmSource) {
        return JSWebAssemblyModule.create(context, realm, INSTANCE.getIntrinsicDefaultProto(realm), wasmModule, wasmSource);
    }

    public static JSWebAssemblyModuleObject create(JSContext context, JSRealm realm, JSDynamicObject proto, Object wasmModule, Source wasmSource) {
        JSObjectFactory factory = context.getWebAssemblyModuleFactory();
        Shape shape = factory.getShape(realm, proto);
        JSWebAssemblyModuleObject newObj = factory.initProto(new JSWebAssemblyModuleObject(shape, proto, wasmModule, wasmSource), realm, proto);
        return factory.trackAllocation(newObj);
    }
}

