/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public final class JSTemporalPrecisionRecord {
    private final Object precision;
    private final TemporalUtil.Unit unit;
    private final int increment;

    private JSTemporalPrecisionRecord(Object precision, TemporalUtil.Unit unit, int increment) {
        assert (JSTemporalPrecisionRecord.isValidPrecision(precision)) : precision;
        this.precision = precision;
        this.unit = unit;
        this.increment = increment;
    }

    public static JSTemporalPrecisionRecord create(Object precision, TemporalUtil.Unit unit, int increment) {
        return new JSTemporalPrecisionRecord(precision, unit, increment);
    }

    public Object getPrecision() {
        return this.precision;
    }

    public TemporalUtil.Unit getUnit() {
        return this.unit;
    }

    public int getIncrement() {
        return this.increment;
    }

    public static boolean isValidPrecision(Object precision) {
        if (precision instanceof TruffleString) {
            TruffleString strPrecision = (TruffleString)precision;
            return Strings.equals(strPrecision, TemporalConstants.MINUTE) || Strings.equals(strPrecision, TemporalConstants.AUTO);
        }
        if (precision instanceof Integer) {
            Integer intPrecision = (Integer)precision;
            return 0 <= intPrecision || intPrecision <= 9;
        }
        return false;
    }
}

