/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.TemporalPlainMonthDayFunctionBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.TemporalPlainMonthDayPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarIdentifierNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public class JSTemporalPlainMonthDay
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final JSTemporalPlainMonthDay INSTANCE = new JSTemporalPlainMonthDay();
    public static final TruffleString CLASS_NAME = Strings.constant("PlainMonthDay");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("PlainMonthDay.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Temporal.PlainMonthDay");

    public static JSTemporalPlainMonthDayObject create(JSContext context, JSRealm realm, int isoMonth, int isoDay, TruffleString calendar, int referenceISOYear, Node node, InlinedBranchProfile errorBranch) {
        return JSTemporalPlainMonthDay.create(context, realm, INSTANCE.getIntrinsicDefaultProto(realm), isoMonth, isoDay, calendar, referenceISOYear, node, errorBranch);
    }

    @HostCompilerDirectives.InliningCutoff
    public static JSTemporalPlainMonthDayObject create(JSContext context, JSRealm realm, JSDynamicObject proto, int isoMonth, int isoDay, TruffleString calendar, int referenceISOYear, Node node, InlinedBranchProfile errorBranch) {
        if (!TemporalUtil.isoDateWithinLimits(referenceISOYear, isoMonth, isoDay)) {
            errorBranch.enter(node);
            throw TemporalErrors.createRangeErrorMonthDayOutsideRange();
        }
        JSObjectFactory factory = context.getTemporalPlainMonthDayFactory();
        Shape shape = factory.getShape(realm, proto);
        JSTemporalPlainMonthDayObject newObj = factory.initProto(new JSTemporalPlainMonthDayObject(shape, proto, isoMonth, isoDay, calendar, referenceISOYear), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, constructor);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, TemporalPlainMonthDayPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, TemporalPlainMonthDayPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, TO_STRING_TAG);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getTemporalPlainMonthDayPrototype();
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, TemporalPlainMonthDayFunctionBuiltins.BUILTINS);
    }

    public static boolean isJSTemporalPlainMonthDay(Object obj) {
        return obj instanceof JSTemporalPlainMonthDayObject;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString temporalMonthDayToString(JSTemporalPlainMonthDayObject md, TemporalUtil.ShowCalendar showCalendar) {
        TruffleString calendarString;
        TruffleString monthString = TemporalUtil.toZeroPaddedDecimalString(md.getMonth(), 2);
        TruffleString dayString = TemporalUtil.toZeroPaddedDecimalString(md.getDay(), 2);
        TruffleString calendarID = ToTemporalCalendarIdentifierNode.getUncached().executeString(md.getCalendar());
        TruffleString result = Strings.format("%s-%s", monthString, dayString);
        if (showCalendar == TemporalUtil.ShowCalendar.ALWAYS || showCalendar == TemporalUtil.ShowCalendar.CRITICAL || !TemporalConstants.ISO8601.equals(calendarID)) {
            TruffleString year = TemporalUtil.padISOYear(md.getYear());
            result = Strings.format("%s-%s", year, result);
        }
        if ((calendarString = TemporalUtil.formatCalendarAnnotation(calendarID, showCalendar)).isEmpty()) {
            return result;
        }
        return Strings.concat(result, calendarString);
    }
}

