/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl;

import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.intl.ListFormatFunctionBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.intl.ListFormatPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSListFormatObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.ConstrainedFieldPosition;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.ListFormatter;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.ULocale;

public final class JSListFormat
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("ListFormat");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("ListFormat.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Intl.ListFormat");
    public static final JSListFormat INSTANCE = new JSListFormat();

    private JSListFormat() {
    }

    public static boolean isJSListFormat(Object obj) {
        return obj instanceof JSListFormatObject;
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject listFormatPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(listFormatPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, listFormatPrototype, ListFormatPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(listFormatPrototype, TO_STRING_TAG);
        return listFormatPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, ListFormatFunctionBuiltins.BUILTINS);
    }

    public static JSListFormatObject create(JSContext context, JSRealm realm, JSDynamicObject proto) {
        InternalState state = new InternalState();
        JSObjectFactory factory = context.getListFormatFactory();
        Shape shape = factory.getShape(realm, proto);
        JSListFormatObject newObj = factory.initProto(new JSListFormatObject(shape, proto, state), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @CompilerDirectives.TruffleBoundary
    public static void setLocale(JSContext ctx, InternalState state, String[] locales) {
        Locale selectedLocale = IntlUtil.selectedLocale(ctx, locales);
        Locale strippedLocale = selectedLocale.stripExtensions();
        if (strippedLocale.toLanguageTag().equals("und")) {
            selectedLocale = ctx.getLocale();
            strippedLocale = selectedLocale.stripExtensions();
        }
        state.locale = strippedLocale.toLanguageTag();
        state.javaLocale = strippedLocale;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setupInternalListFormatter(InternalState state) {
        state.javaLocale = Locale.forLanguageTag(state.locale);
        state.listFormatter = JSListFormat.createFormatter(state.javaLocale, state.type, state.style);
    }

    public static ListFormatter getListFormatterProperty(JSListFormatObject obj) {
        return obj.getInternalState().listFormatter;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString format(JSListFormatObject listFormatObj, List<String> list) {
        ListFormatter listFormatter = JSListFormat.getListFormatterProperty(listFormatObj);
        return Strings.fromJavaString(listFormatter.format(list));
    }

    @CompilerDirectives.TruffleBoundary
    public static JSDynamicObject formatToParts(JSContext context, JSRealm realm, JSListFormatObject listFormatObj, List<String> list) {
        if (list.isEmpty()) {
            return JSArray.createConstantEmptyArray(context, realm);
        }
        ListFormatter listFormatter = JSListFormat.getListFormatterProperty(listFormatObj);
        ListFormatter.FormattedList formattedList = listFormatter.formatToValue(list);
        ArrayList<JSObject> resultParts = new ArrayList<JSObject>();
        ConstrainedFieldPosition cfPos = new ConstrainedFieldPosition();
        while (formattedList.nextPosition(cfPos)) {
            String type;
            Format.Field field = cfPos.getField();
            if (field == ListFormatter.Field.LITERAL) {
                type = "literal";
            } else {
                if (field != ListFormatter.Field.ELEMENT) continue;
                type = "element";
            }
            String value = formattedList.subSequence(cfPos.getStart(), cfPos.getLimit()).toString();
            resultParts.add(IntlUtil.makePart(context, realm, type, value));
        }
        return JSArray.createConstant(context, realm, resultParts.toArray());
    }

    private static ListFormatter createFormatter(Locale locale, String type, String style) {
        ULocale ulocale = ULocale.forLocale(locale);
        return ListFormatter.getInstance(ulocale, JSListFormat.toICUListFormatterType(type), JSListFormat.toICUListFormatterWidth(style));
    }

    private static ListFormatter.Type toICUListFormatterType(String type) {
        return switch (type) {
            case "conjunction" -> ListFormatter.Type.AND;
            case "disjunction" -> ListFormatter.Type.OR;
            case "unit" -> ListFormatter.Type.UNITS;
            default -> throw Errors.shouldNotReachHereUnexpectedValue(type);
        };
    }

    private static ListFormatter.Width toICUListFormatterWidth(String style) {
        return switch (style) {
            case "long" -> ListFormatter.Width.WIDE;
            case "narrow" -> ListFormatter.Width.NARROW;
            case "short" -> ListFormatter.Width.SHORT;
            default -> throw Errors.shouldNotReachHereUnexpectedValue(style);
        };
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObject resolvedOptions(JSContext context, JSRealm realm, JSListFormatObject listFormatObj) {
        InternalState state = listFormatObj.getInternalState();
        return state.toResolvedOptionsObject(context, realm);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getListFormatPrototype();
    }

    public static class InternalState {
        private ListFormatter listFormatter;
        private String locale;
        private Locale javaLocale;
        private String type = "conjunction";
        private String style = "long";

        JSObject toResolvedOptionsObject(JSContext context, JSRealm realm) {
            JSObject result = JSOrdinary.create(context, realm);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_LOCALE, Strings.fromJavaString(this.locale), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_TYPE, Strings.fromJavaString(this.type), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_STYLE, Strings.fromJavaString(this.style), JSAttributes.getDefault());
            return result;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setStyle(String style) {
            this.style = style;
        }
    }
}

