/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.RootCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Truffle;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameInstance;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameInstanceVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.MaterializedFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.IndirectCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.HiddenKey;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.ConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.AsyncFromSyncIteratorPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.AsyncGeneratorPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.ConstructorBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.EnumerateIteratorPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.ForInIteratorPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.FunctionPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.GeneratorPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.InstanceofNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.FunctionRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSFrameUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JavaScriptRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArgumentsArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSShape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Nullish;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyProxy;

public final class JSFunction
extends JSNonProxy {
    public static final TruffleString TYPE_NAME = Strings.FUNCTION;
    public static final TruffleString CLASS_NAME = Strings.constant("Function");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Function.prototype");
    public static final TruffleString GENERATOR_FUNCTION_NAME = Strings.constant("GeneratorFunction");
    public static final TruffleString GENERATOR_NAME = Strings.constant("Generator");
    public static final TruffleString ASYNC_FUNCTION_NAME = Strings.constant("AsyncFunction");
    public static final TruffleString ASYNC_GENERATOR_FUNCTION_NAME = Strings.constant("AsyncGeneratorFunction");
    public static final TruffleString ASYNC_GENERATOR_NAME = Strings.constant("AsyncGenerator");
    public static final TruffleString ENUMERATE_ITERATOR_PROTOTYPE_NAME = Strings.constant("[[Enumerate]].prototype");
    public static final TruffleString CALLER = Strings.CALLER;
    public static final TruffleString ARGUMENTS = Strings.ARGUMENTS;
    public static final TruffleString LENGTH = Strings.LENGTH;
    public static final TruffleString NAME = Strings.NAME;
    public static final TruffleString ORDINARY_HAS_INSTANCE = Strings.constant("OrdinaryHasInstance");
    public static final String PROGRAM_FUNCTION_NAME = ":program";
    public static final String BUILTIN_SOURCE_NAME = "<builtin>";
    public static final TruffleString TS_BUILTIN_SOURCE_NAME = Strings.constant("<builtin>");
    public static final SourceSection BUILTIN_SOURCE_SECTION = JSFunction.createBuiltinSourceSection("<builtin>");
    public static final TruffleString ASYNC_FROM_SYNC_ITERATOR_PROTOTYPE_NAME = Strings.constant("%AsyncFromSyncIteratorPrototype%");
    public static final PropertyProxy PROTOTYPE_PROXY = new ClassPrototypeProxyProperty();
    public static final PropertyProxy LENGTH_PROXY = new FunctionLengthPropertyProxy();
    public static final PropertyProxy NAME_PROXY = new FunctionNamePropertyProxy();
    public static final PropertyProxy ARGUMENTS_PROXY = new ArgumentsProxyProperty();
    public static final PropertyProxy CALLER_PROXY = new CallerProxyProperty();
    public static final Object CLASS_PROTOTYPE_PLACEHOLDER = new Object();
    public static final JSFunction INSTANCE = new JSFunction();
    public static final HiddenKey HOME_OBJECT_ID = new HiddenKey("HomeObject");
    public static final HiddenKey CLASS_ELEMENTS_ID = new HiddenKey("Elements");
    public static final HiddenKey CLASS_INITIALIZERS_ID = new HiddenKey("Initializers");
    public static final HiddenKey PRIVATE_BRAND_ID = new HiddenKey("PrivateBrand");
    private static final HiddenKey GENERATOR_FUNCTION_MARKER_ID = new HiddenKey("generator function");
    private static final HiddenKey ASYNC_GENERATOR_FUNCTION_MARKER_ID = new HiddenKey("async generator function");
    public static final HiddenKey DEBUG_SCOPE_ID = new HiddenKey("Scope");
    public static final JSDynamicObject CONSTRUCT = new Nullish();

    private JSFunction() {
    }

    public static CallTarget getCallTarget(JSFunctionObject obj) {
        return JSFunction.getFunctionData(obj).getCallTarget();
    }

    public static MaterializedFrame getEnclosingFrame(JSFunctionObject obj) {
        return obj.getEnclosingFrame();
    }

    public static JSFunctionData getFunctionData(JSFunctionObject obj) {
        return obj.getFunctionData();
    }

    private static Object getClassPrototypeField(JSFunctionObject obj) {
        return obj.getClassPrototype();
    }

    private static void setClassPrototypeField(JSFunctionObject obj, Object classPrototype) {
        obj.setClassPrototype(classPrototype);
    }

    public static JSRealm getRealm(JSFunctionObject obj) {
        return obj.getRealm();
    }

    public static JSRealm getRealm(JSFunctionObject functionObj, JSContext context, Node node) {
        JSRealm realm;
        if (context.isSingleRealm()) {
            realm = JSRealm.get(node);
            assert (realm == JSFunction.getRealm(functionObj));
        } else {
            realm = JSFunction.getRealm(functionObj);
        }
        return realm;
    }

    public static JSFunctionObject create(JSRealm realm, JSFunctionData functionData) {
        return JSFunction.create(realm, functionData, JSFrameUtil.NULL_MATERIALIZED_FRAME);
    }

    public static JSFunctionObject create(JSRealm realm, JSFunctionData functionData, MaterializedFrame enclosingFrame) {
        return JSFunction.createDefault(functionData, enclosingFrame, CLASS_PROTOTYPE_PLACEHOLDER, realm);
    }

    public static JSFunctionObject createWithPrototype(JSRealm realm, JSFunctionData functionData, JSDynamicObject prototype) {
        return JSFunction.createWithPrototype(JSFunction.initialFactory(functionData), realm, functionData, JSFrameUtil.NULL_MATERIALIZED_FRAME, prototype);
    }

    public static JSFunctionObject createWithPrototype(JSFunctionFactory factory, JSRealm realm, JSFunctionData functionData, MaterializedFrame enclosingFrame, JSDynamicObject prototype) {
        return JSFunction.createWithPrototype(factory, functionData, enclosingFrame, CLASS_PROTOTYPE_PLACEHOLDER, realm, prototype);
    }

    public static JSFunctionObject createLexicalThis(JSRealm realm, JSFunctionData functionData, MaterializedFrame enclosingFrame, Object lexicalThis) {
        return JSFunction.createDefault(functionData, enclosingFrame, lexicalThis, realm);
    }

    @HostCompilerDirectives.InliningCutoff
    private static JSFunctionObject createDefault(JSFunctionData functionData, MaterializedFrame enclosingFrame, Object classPrototype, JSRealm realm) {
        JSFunctionFactory factory = JSFunction.initialFactory(functionData);
        return factory.create(functionData, enclosingFrame, classPrototype, realm);
    }

    private static JSFunctionObject createWithPrototype(JSFunctionFactory factory, JSFunctionData functionData, MaterializedFrame enclosingFrame, Object classPrototype, JSRealm realm, JSDynamicObject prototype) {
        return factory.createWithPrototype(functionData, enclosingFrame, classPrototype, realm, prototype);
    }

    public static JSFunctionObject createBound(JSContext context, JSRealm realm, JSFunctionData functionData, Object boundTargetFunction, Object boundThis, Object[] boundArguments) {
        JSFunctionFactory factory = context.getBoundFunctionFactory(functionData);
        return factory.createBound(functionData, CLASS_PROTOTYPE_PLACEHOLDER, realm, boundTargetFunction, boundThis, boundArguments);
    }

    public static JSFunctionObject createWrapped(JSContext context, JSRealm realm, JSFunctionData functionData, Object wrappedTargetFunction) {
        JSFunctionFactory factory = context.getWrappedFunctionFactory();
        return factory.createWrapped(functionData, realm, wrappedTargetFunction);
    }

    private static JSFunctionFactory initialFactory(JSFunctionData functionData) {
        return functionData.getContext().getFunctionFactory(functionData);
    }

    public static TruffleString getName(JSFunctionObject obj) {
        return JSFunction.getFunctionData(obj).getName();
    }

    public static Object call(JSFunctionObject functionObject, Object thisObject, Object[] argumentValues) {
        assert (thisObject != null);
        Object[] arguments = JSArguments.create(thisObject, functionObject, argumentValues);
        return JSFunction.getCallTarget(functionObject).call(arguments);
    }

    public static Object call(Object[] jsArguments) {
        assert (JSFunction.isJSFunction(JSArguments.getFunctionObject(jsArguments)));
        assert (JSArguments.getThisObject(jsArguments) != null);
        return JSFunction.getCallTarget((JSFunctionObject)JSArguments.getFunctionObject(jsArguments)).call(jsArguments);
    }

    public static Object construct(JSFunctionObject functionObject, Object[] argumentValues) {
        assert (JSFunction.isConstructor(functionObject));
        Object[] arguments = JSArguments.create(CONSTRUCT, functionObject, argumentValues);
        return JSFunction.getConstructTarget(functionObject).call(arguments);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSFunctionObject bind(JSRealm realm, JSFunctionObject thisFnObj, Object thisArg, Object[] boundArguments) {
        TruffleString targetName;
        Object targetLen;
        JSContext context = realm.getContext();
        JSDynamicObject proto = JSObject.getPrototype(thisFnObj);
        JSFunctionObject boundFunction = JSFunction.boundFunctionCreate(context, thisFnObj, thisArg, boundArguments, proto, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), null);
        long length = 0L;
        boolean targetHasLength = JSObject.hasOwnProperty((JSDynamicObject)thisFnObj, LENGTH);
        boolean mustSetLength = true;
        if (targetHasLength && JSRuntime.isNumber(targetLen = JSObject.get((JSDynamicObject)thisFnObj, LENGTH))) {
            long targetLenInt = JSRuntime.toInteger((Number)targetLen);
            length = Math.max(0L, targetLenInt - (long)boundArguments.length);
            if (targetLenInt == (long)JSFunction.getLength(thisFnObj)) {
                mustSetLength = false;
            }
        }
        if (mustSetLength) {
            JSFunction.setFunctionLength(boundFunction, JSRuntime.longToIntOrDouble(length));
        }
        if (!(targetName = JSFunction.getFunctionName(thisFnObj)).equals(JSFunction.getName(thisFnObj))) {
            JSFunction.setBoundFunctionName(boundFunction, targetName);
        }
        return boundFunction;
    }

    public static JSFunctionObject boundFunctionCreate(JSContext context, JSFunctionObject boundTargetFunction, Object boundThis, Object[] boundArguments, JSDynamicObject proto, InlinedConditionProfile isConstructorProfile, InlinedConditionProfile isAsyncProfile, InlinedConditionProfile setProtoProfile, Node node) {
        boolean needSetProto;
        CompilerAsserts.partialEvaluationConstant(context);
        JSFunctionData targetFunctionData = JSFunction.getFunctionData(boundTargetFunction);
        boolean constructor = isConstructorProfile.profile(node, targetFunctionData.isConstructor());
        boolean isAsync = isAsyncProfile.profile(node, targetFunctionData.isAsync());
        JSFunctionData boundFunctionData = context.getBoundFunctionData(constructor, isAsync);
        JSRealm realm = JSFunction.getRealm(boundTargetFunction, context, node);
        JSFunctionObject boundFunction = JSFunction.createBound(context, realm, boundFunctionData, boundTargetFunction, boundThis, boundArguments);
        boolean bl = needSetProto = proto != realm.getFunctionPrototype();
        if (setProtoProfile.profile(node, needSetProto)) {
            JSObject.setPrototype(boundFunction, proto);
        }
        assert (JSObject.getPrototype(boundFunction) == proto);
        return boundFunction;
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString getFunctionName(JSDynamicObject thisFnObj) {
        Object name = JSObject.get(thisFnObj, NAME);
        if (!(name instanceof TruffleString)) {
            return Strings.EMPTY_STRING;
        }
        TruffleString nameStr = (TruffleString)name;
        return nameStr;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setFunctionLength(JSDynamicObject functionObj, Number length) {
        JSObject.defineOwnProperty(functionObj, LENGTH, PropertyDescriptor.createData(length, false, false, true));
    }

    @CompilerDirectives.TruffleBoundary
    public static void setFunctionName(JSDynamicObject functionObj, TruffleString name) {
        JSObject.defineOwnProperty(functionObj, NAME, PropertyDescriptor.createData(name, false, false, true));
    }

    @CompilerDirectives.TruffleBoundary
    public static void setBoundFunctionName(JSDynamicObject boundFunction, TruffleString targetName) {
        JSObject.defineOwnProperty(boundFunction, NAME, PropertyDescriptor.createData(Strings.concat(Strings.BOUND_SPC, targetName), false, false, true));
    }

    public static boolean isStrict(JSFunctionObject obj) {
        return JSFunction.getFunctionData(obj).isStrict();
    }

    public static boolean isBuiltin(JSFunctionObject obj) {
        return JSFunction.getFunctionData(obj).isBuiltin();
    }

    public static boolean isConstructor(JSFunctionObject obj) {
        return JSFunction.getFunctionData(obj).isConstructor();
    }

    public static boolean isConstructor(Object obj) {
        JSFunctionObject function;
        return obj instanceof JSFunctionObject && JSFunction.getFunctionData(function = (JSFunctionObject)obj).isConstructor();
    }

    public static boolean isGenerator(JSFunctionObject obj) {
        return JSFunction.getFunctionData(obj).isGenerator();
    }

    public static boolean needsParentFrame(JSFunctionObject obj) {
        return JSFunction.getFunctionData(obj).needsParentFrame();
    }

    public static int getLength(JSFunctionObject obj) {
        return JSFunction.getFunctionData(obj).getLength();
    }

    public static boolean isClassPrototypeInitialized(JSFunctionObject thisObj) {
        return JSFunction.getClassPrototypeField(thisObj) != CLASS_PROTOTYPE_PLACEHOLDER;
    }

    public static boolean isBoundFunction(Object function) {
        return function instanceof JSFunctionObject.Bound;
    }

    public static boolean isAsyncFunction(JSFunctionObject function) {
        return JSFunction.getFunctionData(function).isAsync();
    }

    public static Object getLexicalThis(JSFunctionObject thisObj) {
        return JSFunction.getClassPrototypeInitialized(thisObj);
    }

    public static Object getClassPrototypeInitialized(JSFunctionObject thisObj) {
        Object classPrototype = JSFunction.getClassPrototypeField(thisObj);
        assert (classPrototype != CLASS_PROTOTYPE_PLACEHOLDER);
        return classPrototype;
    }

    public static Object getClassPrototype(JSFunctionObject thisObj) {
        Object classPrototype = JSFunction.getClassPrototypeField(thisObj);
        if (CompilerDirectives.injectBranchProbability(1.0E-4, classPrototype == CLASS_PROTOTYPE_PLACEHOLDER)) {
            JSFunction.initializeClassPrototype(thisObj);
            classPrototype = JSFunction.getClassPrototypeField(thisObj);
        }
        return classPrototype;
    }

    private static void initializeClassPrototype(JSFunctionObject thisObj) {
        assert (!JSFunction.isClassPrototypeInitialized(thisObj));
        JSFunction.setClassPrototypeField(thisObj, JSFunction.createPrototype(thisObj));
    }

    @CompilerDirectives.TruffleBoundary
    private static JSDynamicObject createPrototype(JSFunctionObject constructor) {
        JSFunctionData functionData = JSFunction.getFunctionData(constructor);
        JSRealm realm = JSFunction.getRealm(constructor);
        JSContext context = functionData.getContext();
        if (!functionData.isGenerator()) {
            JSObject prototype = JSOrdinary.create(context, realm);
            JSObjectUtil.putConstructorProperty(prototype, constructor);
            return prototype;
        }
        assert (functionData.isGenerator());
        if (functionData.isAsync()) {
            return JSOrdinary.createWithRealm(context, context.getAsyncGeneratorObjectPrototypeFactory(), realm);
        }
        return JSOrdinary.createWithRealm(context, context.getGeneratorObjectPrototypeFactory(), realm);
    }

    public static void setClassPrototype(JSFunctionObject thisObj, Object value) {
        assert (value != null);
        JSFunction.setClassPrototypeField(thisObj, value);
    }

    public static RootNode createBoundRootNode(JSContext context, boolean construct, boolean newTarget) {
        if (newTarget) {
            return new BoundConstructNewTargetRootNode(context);
        }
        if (construct) {
            return new BoundConstructRootNode(context);
        }
        return new BoundRootNode(context);
    }

    public static JSFunctionObject createFunctionPrototype(JSRealm realm, JSDynamicObject objectPrototype) {
        JSContext context = realm.getContext();
        Shape protoShape = JSShape.createPrototypeShape(context, INSTANCE, objectPrototype);
        JSFunctionObject proto = JSFunctionObject.create(protoShape, objectPrototype, JSFunction.createEmptyFunctionData(context), JSFrameUtil.NULL_MATERIALIZED_FRAME, realm, CLASS_PROTOTYPE_PLACEHOLDER);
        JSObjectUtil.setOrVerifyPrototype(context, proto, objectPrototype);
        JSObjectUtil.putDataProperty(proto, LENGTH, 0, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putDataProperty(proto, NAME, Strings.EMPTY_STRING, JSAttributes.configurableNotEnumerableNotWritable());
        return proto;
    }

    public static void addRestrictedFunctionProperties(JSRealm realm, JSDynamicObject obj) {
        JSObjectUtil.putBuiltinAccessorProperty(obj, CALLER, realm.getThrowerAccessor());
        JSObjectUtil.putBuiltinAccessorProperty(obj, ARGUMENTS, realm.getThrowerAccessor());
    }

    public static JSFunctionData createNamedEmptyFunctionData(JSContext context, TruffleString name) {
        return context.getNamedEmptyFunctionData(name);
    }

    public static JSFunctionData createEmptyFunctionData(JSContext context) {
        return JSFunction.createNamedEmptyFunctionData(context, Strings.EMPTY_STRING);
    }

    public static JSFunctionObject createNamedEmptyFunction(JSRealm realm, TruffleString name) {
        return JSFunction.create(realm, JSFunction.createNamedEmptyFunctionData(realm.getContext(), name));
    }

    public static JSFunctionObject createEmptyFunction(JSRealm realm) {
        return JSFunction.create(realm, JSFunction.createEmptyFunctionData(realm.getContext()));
    }

    public static void fillFunctionPrototype(JSRealm realm) {
        JSContext ctx = realm.getContext();
        JSObjectUtil.putConstructorProperty(realm.getFunctionPrototype(), realm.getFunctionConstructor());
        JSObjectUtil.putFunctionsFromContainer(realm, realm.getFunctionPrototype(), FunctionPrototypeBuiltins.BUILTINS);
        if (ctx.getEcmaScriptVersion() >= 6) {
            JSFunction.addRestrictedFunctionProperties(realm, realm.getFunctionPrototype());
        }
        if (ctx.isOptionNashornCompatibilityMode()) {
            JSObjectUtil.putFunctionsFromContainer(realm, realm.getFunctionPrototype(), FunctionPrototypeBuiltins.BUILTINS_NASHORN_COMPAT);
        }
    }

    public static Shape makeFunctionShape(JSContext context, JSDynamicObject prototype, boolean isGenerator, boolean isAsync) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        if (isGenerator) {
            initialShape = Shape.newBuilder(initialShape).addConstantProperty(isAsync ? ASYNC_GENERATOR_FUNCTION_MARKER_ID : GENERATOR_FUNCTION_MARKER_ID, null, 0).build();
        }
        return initialShape;
    }

    public static JSFunctionObject createFunctionConstructor(JSRealm realm) {
        JSFunctionObject functionConstructor = realm.lookupFunction(ConstructorBuiltins.BUILTINS, CLASS_NAME);
        JSObjectUtil.putDataProperty(functionConstructor, JSObject.PROTOTYPE, realm.getFunctionPrototype(), JSAttributes.notConfigurableNotEnumerableNotWritable());
        return functionConstructor;
    }

    @Override
    public boolean hasOnlyShapeProperties(JSDynamicObject obj) {
        return true;
    }

    public static CallTarget getConstructTarget(JSFunctionObject obj) {
        return JSFunction.getFunctionData(obj).getConstructTarget();
    }

    public static CallTarget getConstructNewTarget(JSFunctionObject obj) {
        return JSFunction.getFunctionData(obj).getConstructNewTarget();
    }

    public static boolean isJSFunction(Object obj) {
        return obj instanceof JSFunctionObject;
    }

    public static JSObject createGeneratorFunctionPrototype(JSRealm realm, JSDynamicObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, realm.getFunctionPrototype());
        JSObjectUtil.putDataProperty(prototype, JSObject.CONSTRUCTOR, constructor, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putDataProperty(prototype, JSObject.PROTOTYPE, JSFunction.createGeneratorPrototype(realm, prototype), JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putToStringTag(prototype, GENERATOR_FUNCTION_NAME);
        return prototype;
    }

    private static JSObject createGeneratorPrototype(JSRealm realm, JSDynamicObject constructor) {
        JSObject generatorPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, realm.getIteratorPrototype());
        JSObjectUtil.putFunctionsFromContainer(realm, generatorPrototype, GeneratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(generatorPrototype, JSObject.CONSTRUCTOR, constructor, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putToStringTag(generatorPrototype, GENERATOR_NAME);
        return generatorPrototype;
    }

    public static JSConstructor createGeneratorFunctionConstructor(JSRealm realm) {
        JSFunctionObject constructor = realm.lookupFunction(ConstructorBuiltins.BUILTINS, GENERATOR_FUNCTION_NAME);
        JSObject.setPrototype(constructor, realm.getFunctionConstructor());
        JSObject prototype = JSFunction.createGeneratorFunctionPrototype(realm, constructor);
        JSObjectUtil.putDataProperty(constructor, JSObject.PROTOTYPE, prototype, JSAttributes.notConfigurableNotEnumerableNotWritable());
        return new JSConstructor(constructor, prototype);
    }

    public static JSObject createAsyncFunctionPrototype(JSRealm realm, JSDynamicObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, realm.getFunctionPrototype());
        JSObjectUtil.putDataProperty(prototype, JSObject.CONSTRUCTOR, constructor, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putToStringTag(prototype, ASYNC_FUNCTION_NAME);
        return prototype;
    }

    public static JSConstructor createAsyncFunctionConstructor(JSRealm realm) {
        JSFunctionObject constructor = realm.lookupFunction(ConstructorBuiltins.BUILTINS, ASYNC_FUNCTION_NAME);
        JSObject.setPrototype(constructor, realm.getFunctionConstructor());
        JSObject prototype = JSFunction.createAsyncFunctionPrototype(realm, constructor);
        JSObjectUtil.putDataProperty(constructor, JSObject.PROTOTYPE, prototype, JSAttributes.notConfigurableNotEnumerableNotWritable());
        return new JSConstructor(constructor, prototype);
    }

    public static JSObject createAsyncIteratorPrototype(JSRealm realm) {
        JSContext context = realm.getContext();
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSFunctionData functionData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.FunctionAsyncIterator, c -> JSFunctionData.createCallOnly(context, new JavaScriptRootNode(context.getLanguage(), null, null){

            @Override
            public Object execute(VirtualFrame frame) {
                return JSFrameUtil.getThisObj(frame);
            }
        }.getCallTarget(), 0, Symbol.SYMBOL_ASYNC_ITERATOR.toFunctionNameString()));
        JSFunctionObject asyncIterator = JSFunction.create(realm, functionData);
        JSObjectUtil.putDataProperty(prototype, Symbol.SYMBOL_ASYNC_ITERATOR, asyncIterator, JSAttributes.getDefaultNotEnumerable());
        return prototype;
    }

    public static JSObject createAsyncFromSyncIteratorPrototype(JSRealm realm) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, AsyncFromSyncIteratorPrototypeBuiltins.BUILTINS);
        return prototype;
    }

    public static JSObject createAsyncGeneratorFunctionPrototype(JSRealm realm, JSDynamicObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, realm.getFunctionPrototype());
        JSObjectUtil.putDataProperty(prototype, JSObject.CONSTRUCTOR, constructor, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putDataProperty(prototype, JSObject.PROTOTYPE, JSFunction.createAsyncGeneratorPrototype(realm, prototype), JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putToStringTag(prototype, ASYNC_GENERATOR_FUNCTION_NAME);
        return prototype;
    }

    private static JSObject createAsyncGeneratorPrototype(JSRealm realm, JSDynamicObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, realm.getAsyncIteratorPrototype());
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, AsyncGeneratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(prototype, JSObject.CONSTRUCTOR, constructor, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putToStringTag(prototype, ASYNC_GENERATOR_NAME);
        return prototype;
    }

    public static JSConstructor createAsyncGeneratorFunctionConstructor(JSRealm realm) {
        JSFunctionObject constructor = realm.lookupFunction(ConstructorBuiltins.BUILTINS, ASYNC_GENERATOR_FUNCTION_NAME);
        JSObject.setPrototype(constructor, realm.getFunctionConstructor());
        JSObject prototype = JSFunction.createAsyncGeneratorFunctionPrototype(realm, constructor);
        JSObjectUtil.putDataProperty(constructor, JSObject.PROTOTYPE, prototype, JSAttributes.notConfigurableNotEnumerableNotWritable());
        return new JSConstructor(constructor, prototype);
    }

    public static JSDynamicObject createEnumerateIteratorPrototype(JSRealm realm) {
        JSDynamicObject iteratorPrototype = realm.getIteratorPrototype();
        JSObject enumerateIteratorPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, iteratorPrototype);
        JSObjectUtil.putFunctionsFromContainer(realm, enumerateIteratorPrototype, EnumerateIteratorPrototypeBuiltins.BUILTINS);
        return enumerateIteratorPrototype;
    }

    public static Shape makeInitialEnumerateIteratorShape(JSContext context, JSDynamicObject enumerateIteratorPrototype) {
        return JSObjectUtil.getProtoChildShape(enumerateIteratorPrototype, JSOrdinary.INSTANCE, context);
    }

    public static JSDynamicObject createForInIteratorPrototype(JSRealm realm) {
        JSDynamicObject iteratorPrototype = realm.getIteratorPrototype();
        JSObject enumerateIteratorPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, iteratorPrototype);
        JSObjectUtil.putFunctionsFromContainer(realm, enumerateIteratorPrototype, ForInIteratorPrototypeBuiltins.BUILTINS);
        return enumerateIteratorPrototype;
    }

    public static JSDynamicObject createOrdinaryHasInstanceFunction(JSRealm realm) {
        JSContext ctx = realm.getContext();
        return JSFunction.create(realm, ctx.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.OrdinaryHasInstance, c -> JSFunctionData.createCallOnly(c, new InstanceofNode.OrdinaryHasInstanceRootNode((JSContext)c).getCallTarget(), 1, ORDINARY_HAS_INSTANCE)));
    }

    public static RootNode getFrameRootNode(FrameInstance frameInstance) {
        Node callNode = frameInstance.getCallNode();
        if (callNode != null) {
            return callNode.getRootNode();
        }
        CallTarget callTarget = frameInstance.getCallTarget();
        if (callTarget instanceof RootCallTarget) {
            return ((RootCallTarget)callTarget).getRootNode();
        }
        return null;
    }

    public static SourceSection createBuiltinSourceSection(String name) {
        return Source.newBuilder("js", "", name).internal(true).build().createUnavailableSection();
    }

    public static boolean isBuiltinSourceSection(SourceSection sourceSection) {
        return sourceSection == BUILTIN_SOURCE_SECTION;
    }

    public static boolean isBuiltinThatShouldNotAppearInStackTrace(JSRealm realm, JSDynamicObject function) {
        return function == realm.getApplyFunctionObject() || function == realm.getCallFunctionObject() || function == realm.getReflectApplyFunctionObject() || function == realm.getReflectConstructFunctionObject();
    }

    public static boolean isStrictBuiltin(JSFunctionObject function, JSRealm realm) {
        JSFunctionData functionData = JSFunction.getFunctionData(function);
        PropertyDescriptor desc = JSObject.getOwnProperty(realm.getArrayPrototype(), functionData.getName());
        return desc != null && desc.isDataDescriptor() && desc.getValue() == function;
    }

    public static Source getCallerSource() {
        SourceSection callerSourceSection;
        RootNode callerRootNode = Truffle.getRuntime().iterateFrames(JSFunction::getFrameRootNode, 1);
        if (callerRootNode != null && (callerSourceSection = callerRootNode.getSourceSection()) != null && callerSourceSection.isAvailable()) {
            return callerSourceSection.getSource();
        }
        return null;
    }

    static final class BoundConstructNewTargetRootNode
    extends BoundRootNode {
        BoundConstructNewTargetRootNode(JSContext context) {
            super(context);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] originalArguments = frame.getArguments();
            JSFunctionObject.Bound boundFunction = (JSFunctionObject.Bound)JSArguments.getFunctionObject(originalArguments);
            Object boundTargetFunction = boundFunction.getBoundTargetFunction();
            Object[] boundArguments = boundFunction.getBoundArguments();
            Object[] argumentValues = JSArguments.extractUserArguments(originalArguments, 1);
            Object[] arguments = BoundConstructNewTargetRootNode.prependBoundArguments(boundArguments, argumentValues);
            Object originalThis = JSArguments.getThisObject(originalArguments);
            if (this.jsFunctionProfile.profile(JSFunction.isJSFunction(boundTargetFunction))) {
                Object newTarget = JSArguments.getNewTarget(originalArguments);
                if (newTarget == boundFunction) {
                    newTarget = boundTargetFunction;
                }
                Object[] newArguments = JSArguments.createWithNewTarget(originalThis, boundTargetFunction, newTarget, arguments);
                return this.callNode.call(JSFunction.getFunctionData((JSFunctionObject)boundTargetFunction).getConstructNewTarget(this.initProfile), newArguments);
            }
            return JSRuntime.construct(boundTargetFunction, arguments);
        }
    }

    static final class BoundConstructRootNode
    extends BoundRootNode {
        BoundConstructRootNode(JSContext context) {
            super(context);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] originalArguments = frame.getArguments();
            JSFunctionObject.Bound boundFunction = (JSFunctionObject.Bound)JSArguments.getFunctionObject(originalArguments);
            Object boundTargetFunction = boundFunction.getBoundTargetFunction();
            Object[] boundArguments = boundFunction.getBoundArguments();
            Object[] argumentValues = JSArguments.extractUserArguments(originalArguments);
            Object[] arguments = BoundConstructRootNode.prependBoundArguments(boundArguments, argumentValues);
            Object originalThis = JSArguments.getThisObject(originalArguments);
            if (this.jsFunctionProfile.profile(JSFunction.isJSFunction(boundTargetFunction))) {
                Object[] newArguments = JSArguments.create(originalThis, boundTargetFunction, arguments);
                return this.callNode.call(JSFunction.getFunctionData((JSFunctionObject)boundTargetFunction).getConstructTarget(this.initProfile), newArguments);
            }
            return JSRuntime.construct(boundTargetFunction, arguments);
        }
    }

    static class BoundRootNode
    extends JavaScriptRootNode {
        private static final SourceSection SOURCE_SECTION = JSFunction.createBuiltinSourceSection("bound function");
        @Node.Child
        protected IndirectCallNode callNode;
        protected final BranchProfile initProfile = BranchProfile.create();
        protected final ConditionProfile jsFunctionProfile = ConditionProfile.create();

        BoundRootNode(JSContext context) {
            super(context.getLanguage(), SOURCE_SECTION, null);
            this.callNode = Truffle.getRuntime().createIndirectCallNode();
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] originalArguments = frame.getArguments();
            JSFunctionObject.Bound boundFunction = (JSFunctionObject.Bound)JSArguments.getFunctionObject(originalArguments);
            Object boundTargetFunction = boundFunction.getBoundTargetFunction();
            Object[] boundArguments = boundFunction.getBoundArguments();
            Object boundThis = boundFunction.getBoundThis();
            Object[] argumentValues = JSArguments.extractUserArguments(originalArguments);
            Object[] arguments = BoundRootNode.prependBoundArguments(boundArguments, argumentValues);
            if (this.jsFunctionProfile.profile(JSFunction.isJSFunction(boundTargetFunction))) {
                Object[] newArguments = JSArguments.create(boundThis, boundTargetFunction, arguments);
                return this.callNode.call(JSFunction.getFunctionData((JSFunctionObject)boundTargetFunction).getCallTarget(this.initProfile), newArguments);
            }
            return JSRuntime.call(boundTargetFunction, boundThis, arguments);
        }

        protected static Object[] prependBoundArguments(Object[] boundArguments, Object[] argumentValues) {
            Object[] arguments = new Object[boundArguments.length + argumentValues.length];
            System.arraycopy(boundArguments, 0, arguments, 0, boundArguments.length);
            System.arraycopy(argumentValues, 0, arguments, boundArguments.length, argumentValues.length);
            return arguments;
        }
    }

    public static final class ClassPrototypeProxyProperty
    extends PropertyProxy {
        private ClassPrototypeProxyProperty() {
        }

        @Override
        public boolean set(JSDynamicObject store, Object value) {
            JSFunction.setClassPrototype((JSFunctionObject)store, value);
            return true;
        }

        @Override
        public Object get(JSDynamicObject store) {
            return JSFunction.getClassPrototype((JSFunctionObject)store);
        }
    }

    public static final class FunctionLengthPropertyProxy
    extends PropertyProxy {
        @Override
        public Object get(JSDynamicObject store) {
            if (store instanceof JSFunctionObject.BoundOrWrapped) {
                JSFunctionObject.BoundOrWrapped boundFunction = (JSFunctionObject.BoundOrWrapped)store;
                return boundFunction.getBoundLength();
            }
            return JSFunction.getLength((JSFunctionObject)store);
        }

        public static int getProfiled(JSDynamicObject store, BranchProfile isBoundBranch) {
            if (store instanceof JSFunctionObject.BoundOrWrapped) {
                JSFunctionObject.BoundOrWrapped boundFunction = (JSFunctionObject.BoundOrWrapped)store;
                isBoundBranch.enter();
                return boundFunction.getBoundLength();
            }
            return JSFunction.getLength((JSFunctionObject)store);
        }
    }

    public static final class FunctionNamePropertyProxy
    extends PropertyProxy {
        @Override
        public TruffleString get(JSDynamicObject store) {
            if (store instanceof JSFunctionObject.BoundOrWrapped) {
                JSFunctionObject.BoundOrWrapped boundFunction = (JSFunctionObject.BoundOrWrapped)store;
                return boundFunction.getBoundName();
            }
            return JSFunction.getName((JSFunctionObject)store);
        }

        public static Object getProfiled(JSDynamicObject store, BranchProfile isBoundBranch) {
            if (store instanceof JSFunctionObject.BoundOrWrapped) {
                JSFunctionObject.BoundOrWrapped boundFunction = (JSFunctionObject.BoundOrWrapped)store;
                isBoundBranch.enter();
                return boundFunction.getBoundName();
            }
            return JSFunction.getName((JSFunctionObject)store);
        }
    }

    public static final class ArgumentsProxyProperty
    extends PropertyProxy {
        private ArgumentsProxyProperty() {
        }

        @Override
        public Object get(JSDynamicObject thiz) {
            JSFunctionObject thisFunction = (JSFunctionObject)thiz;
            assert (!JSFunction.getFunctionData(thisFunction).hasStrictFunctionProperties() && JSFunction.getFunctionData(thisFunction).getContext().isOptionV8CompatibilityMode());
            return JSRuntime.toJSNull(ArgumentsProxyProperty.createArguments(thisFunction));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object createArguments(final JSFunctionObject thisFunction) {
            final JSFunctionData thisFunctionData = JSFunction.getFunctionData(thisFunction);
            return Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<Object>(){

                @Override
                public Object visitFrame(FrameInstance frameInstance) {
                    Frame frame;
                    Object function;
                    CompilerAsserts.neverPartOfCompilation();
                    RootNode rootNode = JSFunction.getFrameRootNode(frameInstance);
                    if (rootNode instanceof FunctionRootNode && ((FunctionRootNode)rootNode).getFunctionData() == thisFunctionData && (function = JSArguments.getFunctionObject((frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE)).getArguments())) == thisFunction) {
                        JSRealm realm = JSRealm.get(null);
                        Object[] userArguments = JSArguments.extractUserArguments(frame.getArguments());
                        return JSArgumentsArray.createNonStrictSlow(realm, userArguments, (JSFunctionObject)function);
                    }
                    return null;
                }
            });
        }
    }

    public static final class CallerProxyProperty
    extends PropertyProxy {
        private CallerProxyProperty() {
        }

        @Override
        public Object get(JSDynamicObject thiz) {
            JSFunctionObject thisFunction = (JSFunctionObject)thiz;
            assert (!JSFunction.getFunctionData(thisFunction).hasStrictFunctionProperties() && JSFunction.getFunctionData(thisFunction).getContext().isOptionV8CompatibilityMode());
            return JSRuntime.toJSNull(CallerProxyProperty.findCaller(thisFunction));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object findCaller(final JSFunctionObject thisFunction) {
            final JSFunctionData thisFunctionData = JSFunction.getFunctionData(thisFunction);
            return Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<Object>(){
                private boolean seenThisFunction = false;

                @Override
                public Object visitFrame(FrameInstance frameInstance) {
                    CompilerAsserts.neverPartOfCompilation();
                    RootNode rootNode = JSFunction.getFrameRootNode(frameInstance);
                    if (rootNode instanceof FunctionRootNode) {
                        Frame frame;
                        Object function;
                        if (this.seenThisFunction) {
                            Frame frame2 = frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE);
                            Object function2 = JSArguments.getFunctionObject(frame2.getArguments());
                            if (!JSFunction.isJSFunction(function2)) {
                                return null;
                            }
                            JSFunctionObject callerFunction = (JSFunctionObject)function2;
                            SourceSection ss = rootNode.getSourceSection();
                            if (ss == null) {
                                return null;
                            }
                            if (ss.getSource().isInternal() && !JSFunction.isBuiltinSourceSection(ss)) {
                                return null;
                            }
                            JSFunctionData functionData = JSFunction.getFunctionData(callerFunction);
                            if (JSFunction.isBuiltinSourceSection(ss)) {
                                JSRealm realm = JSRealm.get(null);
                                if (callerFunction == realm.getEvalFunctionObject()) {
                                    return null;
                                }
                                if (JSFunction.isBuiltinThatShouldNotAppearInStackTrace(realm, callerFunction)) {
                                    return null;
                                }
                                if (Strings.startsWith(functionData.getName(), Strings.BRACKET_SYMBOL_DOT)) {
                                    return null;
                                }
                                if (JSFunction.isStrictBuiltin(callerFunction, realm)) {
                                    return Null.instance;
                                }
                            } else if (functionData.isStrict()) {
                                return Null.instance;
                            }
                            if (!JSFunction.PROGRAM_FUNCTION_NAME.equals(rootNode.getName())) {
                                return callerFunction;
                            }
                        } else if (((FunctionRootNode)rootNode).getFunctionData() == thisFunctionData && (function = JSArguments.getFunctionObject((frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE)).getArguments())) == thisFunction) {
                            this.seenThisFunction = true;
                        }
                    }
                    return null;
                }
            });
        }
    }

    public static enum AsyncGeneratorState {
        SuspendedStart,
        SuspendedYield,
        Executing,
        AwaitingReturn,
        Completed;

    }

    public static enum GeneratorState {
        SuspendedStart,
        SuspendedYield,
        Executing,
        Completed;

    }
}

