/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.FinalizationRegistryPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSAgent;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JobCallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.FinalizationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFinalizationRegistryObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.AsyncContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public final class JSFinalizationRegistry
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final JSFinalizationRegistry INSTANCE = new JSFinalizationRegistry();
    public static final TruffleString CLASS_NAME = Strings.constant("FinalizationRegistry");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("FinalizationRegistry.prototype");

    private JSFinalizationRegistry() {
    }

    public static JSFinalizationRegistryObject create(JSContext context, JSRealm realm, JSDynamicObject proto, JobCallback cleanupCallback) {
        ArrayList<FinalizationRecord> cells = new ArrayList<FinalizationRecord>();
        ReferenceQueue<Object> referenceQueue = JSFinalizationRegistry.createReferenceQueue();
        JSObjectFactory factory = context.getFinalizationRegistryFactory();
        Shape shape = factory.getShape(realm, proto);
        JSFinalizationRegistryObject newObj = factory.initProto(new JSFinalizationRegistryObject(shape, proto, cleanupCallback, cells, referenceQueue), realm, proto);
        JSFinalizationRegistryObject registryObj = factory.trackAllocation(newObj);
        context.registerFinalizationRegistry(registryObj);
        return registryObj;
    }

    @CompilerDirectives.TruffleBoundary
    private static ReferenceQueue<Object> createReferenceQueue() {
        return new ReferenceQueue<Object>();
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, FinalizationRegistryPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, CLASS_NAME);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    public static boolean isJSFinalizationRegistry(Object obj) {
        return obj instanceof JSFinalizationRegistryObject;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getFinalizationRegistryPrototype();
    }

    @CompilerDirectives.TruffleBoundary
    public static void appendToCells(JSFinalizationRegistryObject finalizationRegistry, Object target, Object holdings, Object unregisterToken) {
        List<FinalizationRecord> cells = finalizationRegistry.getCells();
        ReferenceQueue<Object> queue = finalizationRegistry.getReferenceQueue();
        WeakReference<Object> weakTarget = new WeakReference<Object>(target, queue);
        cells.add(new FinalizationRecord(weakTarget, holdings, unregisterToken));
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean removeFromCells(JSFinalizationRegistryObject finalizationRegistry, Object unregisterToken) {
        List<FinalizationRecord> cells = finalizationRegistry.getCells();
        boolean removed = false;
        Iterator<FinalizationRecord> iterator = cells.iterator();
        while (iterator.hasNext()) {
            FinalizationRecord record = iterator.next();
            if (!JSRuntime.isSameValue(record.getUnregisterToken().get(), unregisterToken)) continue;
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static void cleanupFinalizationRegistry(JSFinalizationRegistryObject finalizationRegistry, Object callbackArg) {
        FinalizationRecord cell;
        Object callback;
        JSAgent agent = JSRealm.get(null).getAgent();
        AsyncContext asyncContext = null;
        if (callbackArg == Undefined.instance) {
            callback = finalizationRegistry.getCleanupCallback().callback();
            asyncContext = finalizationRegistry.getCleanupCallback().asyncContextSnapshot();
        } else {
            callback = callbackArg;
            asyncContext = agent.getAsyncContextMapping();
        }
        while ((cell = JSFinalizationRegistry.removeCellEmptyTarget(finalizationRegistry)) != null) {
            assert (cell.getWeakRefTarget().get() == null);
            AsyncContext previousContextMapping = agent.asyncContextSwap(asyncContext);
            try {
                JSRuntime.call(callback, Undefined.instance, new Object[]{cell.getHeldValue()});
            }
            finally {
                agent.asyncContextSwap(previousContextMapping);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static FinalizationRecord removeCellEmptyTarget(JSFinalizationRegistryObject finalizationRegistry) {
        List<FinalizationRecord> cells = finalizationRegistry.getCells();
        for (int i = 0; i < cells.size(); ++i) {
            FinalizationRecord record = cells.get(i);
            if (record.getWeakRefTarget().get() != null) continue;
            cells.remove(i);
            return record;
        }
        return null;
    }

    public static void hostCleanupFinalizationRegistry(JSFinalizationRegistryObject finalizationRegistry) {
        boolean performCleanup;
        ReferenceQueue<Object> queue = finalizationRegistry.getReferenceQueue();
        boolean queueNotEmpty = queue.poll() != null;
        boolean bl = performCleanup = queueNotEmpty || JSObject.getJSContext(finalizationRegistry).getLanguageOptions().testV8Mode();
        if (performCleanup) {
            Reference<Object> o;
            while ((o = queue.poll()) != null) {
            }
            JSFinalizationRegistry.cleanupFinalizationRegistry(finalizationRegistry, Undefined.instance);
        }
    }
}

