/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateUncached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneIdentifierNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZoneRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.Pair;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

@GenerateUncached
public abstract class ToTemporalTimeZoneIdentifierNode
extends JavaScriptBaseNode {
    protected ToTemporalTimeZoneIdentifierNode() {
    }

    public abstract TruffleString execute(Object var1);

    @NeverDefault
    public static ToTemporalTimeZoneIdentifierNode getUncached() {
        return ToTemporalTimeZoneIdentifierNodeGen.getUncached();
    }

    @Specialization
    protected TruffleString toTemporalTimeZoneIdentifier(Object temporalTimeZoneLike, @Cached IsObjectNode isObjectNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isTimeZoneProfile) {
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(temporalTimeZoneLike))) {
            if (isTimeZoneProfile.profile(this, TemporalUtil.isTemporalZonedDateTime(temporalTimeZoneLike))) {
                return ((JSTemporalZonedDateTimeObject)temporalTimeZoneLike).getTimeZone();
            }
            errorBranch.enter(this);
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
        if (temporalTimeZoneLike instanceof TruffleString) {
            TruffleString identifier = (TruffleString)temporalTimeZoneLike;
            JSTemporalTimeZoneRecord parseResult = TemporalUtil.parseTemporalTimeZoneString(identifier);
            TruffleString offsetMinutes = parseResult.getOffsetString();
            TruffleString name = parseResult.getName();
            if (offsetMinutes != null && name == null) {
                return TemporalUtil.formatTimeZoneOffsetString(TemporalUtil.parseTimeZoneOffsetString(offsetMinutes));
            }
            Pair<TruffleString, TruffleString> timeZoneIdentifierRecord = TemporalUtil.getAvailableNamedTimeZoneIdentifier(name);
            if (timeZoneIdentifierRecord == null) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorInvalidTimeZoneString();
            }
            return timeZoneIdentifierRecord.getFirst();
        }
        errorBranch.enter(this);
        throw Errors.createTypeErrorNotAString(temporalTimeZoneLike);
    }
}

