/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalInstantNode
extends JavaScriptBaseNode {
    protected ToTemporalInstantNode() {
    }

    public abstract JSTemporalInstantObject execute(Object var1);

    @Specialization
    public JSTemporalInstantObject toTemporalDateTime(Object item, @Cached IsObjectNode isObjectNode, @Cached JSToPrimitiveNode toPrimitiveNode, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedBranchProfile errorBranch) {
        Object primitiveItem;
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(item))) {
            BigInt nanoseconds = null;
            if (item instanceof JSTemporalInstantObject) {
                JSTemporalInstantObject instant = (JSTemporalInstantObject)item;
                nanoseconds = instant.getNanoseconds();
            }
            if (item instanceof JSTemporalZonedDateTimeObject) {
                JSTemporalZonedDateTimeObject zonedDateTime = (JSTemporalZonedDateTimeObject)item;
                nanoseconds = zonedDateTime.getNanoseconds();
            }
            if (nanoseconds != null) {
                return JSTemporalInstant.create(this.getLanguage().getJSContext(), this.getRealm(), nanoseconds);
            }
            primitiveItem = toPrimitiveNode.executeHintString(item);
        } else {
            primitiveItem = item;
        }
        if (primitiveItem instanceof TruffleString) {
            TruffleString string = (TruffleString)primitiveItem;
            BigInt epochNanoseconds = TemporalUtil.parseTemporalInstant(string);
            return JSTemporalInstant.create(this.getLanguage().getJSContext(), this.getRealm(), epochNanoseconds);
        }
        errorBranch.enter(this);
        throw Errors.createTypeErrorNotAString(primitiveItem);
    }
}

