/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarIdentifierWithISODefaultNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalDateTimeNode
extends JavaScriptBaseNode {
    protected ToTemporalDateTimeNode() {
    }

    public abstract JSTemporalPlainDateTimeObject execute(Object var1, Object var2);

    @Specialization
    public JSTemporalPlainDateTimeObject toTemporalDateTime(Object item, Object options, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isPlainDateTimeProfile, @Cached InlinedConditionProfile isZonedDateTimeProfile, @Cached InlinedConditionProfile isPlainDateProfile, @Cached InlinedBranchProfile errorBranch, @Cached IsObjectNode isObjectNode, @Cached(value="create(getJSContext())") GetOptionsObjectNode getOptionsNode, @Cached GetTemporalCalendarIdentifierWithISODefaultNode getTemporalCalendarNode, @Cached TemporalGetOptionNode getOptionNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached TruffleString.ToJavaStringNode toJavaString, @Cached TruffleString.FromJavaStringNode fromJavaString) {
        JSTemporalDateTimeRecord result;
        TruffleString calendar;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(item))) {
            if (isPlainDateTimeProfile.profile(this, item instanceof JSTemporalPlainDateTimeObject)) {
                Object resolvedOptions = getOptionsNode.execute(options);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
                JSTemporalPlainDateTimeObject pdt = (JSTemporalPlainDateTimeObject)item;
                return JSTemporalPlainDateTime.create(ctx, realm, pdt.getYear(), pdt.getMonth(), pdt.getDay(), pdt.getHour(), pdt.getMinute(), pdt.getSecond(), pdt.getMillisecond(), pdt.getMicrosecond(), pdt.getNanosecond(), pdt.getCalendar(), this, errorBranch);
            }
            if (isZonedDateTimeProfile.profile(this, TemporalUtil.isTemporalZonedDateTime(item))) {
                JSTemporalZonedDateTimeObject zdt = (JSTemporalZonedDateTimeObject)item;
                JSTemporalInstantObject instant = JSTemporalInstant.create(ctx, realm, zdt.getNanoseconds());
                JSTemporalPlainDateTimeObject isoDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, zdt.getTimeZone(), instant, zdt.getCalendar());
                Object resolvedOptions = getOptionsNode.execute(options);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
                return isoDateTime;
            }
            if (isPlainDateProfile.profile(this, item instanceof JSTemporalPlainDateObject)) {
                Object resolvedOptions = getOptionsNode.execute(options);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)item;
                return JSTemporalPlainDateTime.create(ctx, realm, date.getYear(), date.getMonth(), date.getDay(), 0, 0, 0, 0, 0, 0, date.getCalendar(), this, errorBranch);
            }
            calendar = getTemporalCalendarNode.execute(item);
            JSObject fields = TemporalUtil.prepareCalendarFields(ctx, calendar, item, TemporalUtil.listDMMCY, TemporalUtil.listTimeUnits, TemporalUtil.listEmpty);
            Object resolvedOptions = getOptionsNode.execute(options);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
            result = TemporalUtil.interpretTemporalDateTimeFields(calendar, fields, overflow, dateFromFieldsNode);
        } else if (item instanceof TruffleString) {
            TruffleString string = (TruffleString)item;
            result = TemporalUtil.parseTemporalDateTimeString(false, string);
            assert (TemporalUtil.isValidISODate(result.getYear(), result.getMonth(), result.getDay()));
            assert (TemporalUtil.isValidTime(result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond()));
            calendar = result.getCalendar();
            if (calendar == null) {
                calendar = TemporalConstants.ISO8601;
            } else {
                String calendarJLS = toJavaString.execute(calendar);
                calendar = Strings.fromJavaString(fromJavaString, IntlUtil.canonicalizeCalendar(calendarJLS));
            }
            Object resolvedOptions = getOptionsNode.execute(options);
            TemporalUtil.toTemporalOverflow(resolvedOptions, getOptionNode);
        } else {
            errorBranch.enter(this);
            throw Errors.createTypeErrorNotAString(item);
        }
        return JSTemporalPlainDateTime.create(ctx, realm, result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), calendar, this, errorBranch);
    }
}

