/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.DifferenceISODateTimeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.RoundRelativeDurationNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.ISODateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.NormalizedDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TemporalDurationWithTotalRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

@ImportStatic(value={TemporalConstants.class})
public abstract class DifferencePlainDateTimeWithRoundingNode
extends JavaScriptBaseNode {
    protected DifferencePlainDateTimeWithRoundingNode() {
    }

    public abstract TemporalDurationWithTotalRecord execute(JSTemporalPlainDateObject var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, TruffleString var17, TemporalUtil.Unit var18, int var19, TemporalUtil.Unit var20, TemporalUtil.RoundingMode var21);

    @Specialization
    static TemporalDurationWithTotalRecord differencePlainDateTimeWithRounding(JSTemporalPlainDateObject plainDate1, int h1, int min1, int s1, int ms1, int mus1, int ns1, int y2, int mon2, int d2, int h2, int min2, int s2, int ms2, int mus2, int ns2, TruffleString calendar, TemporalUtil.Unit largestUnit, int roundingIncrement, TemporalUtil.Unit smallestUnit, TemporalUtil.RoundingMode roundingMode, @Bind Node node, @Cached DifferenceISODateTimeNode differenceISODateTime, @Cached RoundRelativeDurationNode roundRelativeDuration, @Cached InlinedBranchProfile errorBranch) {
        int d1;
        int mon1;
        int y1 = plainDate1.getYear();
        if (TemporalUtil.compareISODateTime(y1, mon1 = plainDate1.getMonth(), d1 = plainDate1.getDay(), h1, min1, s1, ms1, mus1, ns1, y2, mon2, d2, h2, min2, s2, ms2, mus2, ns2) == 0) {
            return new TemporalDurationWithTotalRecord(JSTemporalDurationRecord.createZero(), 0.0);
        }
        if (!TemporalUtil.isoDateTimeWithinLimits(y1, mon1, d1, h1, min1, s1, ms1, mus1, ns1) || !TemporalUtil.isoDateTimeWithinLimits(y2, mon2, d2, h2, min2, s2, ms2, mus2, ns2)) {
            errorBranch.enter(node);
            throw TemporalErrors.createRangeErrorDateOutsideRange();
        }
        NormalizedDurationRecord diff = differenceISODateTime.execute(y1, mon1, d1, h1, min1, s1, ms1, mus1, ns1, y2, mon2, d2, h2, min2, s2, ms2, mus2, ns2, calendar, largestUnit);
        if (smallestUnit == TemporalUtil.Unit.NANOSECOND && roundingIncrement == 1) {
            BigInt normWithDays = TemporalUtil.add24HourDaysToNormalizedTimeDuration(diff.normalizedTimeTotalNanoseconds(), diff.days());
            TimeDurationRecord timeResult = TemporalUtil.balanceTimeDuration(normWithDays, largestUnit);
            double total = normWithDays.doubleValue();
            JSTemporalDurationRecord durationRecord = JSTemporalDurationRecord.createWeeks(diff.years(), diff.months(), diff.weeks(), diff.days(), timeResult.hours(), timeResult.minutes(), timeResult.seconds(), timeResult.milliseconds(), timeResult.microseconds(), timeResult.nanoseconds());
            return new TemporalDurationWithTotalRecord(durationRecord, total);
        }
        ISODateTimeRecord dateTime = new ISODateTimeRecord(y1, mon1, d1, h1, min1, s1, ms1, mus1, ns1);
        BigInt destEpochNs = TemporalUtil.getUTCEpochNanoseconds(y2, mon2, d2, h2, min2, s2, ms2, mus2, ns2);
        return roundRelativeDuration.execute(diff, destEpochNs, dateTime, calendar, null, largestUnit, roundingIncrement, smallestUnit, roundingMode);
    }
}

