/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateUncached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.UnwrapPromiseNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromise;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromiseObject;

@GenerateUncached
@ImportStatic(value={JSPromise.class})
public abstract class UnwrapPromiseNode
extends JavaScriptBaseNode {
    protected UnwrapPromiseNode() {
    }

    @NeverDefault
    public static UnwrapPromiseNode create() {
        return UnwrapPromiseNodeGen.create();
    }

    public final Object execute(JSPromiseObject promise) {
        int promiseState = JSPromise.getPromiseState(promise);
        Object promiseResult = promise.getPromiseResult();
        return this.execute(promise, promiseState, promiseResult);
    }

    protected abstract Object execute(JSPromiseObject var1, int var2, Object var3);

    @Specialization(guards={"promiseState == FULFILLED"})
    protected static Object fulfilled(JSPromiseObject promise, int promiseState, Object promiseResult) {
        assert (promiseResult != null);
        return promiseResult;
    }

    @Specialization(guards={"promiseState == REJECTED"})
    protected final Object rejected(JSPromiseObject promise, int promiseState, Object promiseResult) {
        assert (promiseResult != null);
        throw JSRuntime.getException(promiseResult, this);
    }

    @Specialization(guards={"promiseState == PENDING"})
    protected static Object pending(JSPromiseObject promise, int promiseState, Object promiseResult) {
        throw Errors.createTypeError("Attempt to unwrap pending promise");
    }

    @NeverDefault
    public static UnwrapPromiseNode getUncached() {
        return UnwrapPromiseNodeGen.getUncached();
    }
}

