/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.module;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir.Module;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.ValueProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.StatementNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.ExportResolution;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSModuleRecord;

public class ResolveNamedImportNode
extends StatementNode {
    private final JSContext context;
    private final Module.ModuleRequest moduleRequest;
    private final TruffleString importName;
    @Node.Child
    private JavaScriptNode moduleNode;
    @Node.Child
    private JSWriteFrameSlotNode writeLocalNode;
    private final ValueProfile moduleProfile = ValueProfile.createClassProfile();
    private final ValueProfile resolutionProfile = ValueProfile.createClassProfile();

    ResolveNamedImportNode(JSContext context, JavaScriptNode moduleNode, Module.ModuleRequest moduleRequest, TruffleString importName, JSWriteFrameSlotNode writeLocalNode) {
        this.context = context;
        this.moduleRequest = moduleRequest;
        this.moduleNode = moduleNode;
        this.importName = importName;
        this.writeLocalNode = writeLocalNode;
    }

    public static StatementNode create(JSContext context, JavaScriptNode moduleNode, Module.ModuleRequest moduleRequest, TruffleString importName, JSWriteFrameSlotNode writeLocalNode) {
        return new ResolveNamedImportNode(context, moduleNode, moduleRequest, importName, writeLocalNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        JSModuleRecord referrer = (JSModuleRecord)this.moduleNode.execute(frame);
        AbstractModuleRecord importedModule = this.moduleProfile.profile(referrer.getImportedModule(this.moduleRequest));
        ExportResolution resolution = this.resolutionProfile.profile(importedModule.resolveExport(this.importName));
        if (resolution.isNull() || resolution.isAmbiguous()) {
            String message = "The requested module '%s' does not provide an export named '%s'";
            throw Errors.createSyntaxErrorFormat(message, this, this.moduleRequest.specifier(), this.importName);
        }
        Object resolutionOrNamespace = resolution.isNamespace() ? resolution.getModule().getModuleNamespace(this.moduleRequest.phase()) : resolution;
        this.writeLocalNode.executeWrite(frame, resolutionOrNamespace);
        return EMPTY;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return ResolveNamedImportNode.create(this.context, ResolveNamedImportNode.cloneUninitialized(this.moduleNode, materializedTags), this.moduleRequest, this.importName, ResolveNamedImportNode.cloneUninitialized(this.writeLocalNode, materializedTags));
    }
}

