/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl;

import java.util.List;
import java.util.MissingResourceException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetOptionsObjectNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.InitializeSegmenterNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSSegmenter;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSSegmenterObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;

public abstract class InitializeSegmenterNode
extends JavaScriptBaseNode {
    private static final List<String> GRANULARITY_OPTION_VALUES = List.of("grapheme", "word", "sentence");
    private final JSContext context;
    @Node.Child
    JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;
    @Node.Child
    GetOptionsObjectNode getOptionsObjectNode;
    @Node.Child
    GetStringOptionNode getLocaleMatcherOption;
    @Node.Child
    GetStringOptionNode getGranularityOption;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected InitializeSegmenterNode(JSContext context) {
        this.context = context;
        this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context);
        this.getOptionsObjectNode = GetOptionsObjectNodeGen.create(context);
        this.getGranularityOption = GetStringOptionNode.create(context, IntlUtil.KEY_GRANULARITY, GRANULARITY_OPTION_VALUES, "grapheme");
        this.getLocaleMatcherOption = GetStringOptionNode.create(context, IntlUtil.KEY_LOCALE_MATCHER, GetStringOptionNode.LOCALE_MATCHER_OPTION_VALUES, "best fit");
    }

    public abstract JSSegmenterObject executeInit(JSSegmenterObject var1, Object var2, Object var3);

    public static InitializeSegmenterNode createInitalizeSegmenterNode(JSContext context) {
        return InitializeSegmenterNodeGen.create(context);
    }

    @Specialization
    public JSSegmenterObject initializeSegmenter(JSSegmenterObject segmenterObj, Object localesArg, Object optionsArg) {
        try {
            JSSegmenter.InternalState state = segmenterObj.getInternalState();
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(localesArg);
            Object options = this.getOptionsObjectNode.execute(optionsArg);
            this.getLocaleMatcherOption.executeValue(options);
            String optGranularity = this.getGranularityOption.executeValue(options);
            JSSegmenter.setLocale(this.context, state, locales);
            JSSegmenter.setupInternalBreakIterator(state, optGranularity);
        }
        catch (MissingResourceException e) {
            this.errorBranch.enter();
            throw Errors.createICU4JDataError(e);
        }
        return segmenterObj;
    }
}

