/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateUncached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.utilities.TriState;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBase;

@GenerateUncached
public abstract class ArrayElementInfoNode
extends JavaScriptBaseNode {
    public static final int READABLE = 1;
    public static final int MODIFIABLE = 2;
    public static final int INSERTABLE = 4;
    public static final int REMOVABLE = 8;
    public static final int WRITABLE = 6;

    ArrayElementInfoNode() {
    }

    public abstract TriState execute(JSArrayBase var1, long var2, int var4);

    public final boolean executeBoolean(JSArrayBase receiver, long index, int query) {
        return this.execute(receiver, index, query) == TriState.TRUE;
    }

    public final void executeCheck(JSArrayBase receiver, long index, int query) throws UnsupportedMessageException, InvalidArrayIndexException {
        TriState result = this.execute(receiver, index, query);
        if (result != TriState.TRUE) {
            if (result == TriState.UNDEFINED) {
                throw UnsupportedMessageException.create();
            }
            throw InvalidArrayIndexException.create(index);
        }
    }

    @Specialization(guards={"arrayType.isInstance(target.getArrayType())"}, limit="5")
    static TriState doCached(JSArrayBase target, long index, int query, @Cached(value="target.getArrayType()") ScriptArray arrayType) {
        if ((query & 0xE) != 0 && arrayType.isFrozen()) {
            return TriState.UNDEFINED;
        }
        if (index >= 0L && index < JSAbstractArray.arrayGetLength(target)) {
            if ((query & 1) != 0) {
                return TriState.TRUE;
            }
            if ((query & 2) != 0) {
                assert (!arrayType.isFrozen());
                return TriState.TRUE;
            }
            if ((query & 8) != 0 && !arrayType.isSealed() && !arrayType.isLengthNotWritable()) {
                return TriState.TRUE;
            }
            return TriState.FALSE;
        }
        if ((query & 4) != 0 && JSRuntime.isArrayIndex(index) && !arrayType.isSealed() && !arrayType.isLengthNotWritable()) {
            return TriState.TRUE;
        }
        return TriState.FALSE;
    }

    @Specialization(replaces={"doCached"})
    static TriState doUncached(JSArrayBase target, long index, int query) {
        return ArrayElementInfoNode.doCached(target, index, query, target.getArrayType());
    }
}

