/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetIteratorUnaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorGetNextValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.SpreadArgumentNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.SimpleArrayList;

public abstract class SpreadArgumentNode
extends JavaScriptNode {
    @Node.Child
    private GetIteratorUnaryNode getIteratorNode;
    @Node.Child
    private IteratorGetNextValueNode iteratorStepNode;
    private final JSContext context;

    protected SpreadArgumentNode(JSContext context, GetIteratorUnaryNode getIteratorNode) {
        this.context = context;
        this.getIteratorNode = getIteratorNode;
        this.iteratorStepNode = IteratorGetNextValueNode.create(context, null, JSConstantNode.create(null), false);
    }

    @Override
    public boolean isInstrumentable() {
        return false;
    }

    public static SpreadArgumentNode create(JSContext context, GetIteratorUnaryNode getIteratorNode) {
        return SpreadArgumentNodeGen.create(context, getIteratorNode);
    }

    public final Object[] execute(VirtualFrame frame) {
        SimpleArrayList<Object> argList = new SimpleArrayList<Object>();
        this.executeToList(frame, argList);
        return argList.toArray();
    }

    @Override
    public final boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        return super.executeBoolean(frame);
    }

    @Override
    public final double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        return super.executeDouble(frame);
    }

    @Override
    public final int executeInt(VirtualFrame frame) throws UnexpectedResultException {
        return super.executeInt(frame);
    }

    @Override
    public final void executeVoid(VirtualFrame frame) {
        super.executeVoid(frame);
    }

    public abstract void executeToList(VirtualFrame var1, SimpleArrayList<Object> var2);

    @Specialization
    protected final void doSpread(VirtualFrame frame, SimpleArrayList<Object> argList, @Cached InlinedBranchProfile growBranch, @Cached InlinedBranchProfile errorBranch) {
        Object nextArg;
        IteratorRecord iteratorRecord = this.getIteratorNode.execute(frame);
        while ((nextArg = this.iteratorStepNode.execute(frame, iteratorRecord)) != null) {
            if ((long)argList.size() >= this.context.getFunctionArgumentsLimit()) {
                errorBranch.enter(this);
                throw Errors.createRangeError("spreaded function argument count exceeds limit");
            }
            argList.add(nextArg, this, growBranch);
        }
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return SpreadArgumentNode.create(this.context, SpreadArgumentNode.cloneUninitialized(this.getIteratorNode, materializedTags));
    }
}

